/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.graphics.AlphaInterpolation;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Fractional;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.function.Function;
import org.jensoft.core.plugin.function.area.Area;
import org.jensoft.core.plugin.function.curve.Curve;
import org.jensoft.core.plugin.function.scatter.Scatter;
import org.jensoft.core.projection.ProjectionEvent;
import org.jensoft.core.projection.ProjectionListener;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class FunctionPlugin<F extends Function>
extends AbstractPlugin {
    private List<F> functions = new ArrayList<F>();

    public FunctionPlugin() {
        this.setAntialiasing(Antialiasing.On);
        this.setFractionalMetrics(Fractional.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setAlphaInterpolation(AlphaInterpolation.Quality);
    }

    @Override
    public void onProjectionRegister() {
        this.getProjection().addProjectionListener(new ProjectionListener(){

            @Override
            public void projectionUnlockActive(ProjectionEvent w2dEvent) {
            }

            @Override
            public void projectionLockActive(ProjectionEvent w2dEvent) {
            }

            @Override
            public void projectionBoundChanged(ProjectionEvent w2dEvent) {
                for (Function function : FunctionPlugin.this.functions) {
                    function.getPathFunction().setSolveGeometryRequest(true);
                }
            }

            @Override
            public void projectionResized(ProjectionEvent w2dEvent) {
                for (Function function : FunctionPlugin.this.functions) {
                    function.getPathFunction().setSolveGeometryRequest(true);
                }
            }
        });
    }

    public void addFunction(F function) {
        if (!this.functions.contains(function)) {
            ((Function)function).setHost(this);
            this.functions.add(function);
        }
    }

    protected abstract void paintFunctions(View var1, Graphics2D var2, ViewPart var3);

    protected void paintMetricsGlyphFunction(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        for (int c = 0; c < this.functions.size(); ++c) {
            List<GlyphMetric> metrics = ((Function)this.functions.get(c)).getPathFunction().getMetrics();
            for (GlyphMetric glyphMetric : metrics) {
                if (glyphMetric.getGlyphMetricMarkerPainter() != null) {
                    glyphMetric.getGlyphMetricMarkerPainter().paintGlyphMetric(g2d, glyphMetric);
                }
                if (glyphMetric.getGlyphMetricFill() != null) {
                    glyphMetric.getGlyphMetricFill().paintGlyphMetric(g2d, glyphMetric);
                }
                if (glyphMetric.getGlyphMetricDraw() == null) continue;
                glyphMetric.getGlyphMetricDraw().paintGlyphMetric(g2d, glyphMetric);
            }
        }
    }

    public List<F> getFunctions() {
        return this.functions;
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        this.paintFunctions(view, g2d, viewPart);
        this.paintMetricsGlyphFunction(view, g2d, viewPart);
    }

    public static class ScatterFunction
    extends FunctionPlugin<Scatter> {
        public ScatterFunction() {
            this.setName(ScatterFunction.class.getCanonicalName());
        }

        @Override
        protected void paintFunctions(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart != ViewPart.Device) {
                return;
            }
            for (int i = 0; i < this.getFunctions().size(); ++i) {
                Scatter scatterCurve = (Scatter)this.getFunctions().get(i);
                scatterCurve.getPathFunction().setProjection(this.getProjection());
                scatterCurve.getPathFunction().setFontRenderContext(g2d.getFontRenderContext());
                scatterCurve.solveScatter();
                for (Scatter.ScatterPoint scatter : scatterCurve.getScatters()) {
                    BufferedImage buffer = scatter.getPrimitive();
                    int x = (int)scatter.getDevicePoint().getX();
                    int y = (int)scatter.getDevicePoint().getY();
                    g2d.drawImage((Image)buffer, x, y, null);
                }
            }
        }
    }

    public static class CurveFunction
    extends FunctionPlugin<Curve> {
        public CurveFunction() {
            this.setName(CurveFunction.class.getCanonicalName());
        }

        @Override
        protected void paintFunctions(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart != ViewPart.Device) {
                return;
            }
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            for (int c = 0; c < this.getFunctions().size(); ++c) {
                Curve curve = (Curve)this.getFunctions().get(c);
                curve.getPathFunction().setProjection(this.getProjection());
                curve.getPathFunction().setFontRenderContext(g2d.getFontRenderContext());
                curve.getCurveDraw().paintCurve(g2d, curve);
            }
        }
    }

    public static class AreaFunction
    extends FunctionPlugin<Area> {
        public AreaFunction() {
            this.setName(AreaFunction.class.getCanonicalName());
        }

        @Override
        protected void paintFunctions(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart != ViewPart.Device) {
                return;
            }
            for (Area area : this.getFunctions()) {
                if (area.getSourceFunction() == null) continue;
                area.getPathFunction().setSource(area.getSourceFunction());
                if (!area.getPathFunction().getSource().equals(area.getSourceFunction())) {
                    area.getPathFunction().setSolveGeometryRequest(true);
                }
                area.getPathFunction().setProjection(this.getProjection());
                area.getPathFunction().setFontRenderContext(g2d.getFontRenderContext());
                area.solveGeometry();
                if (area.getAreaFill() != null) {
                    area.getAreaFill().paintArea(g2d, area);
                }
                if (area.getAreaDraw() == null) continue;
                area.getAreaDraw().paintArea(g2d, area);
            }
        }
    }
}

