/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function;

import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.function.area.Area;
import org.jensoft.core.plugin.function.area.painter.draw.AbstractAreaDraw;
import org.jensoft.core.plugin.function.curve.Curve;
import org.jensoft.core.plugin.function.curve.painter.draw.CurveDefaultDraw;
import org.jensoft.core.plugin.function.scatter.Scatter;
import org.jensoft.core.plugin.function.scatter.morphe.RectangleMorphe;
import org.jensoft.core.plugin.function.scatter.morphe.ScatterMorphe;
import org.jensoft.core.plugin.function.scatter.painter.ScatterDraw;
import org.jensoft.core.plugin.function.scatter.painter.ScatterFill;
import org.jensoft.core.plugin.function.scatter.painter.fill.ScatterDefaultFill;
import org.jensoft.core.plugin.function.source.SourceFunction;

public class FunctionToolkit
extends Toolkit {
    public static Curve createCurveFunction(SourceFunction source) {
        Curve curve = new Curve(source);
        curve.setThemeColor(Color.BLACK);
        return curve;
    }

    public static Curve createCurveFunction(SourceFunction source, Color color) {
        Curve curve = new Curve(source);
        curve.setThemeColor(color);
        return curve;
    }

    public static Curve createCurveFunction(SourceFunction source, Color color, Stroke stroke) {
        Curve curve = new Curve(source);
        curve.setThemeColor(color);
        curve.setCurveDraw(new CurveDefaultDraw(stroke));
        return curve;
    }

    public static Curve createCurveFunction(SourceFunction source, Color color, CurveDefaultDraw curveDraw) {
        Curve curve = new Curve(source);
        curve.setThemeColor(color);
        curve.setCurveDraw(curveDraw);
        return curve;
    }

    public static Area createAreaFunction(SourceFunction source) {
        Area curve = new Area(source);
        curve.setThemeColor(Color.BLACK);
        return curve;
    }

    public static Area createAreaFunction(SourceFunction source, Color color) {
        Area curve = new Area(source);
        curve.setThemeColor(color);
        return curve;
    }

    public static Area createAreaFunction(SourceFunction source, Color color, AbstractAreaDraw curveAreaDraw) {
        Area curve = new Area(source);
        curve.setAreaDraw(curveAreaDraw);
        curve.setThemeColor(color);
        return curve;
    }

    public static Scatter createScatterFunction(SourceFunction source) {
        Scatter curve = new Scatter(source);
        curve.setScatterMorphe(new RectangleMorphe(3.0, 3.0));
        curve.setScatterFill(new ScatterDefaultFill());
        curve.setThemeColor(Color.BLACK);
        return curve;
    }

    public static Scatter createScatterFunction(SourceFunction source, Color color) {
        Scatter curve = new Scatter(source);
        curve.setScatterMorphe(new RectangleMorphe(3.0, 3.0));
        curve.setScatterFill(new ScatterDefaultFill());
        curve.setThemeColor(color);
        return curve;
    }

    public static Scatter createScatterFunction(SourceFunction source, Color color, ScatterMorphe morphe) {
        Scatter curve = new Scatter(source);
        curve.setThemeColor(color);
        curve.setScatterMorphe(morphe);
        curve.setScatterFill(new ScatterDefaultFill());
        return curve;
    }

    public static Scatter createScatterFunction(SourceFunction source, Color color, ScatterMorphe morphe, ScatterFill scatterFill) {
        Scatter curve = new Scatter(source);
        curve.setThemeColor(color);
        curve.setScatterMorphe(morphe);
        curve.setScatterFill(scatterFill);
        return curve;
    }

    public static Scatter createScatterFunction(SourceFunction source, Color color, ScatterMorphe morphe, ScatterFill scatterFill, ScatterDraw scatterDraw) {
        Scatter curve = new Scatter(source);
        curve.setThemeColor(color);
        curve.setScatterMorphe(morphe);
        curve.setScatterFill(scatterFill);
        curve.setScatterDraw(scatterDraw);
        return curve;
    }
}

