/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.analysis;

import java.util.Arrays;
import org.jensoft.core.plugin.function.analysis.DifferentiableUnivariateRealFunction;
import org.jensoft.core.plugin.function.analysis.PolynomialFunction;
import org.jensoft.core.plugin.function.analysis.UnivariateRealFunction;

public class PolynomialSplineFunction
implements DifferentiableUnivariateRealFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(double[] knots, PolynomialFunction[] polynomials) {
        if (knots.length < 2) {
            throw new IllegalArgumentException("spline partition must have at least 2 points");
        }
        if (knots.length - 1 != polynomials.length) {
            throw new IllegalArgumentException("number of polynomial interpolants must match the number of segments");
        }
        if (!PolynomialSplineFunction.isStrictlyIncreasing(knots)) {
            throw new IllegalArgumentException("knot values must be strictly increasing");
        }
        this.n = knots.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(knots, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    @Override
    public double value(double v) {
        if (v < this.knots[0] || v > this.knots[this.n]) {
            throw new IllegalArgumentException("value " + v + " is outside function domain.");
        }
        int i = Arrays.binarySearch(this.knots, v);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return this.polynomials[i].value(v - this.knots[i]);
    }

    @Override
    public UnivariateRealFunction derivative() {
        return this.polynomialSplineDerivative();
    }

    public PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] derivativePolynomials = new PolynomialFunction[this.n];
        for (int i = 0; i < this.n; ++i) {
            derivativePolynomials[i] = this.polynomials[i].polynomialDerivative();
        }
        return new PolynomialSplineFunction(this.knots, derivativePolynomials);
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] p = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, p, 0, this.n);
        return p;
    }

    public double[] getKnots() {
        double[] out = new double[this.n + 1];
        System.arraycopy(this.knots, 0, out, 0, this.n + 1);
        return out;
    }

    private static boolean isStrictlyIncreasing(double[] x) {
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i - 1] >= x[i])) continue;
            return false;
        }
        return true;
    }
}

