/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.analysis;

import org.jensoft.core.plugin.function.analysis.PolynomialFunction;
import org.jensoft.core.plugin.function.analysis.PolynomialSplineFunction;
import org.jensoft.core.plugin.function.analysis.UnivariateRealInterpolator;

public class SplineInterpolator
implements UnivariateRealInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y array values dimensions mismatch");
        }
        if (x.length < 3) {
            throw new IllegalArgumentException("the number of points must be greater than 3");
        }
        int n = x.length - 1;
        SplineInterpolator.checkOrder(x, OrderDirection.INCREASING, true);
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = x[i + 1] - x[i];
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        double g = 0.0;
        for (int i = 1; i < n; ++i) {
            g = 2.0 * (x[i + 1] - x[i - 1]) - h[i - 1] * mu[i - 1];
            mu[i] = h[i] / g;
            z[i] = (3.0 * (y[i + 1] * h[i - 1] - y[i] * (x[i + 1] - x[i - 1]) + y[i - 1] * h[i]) / (h[i - 1] * h[i]) - h[i - 1] * z[i - 1]) / g;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) {
        double previous = val[0];
        boolean ok = true;
        int max = val.length;
        for (int i = 1; i < max; ++i) {
            switch (dir) {
                case INCREASING: {
                    if (strict) {
                        if (!(val[i] <= previous)) break;
                        ok = false;
                        break;
                    }
                    if (!(val[i] < previous)) break;
                    ok = false;
                    break;
                }
                case DECREASING: {
                    if (strict) {
                        if (!(val[i] >= previous)) break;
                        ok = false;
                        break;
                    }
                    if (!(val[i] > previous)) break;
                    ok = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (!ok) {
                throw new IllegalArgumentException("Spline interpolator can not be used with values which are not order");
            }
            previous = val[i];
        }
    }

    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }
}

