/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.area;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.function.Function;
import org.jensoft.core.plugin.function.area.painter.AreaEffect;
import org.jensoft.core.plugin.function.area.painter.draw.AbstractAreaDraw;
import org.jensoft.core.plugin.function.area.painter.fill.AbstractAreaFill;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;

public class Area
extends Function {
    private double areaBase;
    private boolean areaBaseSet = false;
    private GeneralPath areaPath;
    private java.awt.geom.Area area;
    private Line2D baseLine;
    private AbstractAreaDraw areaDraw;
    private AbstractAreaFill areaFill;
    private AreaEffect areaEffect;

    public Area() {
    }

    public Area(SourceFunction source) {
        super("area", source);
    }

    public GeneralPath getAreaPath() {
        return this.areaPath;
    }

    public void setAreaPath(GeneralPath areaPath) {
        this.areaPath = areaPath;
    }

    public java.awt.geom.Area getArea() {
        return this.area;
    }

    public void setArea(java.awt.geom.Area area) {
        this.area = area;
    }

    public AbstractAreaDraw getAreaDraw() {
        return this.areaDraw;
    }

    public void setAreaDraw(AbstractAreaDraw areaDraw) {
        this.areaDraw = areaDraw;
    }

    public AbstractAreaFill getAreaFill() {
        return this.areaFill;
    }

    public void setAreaFill(AbstractAreaFill areaFill) {
        this.areaFill = areaFill;
    }

    public AreaEffect getAreaEffect() {
        return this.areaEffect;
    }

    public void setAreaEffect(AreaEffect areaEffect) {
        this.areaEffect = areaEffect;
    }

    public double getAreaBase() {
        return this.areaBase;
    }

    public void setAreaBase(double areaBase) {
        this.areaBase = areaBase;
        this.areaBaseSet = true;
    }

    public Line2D getBaseLine() {
        return this.baseLine;
    }

    public void setBaseLine(Line2D baseLine) {
        this.baseLine = baseLine;
    }

    private Point2D minFunction() {
        Point2D minFunction = this.getSourceFunction().getCurrentFunction().get(0);
        if (FunctionNature.XFunction == this.getSourceFunction().getNature()) {
            for (Point2D p : this.getSourceFunction().getCurrentFunction()) {
                if (!(p.getY() < minFunction.getY())) continue;
                minFunction = p;
            }
        }
        if (FunctionNature.YFunction == this.getSourceFunction().getNature()) {
            for (Point2D p : this.getSourceFunction().getCurrentFunction()) {
                if (!(p.getX() < minFunction.getX())) continue;
                minFunction = p;
            }
        }
        return minFunction;
    }

    public void solveGeometry() {
        Point2D deviceBaseMax;
        Point2D deviceBaseMin;
        if (!this.areaBaseSet) {
            if (this.getSourceFunction().getNature() == FunctionNature.XFunction) {
                this.setAreaBase(this.minFunction().getY());
            } else {
                this.setAreaBase(this.minFunction().getX());
            }
        }
        Shape curvePath = this.getPathFunction().getOrCreateGeometry().getPath();
        Point2D minSource = this.getSourceFunction().getCurrentFunction().get(0);
        Point2D maxSource = this.getSourceFunction().getCurrentFunction().get(this.getSourceFunction().getCurrentFunction().size() - 1);
        Point2D deviceAreaMin = this.getHost().getProjection().userToPixel(minSource);
        Point2D deviceAreaMax = this.getHost().getProjection().userToPixel(maxSource);
        if (this.getSourceFunction().getNature() == FunctionNature.XFunction) {
            double areaMin = minSource.getX();
            double areaMax = maxSource.getX();
            deviceBaseMin = this.getHost().getProjection().userToPixel(new Point2D.Double(areaMin, this.getAreaBase()));
            deviceBaseMax = this.getHost().getProjection().userToPixel(new Point2D.Double(areaMax, this.getAreaBase()));
        } else {
            double areaMin = minSource.getY();
            double areaMax = maxSource.getY();
            deviceBaseMin = this.getHost().getProjection().userToPixel(new Point2D.Double(this.getAreaBase(), areaMin));
            deviceBaseMax = this.getHost().getProjection().userToPixel(new Point2D.Double(this.getAreaBase(), areaMax));
        }
        this.setBaseLine(new Line2D.Double(deviceBaseMin, deviceBaseMax));
        GeneralPath ap = new GeneralPath();
        ap.append(curvePath, false);
        ap.append(new Line2D.Double(deviceAreaMax, deviceBaseMax), true);
        ap.append(new Line2D.Double(deviceBaseMax, deviceBaseMin), true);
        ap.append(new Line2D.Double(deviceBaseMin, deviceAreaMin), true);
        ap.closePath();
        this.setAreaPath(ap);
        int width = this.getHost().getProjection().getDevice2D().getDeviceWidth();
        int height = this.getHost().getProjection().getDevice2D().getDeviceHeight();
        java.awt.geom.Area area = new java.awt.geom.Area(new Rectangle(0, 0, width, height));
        area.intersect(new java.awt.geom.Area(ap));
        this.setArea(area);
    }
}

