/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.curve.painter.draw;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import org.jensoft.core.plugin.function.curve.Curve;
import org.jensoft.core.plugin.function.curve.painter.draw.AbstractCurveDraw;

public class CurveDefaultDraw
extends AbstractCurveDraw {
    private Color outlineColor;
    private Stroke outlineStroke = new BasicStroke();

    public CurveDefaultDraw() {
    }

    public CurveDefaultDraw(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public CurveDefaultDraw(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public CurveDefaultDraw(Color outlineColor, Stroke outlineStroke) {
        this.outlineColor = outlineColor;
        this.outlineStroke = outlineStroke;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStrok) {
        this.outlineStroke = outlineStrok;
    }

    @Override
    protected void drawCurve(Graphics2D g2d, Curve curve) {
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setStroke(this.outlineStroke);
        if (this.outlineColor != null) {
            g2d.setColor(this.outlineColor);
        } else if (curve.getThemeColor() != null) {
            g2d.setColor(curve.getThemeColor());
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Shape s = curve.getPathFunction().getOrCreateGeometry().getPath();
        g2d.draw(s);
    }
}

