/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.scatter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.function.Function;
import org.jensoft.core.plugin.function.scatter.morphe.ScatterMorphe;
import org.jensoft.core.plugin.function.scatter.painter.ScatterDraw;
import org.jensoft.core.plugin.function.scatter.painter.ScatterFill;
import org.jensoft.core.plugin.function.source.SourceFunction;

public class Scatter
extends Function {
    private ScatterDraw scatterDraw;
    private ScatterFill scatterFill;
    private ScatterMorphe scatterMorphe;
    private List<ScatterPoint> scatters = new ArrayList<ScatterPoint>();

    public Scatter(SourceFunction source) {
        super("scatter", source);
    }

    public ScatterDraw getScatterDraw() {
        return this.scatterDraw;
    }

    public void setScatterDraw(ScatterDraw scatterDraw) {
        this.scatterDraw = scatterDraw;
    }

    public ScatterMorphe getScatterMorphe() {
        return this.scatterMorphe;
    }

    public void setScatterMorphe(ScatterMorphe scatterMorphe) {
        this.scatterMorphe = scatterMorphe;
    }

    private BufferedImage createPrimitive(Scatter scatterCurve, Shape shape) {
        Rectangle rect = shape.getBounds();
        BufferedImage buffer = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), 2);
        Graphics2D g2d = buffer.createGraphics();
        this.getHost().configureGraphics(g2d);
        ScatterFill fill = scatterCurve.getScatterFill();
        ScatterDraw draw = scatterCurve.getScatterDraw();
        ScatterPoint scatter = new ScatterPoint();
        scatter.setPrimitiveShape(shape);
        scatter.setThemeColor(scatterCurve.getThemeColor());
        if (fill != null) {
            fill.paintScatter(g2d, scatter);
        }
        if (draw != null) {
            draw.paintScatter(g2d, scatter);
        }
        return buffer;
    }

    public void solveScatter() {
        this.clearScatter();
        ScatterMorphe morphe = this.getScatterMorphe();
        Shape morpheShape = morphe.getMorphe();
        BufferedImage primitive = this.createPrimitive(this, morpheShape);
        for (Point2D sourcePoint : this.getSourceFunction().getCurrentFunction()) {
            ScatterPoint scatter = new ScatterPoint();
            this.addScatter(scatter);
            scatter.setParent(this);
            scatter.setUserPoint(sourcePoint);
            Point2D deviceScatterPoint = this.getHost().getProjection().userToPixel(sourcePoint);
            scatter.setDevicePoint(deviceScatterPoint);
            scatter.setThemeColor(this.getThemeColor());
            scatter.setPrimitive(primitive);
        }
    }

    public List<ScatterPoint> getScatters() {
        return this.scatters;
    }

    private void addScatter(ScatterPoint scatter) {
        this.scatters.add(scatter);
    }

    public void removeScatter(ScatterPoint scatter) {
        this.scatters.remove(scatter);
    }

    public void clearScatter() {
        this.scatters.clear();
    }

    public ScatterFill getScatterFill() {
        return this.scatterFill;
    }

    public void setScatterFill(ScatterFill scatterFill) {
        this.scatterFill = scatterFill;
    }

    public static class ScatterPoint {
        private Scatter parent;
        private Point2D userPoint;
        private Point2D devicePoint;
        private Color themeColor;
        private BufferedImage primitiveBuffer;
        private Shape primitiveShape;

        public Shape getPrimitiveShape() {
            return this.primitiveShape;
        }

        public void setPrimitiveShape(Shape scatterShape) {
            this.primitiveShape = scatterShape;
        }

        public Color getThemeColor() {
            return this.themeColor;
        }

        public void setThemeColor(Color themeColor) {
            this.themeColor = themeColor;
        }

        public BufferedImage getPrimitive() {
            return this.primitiveBuffer;
        }

        public void setPrimitive(BufferedImage primitive) {
            this.primitiveBuffer = primitive;
        }

        public Point2D getUserPoint() {
            return this.userPoint;
        }

        public void setUserPoint(Point2D userPoint) {
            this.userPoint = userPoint;
        }

        public Point2D getDevicePoint() {
            return this.devicePoint;
        }

        public void setDevicePoint(Point2D devicePoint) {
            this.devicePoint = devicePoint;
        }

        public Scatter getParent() {
            return this.parent;
        }

        public void setParent(Scatter parent) {
            this.parent = parent;
        }
    }
}

