/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.scatter.morphe;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.jensoft.core.plugin.function.scatter.morphe.ScatterMorphe;

public class PolygonMorphe
extends ScatterMorphe {
    private double radius;
    private double faceCount;
    double startAngleDegree = 60.0;

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public PolygonMorphe(double radius, double faceCount) {
        this.radius = radius;
        this.faceCount = faceCount;
    }

    public double getExternalRadius() {
        return this.radius;
    }

    public void setExternalRadius(double externalRadius) {
        this.radius = externalRadius;
    }

    public double getBranchCount() {
        return this.faceCount;
    }

    public void setBranchCount(double branchCount) {
        this.faceCount = branchCount;
    }

    @Override
    public Shape getMorphe() {
        GeneralPath morphe = new GeneralPath();
        double centerX = this.radius;
        double centerY = this.radius;
        double angleStar = 360.0 / this.faceCount;
        int i = 0;
        while ((double)i < this.faceCount) {
            double pXExternal = centerX + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pYExternal = centerY - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)i));
            double pXExternal2 = centerX + this.radius * Math.cos(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            double pYExternal2 = centerY - this.radius * Math.sin(Math.toRadians(this.startAngleDegree + angleStar * (double)(i + 1)));
            Line2D.Double l = new Line2D.Double(pXExternal, pYExternal, pXExternal2, pYExternal2);
            morphe.append(l, true);
            ++i;
        }
        morphe.closePath();
        return morphe;
    }
}

