/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.function.tools.peaktracker;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.function.source.FunctionNature;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.plugin.function.tools.peaktracker.PeakTrackerEvent;
import org.jensoft.core.plugin.function.tools.peaktracker.PeakTrackerListener;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerEvent;
import org.jensoft.core.plugin.function.tools.sourcetracker.SourceTrackerListener;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class PeakTrackerPlugin
extends AbstractPlugin
implements AbstractPlugin.OnMoveListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnDragListener,
AbstractPlugin.OnReleaseListener {
    private List<SourceFunction> sources;
    private List<SourceFunction> trackedSources;
    private EventListenerList trackerListenerList;
    private int trackFrameWidth = 10;
    private int trackFrameHeight = 10;

    public PeakTrackerPlugin() {
        this.setName("PeakTrackerPlugin");
        this.sources = new ArrayList<SourceFunction>();
        this.trackedSources = new ArrayList<SourceFunction>();
        this.trackerListenerList = new EventListenerList();
        this.setOnMoveListener(this);
        this.setOnPressListener(this);
        this.setOnDragListener(this);
        this.setOnReleaseListener(this);
        this.setSelectable(true);
        this.setPriority(10000);
    }

    public void addPeakTrackerListener(PeakTrackerListener listener) {
        this.trackerListenerList.add(PeakTrackerListener.class, listener);
    }

    public void removePeakTrackerListener(PeakTrackerListener listener) {
        this.trackerListenerList.remove(PeakTrackerListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePeakTracked(SourceFunction source) {
        Object[] listeners;
        Object[] objectArray = listeners = this.trackerListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != PeakTrackerListener.class) continue;
                ((PeakTrackerListener)listeners[i + 1]).peakTracked(new PeakTrackerEvent(source));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSourceRegistered(SourceFunction source) {
        Object[] listeners;
        Object[] objectArray = listeners = this.trackerListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != SourceTrackerListener.class) continue;
                ((SourceTrackerListener)listeners[i + 1]).sourceRegistered(new SourceTrackerEvent(source));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public List<SourceFunction> getSources() {
        return this.sources;
    }

    public void setSources(List<SourceFunction> sources) {
        this.sources = sources;
    }

    public int getTrackFrameWidth() {
        return this.trackFrameWidth;
    }

    public void setTrackFrameWidth(int trackFrameWidth) {
        this.trackFrameWidth = trackFrameWidth;
    }

    public int getTrackFrameHeight() {
        return this.trackFrameHeight;
    }

    public void setTrackFrameHeight(int trackFrameHeight) {
        this.trackFrameHeight = trackFrameHeight;
    }

    public void registerSource(SourceFunction source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
            this.fireSourceRegistered(source);
        }
    }

    public void trackSource(SourceFunction source) {
        this.registerSource(source);
        if (!this.trackedSources.contains(source)) {
            this.trackedSources.add(source);
        }
        this.firePeakTracked(source);
    }

    public void untrackSource(SourceFunction source) {
        if (this.trackedSources.contains(source)) {
            this.trackedSources.remove(source);
        }
        this.firePeakTracked(source);
    }

    public boolean isTracked(SourceFunction source) {
        return this.trackedSources.contains(source);
    }

    public PeakTrackerLockUnlockAction getPeakTrackerLockUnlockAction() {
        return new PeakTrackerLockUnlockAction();
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        this.getProjection().getDevice2D().repaintDevice();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        for (SourceFunction trackedSource : this.trackedSources) {
            Point2D p;
            int i;
            double min;
            double max;
            if (trackedSource == null) {
                return;
            }
            if (trackedSource.getCurrentFunction() == null) {
                return;
            }
            if (trackedSource.getCurrentFunction().size() == 0) {
                return;
            }
            int indexMax = 0;
            int indexMin = 0;
            if (trackedSource.getNature() == FunctionNature.XFunction) {
                max = trackedSource.getCurrentFunction().get(0).getY();
                min = trackedSource.getCurrentFunction().get(0).getY();
                for (i = 0; i < trackedSource.getCurrentFunction().size(); ++i) {
                    p = trackedSource.getCurrentFunction().get(i);
                    if (p.getY() > max) {
                        indexMax = i;
                        max = p.getY();
                    }
                    if (!(p.getY() < min)) continue;
                    indexMin = i;
                    min = p.getY();
                }
            } else {
                max = trackedSource.getCurrentFunction().get(0).getX();
                min = trackedSource.getCurrentFunction().get(0).getX();
                for (i = 0; i < trackedSource.getCurrentFunction().size(); ++i) {
                    p = trackedSource.getCurrentFunction().get(i);
                    if (p.getX() > max) {
                        indexMax = i;
                        max = p.getX();
                    }
                    if (!(p.getX() < min)) continue;
                    indexMin = i;
                    min = p.getX();
                }
            }
            Point2D p2dUserMax = trackedSource.getCurrentFunction().get(indexMax);
            Point2D p2dUserMin = trackedSource.getCurrentFunction().get(indexMin);
            Point2D p2dDeviceMax = this.getProjection().userToPixel(p2dUserMax);
            Point2D p2dDeviceMin = this.getProjection().userToPixel(p2dUserMin);
            Rectangle2D.Double rect2DMax = new Rectangle2D.Double(p2dDeviceMax.getX() - (double)(this.trackFrameWidth / 2), p2dDeviceMax.getY() - (double)(this.trackFrameHeight / 2), this.trackFrameWidth, this.trackFrameHeight);
            Rectangle2D.Double rect2DMin = new Rectangle2D.Double(p2dDeviceMin.getX() - (double)(this.trackFrameWidth / 2), p2dDeviceMin.getY() - (double)(this.trackFrameHeight / 2), this.trackFrameWidth, this.trackFrameHeight);
            g2d.setColor(Color.WHITE);
            g2d.draw(rect2DMax);
            g2d.draw(rect2DMin);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2d.setColor(NanoChromatique.RED);
            g2d.fill(rect2DMax);
            g2d.setColor(NanoChromatique.BLUE);
            g2d.fill(rect2DMin);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    class PeakTrackerLockUnlockAction
    implements ActionListener {
        PeakTrackerLockUnlockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PeakTrackerPlugin.this.isLockSelected()) {
                        PeakTrackerPlugin.this.unlockSelected();
                    } else {
                        PeakTrackerPlugin.this.lockSelected();
                    }
                }
            });
        }
    }
}

