/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.donut2d.painter.label.AbstractDonut2DSliceLabel;
import org.jensoft.core.plugin.gauge.core.GaugePart;
import org.jensoft.core.plugin.gauge.core.GaugePartBuffer;
import org.jensoft.core.plugin.gauge.core.RadialGauge;

public abstract class GaugeBackground
extends GaugePart {
    @Override
    public void invalidate() {
        this.setPartBuffer(null);
    }

    protected abstract void paintBackground(Graphics2D var1, RadialGauge var2);

    @Override
    public final void paintPart(Graphics2D g2d, RadialGauge radialGauge) {
        this.paintBackground(g2d, radialGauge);
    }

    public static abstract class Circular
    extends GaugeBackground {
        private int radius = 0;
        private double polarRadius = 0.0;
        private float polarAngle = 0.0f;

        public Circular() {
        }

        public Circular(int radius, double polarRadius, float polarAngle) {
            this.radius = radius;
            this.polarRadius = polarRadius;
            this.polarAngle = polarAngle;
        }

        public int getRadius() {
            return this.radius;
        }

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public double getPolarRadius() {
            return this.polarRadius;
        }

        public void setPolarRadius(double polarRadius) {
            this.polarRadius = polarRadius;
        }

        public float getPolarAngle() {
            return this.polarAngle;
        }

        public void setPolarAngle(float polarAngle) {
            this.polarAngle = polarAngle;
        }

        @Override
        public final void paintBackground(Graphics2D g2d, RadialGauge radialGauge) {
            GaugePartBuffer part = this.getPartBuffer();
            if (part == null) {
                Point2D centerDef = radialGauge.getRadialPointAt(this.getPolarRadius(), this.getPolarAngle());
                if (this.getRadius() == 0) {
                    this.setRadius(radialGauge.getRadius());
                }
                Ellipse2D.Double baseShape = new Ellipse2D.Double(centerDef.getX() - (double)this.radius, centerDef.getY() - (double)this.radius, 2 * this.radius, 2 * this.radius);
                part = new GaugePartBuffer(radialGauge);
                part.getGraphics().setRenderingHints(g2d.getRenderingHints());
                this.setPartBuffer(part);
                this.fill(part.getGraphics(), radialGauge, baseShape);
            }
            g2d.drawImage(part.getBuffer(), (int)part.getX(), (int)part.getY(), (int)part.getWidth(), (int)part.getHeight(), null);
        }

        public abstract void fill(Graphics2D var1, RadialGauge var2, Shape var3);

        public static class Texture
        extends Circular {
            private TexturePaint texturePaint;

            public Texture(TexturePaint texturePaint) {
                this.texturePaint = texturePaint;
            }

            public Texture(TexturePaint texturePaint, int radius, double polarRadius, float polarAngle) {
                super(radius, polarRadius, polarAngle);
                this.texturePaint = texturePaint;
            }

            public TexturePaint getTexturePaint() {
                return this.texturePaint;
            }

            public void setTexturePaint(TexturePaint texturePaint) {
                this.texturePaint = texturePaint;
            }

            @Override
            public void fill(Graphics2D g2d, RadialGauge radialGauge, Shape shape) {
                g2d.setPaint(this.texturePaint);
                g2d.fill(shape);
            }
        }

        public static class Donut
        extends Circular {
            private Donut2D donut2D;

            public void setDonut(Donut2D donut2D) {
                this.donut2D = donut2D;
            }

            @Override
            public void fill(Graphics2D g2d, RadialGauge radialGauge, Shape shape) {
                this.donut2D.setHostPlugin(radialGauge.getHost());
                this.donut2D.solveGeometry();
                if (this.donut2D.getDonut2DFill() != null) {
                    this.donut2D.getDonut2DFill().paintDonut2D(g2d, this.donut2D);
                }
                if (this.donut2D.getDonut2DDraw() != null) {
                    this.donut2D.getDonut2DDraw().paintDonut2D(g2d, this.donut2D);
                }
                if (this.donut2D.getDonut2DEffect() != null) {
                    this.donut2D.getDonut2DEffect().paintDonut2D(g2d, this.donut2D);
                }
                List<Donut2DSlice> slices = this.donut2D.getSlices();
                for (Donut2DSlice donut2DSlice : slices) {
                    for (AbstractDonut2DSliceLabel label : donut2DSlice.getSliceLabels()) {
                        label.paintDonut2DSlice(g2d, this.donut2D, donut2DSlice);
                    }
                }
            }
        }

        public static class RadialGradient
        extends Gradient {
            public RadialGradient() {
                super(new float[]{0.0f, 1.0f}, new Color[]{Color.BLACK, new Color(50, 50, 50)});
            }

            public RadialGradient(float[] fractions, Color[] colors) {
                super(fractions, colors);
            }

            public RadialGradient(int radius, double polarRadius, float polarAngle, float[] fractions, Color[] colors) {
                super(radius, polarRadius, polarAngle, fractions, colors);
            }

            public RadialGradient(int radius, double polarRadius, float polarAngle) {
                super(radius, polarRadius, polarAngle);
            }

            @Override
            public Paint getGradient(RadialGauge radialGauge) {
                Point2D centerDef = radialGauge.getRadialPointAt(this.getPolarRadius(), this.getPolarAngle());
                RadialGradientPaint rgp = new RadialGradientPaint(centerDef, 3 * this.getRadius() / 4, this.getFractions(), this.getColors());
                return rgp;
            }
        }

        public static class LinearGradient
        extends Gradient {
            private float gradientAngle = 90.0f;

            public LinearGradient() {
                super(new float[]{0.0f, 1.0f}, new Color[]{Color.BLACK, new Color(50, 50, 50)});
            }

            public LinearGradient(float[] fractions, Color[] colors) {
                super(fractions, colors);
            }

            public LinearGradient(int radius, double polarRadius, float polarAngle) {
                super(radius, polarRadius, polarAngle);
            }

            public LinearGradient(int radius, double polarRadius, float polarAngle, float[] fractions, Color[] colors) {
                super(radius, polarRadius, polarAngle, fractions, colors);
            }

            public float getGradientAngle() {
                return this.gradientAngle;
            }

            public void setGradientAngle(float gradientAngle) {
                this.gradientAngle = gradientAngle;
            }

            @Override
            public Paint getGradient(RadialGauge radialGauge) {
                Point2D centerDef = radialGauge.getRadialPointAt(this.getPolarRadius(), this.getPolarAngle());
                double startX = centerDef.getX() + (double)this.getRadius() * Math.cos(Math.toRadians(this.gradientAngle));
                double startY = centerDef.getY() - (double)this.getRadius() * Math.sin(Math.toRadians(this.gradientAngle));
                double endX = centerDef.getX() + (double)this.getRadius() * Math.cos(Math.toRadians(this.gradientAngle) + Math.PI);
                double endY = centerDef.getY() - (double)this.getRadius() * Math.sin(Math.toRadians(this.gradientAngle) + Math.PI);
                Point2D.Double start = new Point2D.Double(startX, startY);
                Point2D.Double end = new Point2D.Double(endX, endY);
                LinearGradientPaint paint = new LinearGradientPaint(start, end, this.getFractions(), this.getColors());
                return paint;
            }
        }

        public static abstract class Gradient
        extends Circular {
            private float[] fractions = new float[]{0.0f, 1.0f};
            private Color[] colors = new Color[]{NanoChromatique.WHITE, NanoChromatique.BLACK};

            public Gradient() {
            }

            public Gradient(int radius, double polarRadius, float polarAngle) {
                super(radius, polarRadius, polarAngle);
            }

            public Gradient(float[] fractions, Color[] colors) {
                this.fractions = fractions;
                this.colors = colors;
            }

            public Gradient(int radius, double polarRadius, float polarAngle, float[] fractions, Color[] colors) {
                super(radius, polarRadius, polarAngle);
                this.fractions = fractions;
                this.colors = colors;
            }

            public void setShader(float[] fractions, Color[] colors) {
                if (fractions.length != colors.length) {
                    throw new IllegalArgumentException("length array does not match");
                }
                this.fractions = fractions;
                this.colors = colors;
            }

            public float[] getFractions() {
                return this.fractions;
            }

            public Color[] getColors() {
                return this.colors;
            }

            @Override
            public final void fill(Graphics2D g2d, RadialGauge radialGauge, Shape shape) {
                g2d.setPaint(this.getGradient(radialGauge));
                g2d.fill(shape);
            }

            public abstract Paint getGradient(RadialGauge var1);
        }
    }
}

