/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.glyphmetrics.GlyphUtil;
import org.jensoft.core.palette.color.PetalPalette;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.gauge.core.GaugePart;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PiePlugin;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectFrame;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectKey;
import org.jensoft.core.plugin.pie.painter.effect.PieCubicEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieLinearEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieRadialEffect;

public abstract class GaugeGlass
extends GaugePart {
    @Override
    public void invalidate() {
        this.setPartBuffer(null);
    }

    protected abstract void paintGlass(Graphics2D var1, RadialGauge var2);

    @Override
    public final void paintPart(Graphics2D g2d, RadialGauge radialGauge) {
        this.paintGlass(g2d, radialGauge);
    }

    public static class GlassCubicEffect
    extends PieGaugeGlass {
        private CubicEffectFrame frame;
        private CubicEffectKey key;
        private PieCubicEffect fx = new PieCubicEffect();
        private int incidenceAngleDegree = 300;
        private int offsetRadius = 4;

        public GlassCubicEffect() {
        }

        public GlassCubicEffect(CubicEffectFrame frame) {
            this();
            this.frame = frame;
        }

        public GlassCubicEffect(CubicEffectFrame frame, int incidenceAngleDegree) {
            this();
            this.frame = frame;
            this.incidenceAngleDegree = incidenceAngleDegree;
        }

        public GlassCubicEffect(CubicEffectKey key) {
            this();
            this.key = key;
        }

        public GlassCubicEffect(CubicEffectKey key, int incidenceAngleDegree) {
            this();
            this.key = key;
            this.incidenceAngleDegree = incidenceAngleDegree;
        }

        public int getIncidenceAngleDegree() {
            return this.incidenceAngleDegree;
        }

        public void setIncidenceAngleDegree(int incidenceAngleDegree) {
            this.incidenceAngleDegree = incidenceAngleDegree;
        }

        public int getOffsetRadius() {
            return this.offsetRadius;
        }

        public void setOffsetRadius(int offsetRadius) {
            this.offsetRadius = offsetRadius;
        }

        public CubicEffectFrame getFrame() {
            return this.frame;
        }

        public void setFrame(CubicEffectFrame frame) {
            this.frame = frame;
        }

        public CubicEffectKey getKey() {
            return this.key;
        }

        public void setKey(CubicEffectKey key) {
            this.key = key;
        }

        @Override
        public AbstractPieEffect getEffectInstance() {
            if (this.frame != null) {
                this.setKey(this.frame.getKeyFrame());
            }
            if (this.key != null) {
                this.fx.setCubicKey(this.key);
            }
            this.fx.setIncidenceAngleDegree(this.incidenceAngleDegree);
            this.fx.setOffsetRadius(this.offsetRadius);
            return this.fx;
        }
    }

    public static class GlassRadialEffect
    extends PieGaugeGlass {
        @Override
        public AbstractPieEffect getEffectInstance() {
            PieRadialEffect fx = new PieRadialEffect();
            return fx;
        }
    }

    public static class GlassLinearEffect
    extends PieGaugeGlass {
        private float[] fractions = new float[]{0.0f, 0.49f, 0.51f, 1.0f};
        private Color[] colors = new Color[]{new Color(60, 60, 60, 150), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 100)};
        private int incidenceAngleDegree = 60;
        private int offsetRadius = 4;

        public GlassLinearEffect() {
        }

        public GlassLinearEffect(int incidenceAngleDegree) {
            this.incidenceAngleDegree = incidenceAngleDegree;
        }

        public GlassLinearEffect(int incidenceAngleDegree, int offsetRadius) {
            this.incidenceAngleDegree = incidenceAngleDegree;
            this.offsetRadius = offsetRadius;
        }

        public int getIncidenceAngleDegree() {
            return this.incidenceAngleDegree;
        }

        public void setIncidenceAngleDegree(int incidenceAngleDegree) {
            this.incidenceAngleDegree = incidenceAngleDegree;
        }

        public int getOffsetRadius() {
            return this.offsetRadius;
        }

        public void setOffsetRadius(int offsetRadius) {
            this.offsetRadius = offsetRadius;
        }

        @Override
        public AbstractPieEffect getEffectInstance() {
            PieLinearEffect fx = new PieLinearEffect();
            fx.setShader(this.fractions, this.colors);
            fx.setOffsetRadius(this.offsetRadius);
            fx.setIncidenceAngleDegree(this.incidenceAngleDegree);
            return fx;
        }
    }

    public static abstract class PieGaugeGlass
    extends GaugeGlass {
        public abstract AbstractPieEffect getEffectInstance();

        @Override
        public final void paintGlass(Graphics2D g2d, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius();
            Pie pie = new Pie();
            pie.setPieNature(Pie.PieNature.Device);
            pie.setCenterX(centerX);
            pie.setCenterY(centerY);
            pie.setRadius(radius);
            pie.addSlice(new PieSlice("slice", Color.WHITE));
            PiePlugin piePlugin = new PiePlugin();
            piePlugin.setProjection(radialGauge.getProjection());
            piePlugin.addPie(pie);
            AbstractPieEffect fx = this.getEffectInstance();
            pie.setPieEffect(fx);
            pie.build();
            fx.paintPie(g2d, pie);
        }
    }

    public static class JenSoftAPILabel
    extends GaugeGlass {
        private String label = "***JenSoft Marine ***";

        public JenSoftAPILabel() {
        }

        public JenSoftAPILabel(String label) {
            this.label = label;
        }

        @Override
        public void paintGlass(Graphics2D g2d, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius();
            int radius2 = radialGauge.getRadius() + 5;
            Arc2D.Double arc2d = new Arc2D.Double(centerX - (double)radius, centerY - (double)radius, 2 * radius, 2 * radius, 90.0, 360.0, 0);
            Arc2D.Double arc2d2 = new Arc2D.Double(centerX - (double)radius2, centerY - (double)radius2, 2 * radius2, 2 * radius2, 90.0, 360.0, 0);
            g2d.setColor(TangoPalette.WHITE);
            GeometryPath geometry = new GeometryPath(arc2d);
            GeometryPath geometry2 = new GeometryPath(arc2d2);
            Font f = new Font("Dialog", 0, 12);
            String copyright = this.label + " - JENSOFT API";
            GlyphVector glyphVector = f.createGlyphVector(g2d.getFontRenderContext(), copyright);
            AffineTransform af = new AffineTransform();
            float gvWidth = GlyphUtil.getGlyphWidth(glyphVector);
            float startLength = geometry.lengthOfPath() / 2.0f - gvWidth / 2.0f;
            int c_p = copyright.indexOf("JENSOFT");
            for (int j = 0; j < glyphVector.getNumGlyphs(); ++j) {
                Point2D p = glyphVector.getGlyphPosition(j);
                float px = (float)p.getX();
                float py = (float)p.getY();
                Point2D pointGlyph = geometry.pointAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                if (pointGlyph == null) continue;
                Shape glyph = glyphVector.getGlyphOutline(j);
                float angle = geometry.angleAtLength(startLength + GlyphUtil.getGlyphWidthAtToken(glyphVector, j));
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.rotate(angle);
                af.translate(-px, (double)(-py) + glyphVector.getVisualBounds().getHeight() / 2.0 - 10.0);
                Shape ts = af.createTransformedShape(glyph);
                if (j == c_p) {
                    g2d.setColor(PetalPalette.PETAL5_HC);
                }
                if (j == c_p + 1) {
                    g2d.setColor(PetalPalette.PETAL6_HC);
                }
                if (j == c_p + 2) {
                    g2d.setColor(PetalPalette.PETAL7_HC);
                }
                if (j == c_p + 3) {
                    g2d.setColor(PetalPalette.PETAL8_HC);
                }
                if (j == c_p + 4) {
                    g2d.setColor(PetalPalette.PETAL1_HC);
                }
                if (j == c_p + 5) {
                    g2d.setColor(PetalPalette.PETAL2_HC);
                }
                if (j == c_p + 6) {
                    g2d.setColor(PetalPalette.PETAL3_HC);
                }
                if (j == c_p + 7 || j == c_p + 8 || j == c_p + 9 || j == c_p + 10) {
                    g2d.setColor(Color.WHITE);
                }
                g2d.fill(ts);
            }
        }
    }

    public static class GlassTextPath
    extends GaugeGlass {
        private TextPath textPath = new TextPath();
        private int startAngleDegree = 0;
        private int extendsDegree = 360;

        public GlassTextPath() {
            this.textPath.setDivergence(0);
            this.textPath.setOffsetLeft(0.0f);
            this.textPath.setOffsetRight(0.0f);
        }

        public GlassTextPath(String text) {
            this();
            this.setText(text);
        }

        public void setArcDef(int startAngleDegree, int extendsDegree) {
            this.startAngleDegree = startAngleDegree;
            this.extendsDegree = extendsDegree;
        }

        public Font getTextFont() {
            return this.textPath.getLabelFont();
        }

        public void setTextFont(Font textFont) {
            this.textPath.setLabelFont(textFont);
        }

        public String getText() {
            return this.textPath.getLabel();
        }

        public void setText(String text) {
            this.textPath.setLabel(text);
        }

        public boolean isLockReverse() {
            return this.textPath.isLockReverse();
        }

        public void setLockReverse(boolean lockReverse) {
            this.textPath.setLockReverse(lockReverse);
        }

        public boolean isAutoReverse() {
            return this.textPath.isAutoReverse();
        }

        public void setAutoReverse(boolean autoReverse) {
            this.textPath.setAutoReverse(autoReverse);
        }

        public void setTextPosition(TextPath.TextPosition textPosition) {
            this.textPath.setTextPosition(textPosition);
        }

        public TextPath.TextPosition getTextPosition() {
            return this.textPath.getTextPosition();
        }

        public int getDivergence() {
            return this.textPath.getDivergence();
        }

        public void setDivergence(int divergence) {
            this.textPath.setDivergence(divergence);
        }

        public float getOffsetLeft() {
            return this.textPath.getOffsetLeft();
        }

        public void setOffsetLeft(float offsetLeft) {
            this.textPath.setOffsetLeft(offsetLeft);
        }

        public float getOffsetRight() {
            return this.textPath.getOffsetRight();
        }

        public void setOffsetRight(float offsetRight) {
            this.textPath.setOffsetRight(offsetRight);
        }

        public Color getTextColor() {
            return this.textPath.getTextColor();
        }

        public void setTextColor(Color textColor) {
            this.textPath.setTextColor(textColor);
        }

        public TextPath.PathSide getTextPathSide() {
            return this.textPath.getPathSide();
        }

        public void setTextPathSide(TextPath.PathSide pathSide) {
            this.textPath.setPathSide(pathSide);
        }

        public void setShader(float[] fractions, Color[] colors) {
            this.textPath.setShader(fractions, colors);
        }

        @Override
        public void paintGlass(Graphics2D g2d, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius();
            Arc2D.Double arc2d = new Arc2D.Double(centerX - (double)radius, centerY - (double)radius, 2 * radius, 2 * radius, this.startAngleDegree, this.extendsDegree, 0);
            this.textPath.setPath(arc2d);
            this.textPath.draw(g2d);
        }
    }

    public static class Donut2DGlass
    extends GaugeGlass {
        @Override
        public void paintGlass(Graphics2D g2d, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int radius = radialGauge.getRadius() - 5;
            Donut2D donut1 = new Donut2D();
            donut1.setCenterX((int)centerX);
            donut1.setCenterY((int)centerY);
            donut1.setStartAngleDegree(270.0);
            donut1.setInnerRadius(radius - 20);
            donut1.setOuterRadius(radius);
            donut1.setStartAngleDegree(130.0);
            donut1.setExplose(5.0);
            Donut2DSlice s1 = new Donut2DSlice("D1", new Color(255, 255, 255, 120));
            s1.setAlpha(0.4f);
            s1.setValue(10.0);
            Donut2DSlice s2 = new Donut2DSlice("D2", new Color(255, 255, 255, 140));
            s2.setValue(10.0);
            s2.setAlpha(0.2f);
            Donut2DSlice s4 = new Donut2DSlice("D2", new Color(255, 255, 255, 200));
            s4.setValue(10.0);
            s4.setAlpha(0.5f);
            Donut2DSlice s3 = new Donut2DSlice("D3", new Color(255, 255, 255, 0));
            s3.setValue(30.0);
            s3.setAlpha(0.2f);
            Donut2DSlice s5 = new Donut2DSlice("D3", new Color(255, 255, 255, 200));
            s5.setValue(20.0);
            s5.setAlpha(0.6f);
            donut1.addSlice(s1);
            donut1.addSlice(s2);
            donut1.addSlice(s3);
            donut1.addSlice(s4);
            donut1.addSlice(s5);
            Point2D.Double center = new Point2D.Double(centerX, centerY);
            float[] dist = new float[]{0.0f, 0.8f, 1.0f};
            Color[] colors = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 150), new Color(255, 255, 255, 0)};
            RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, colors);
            donut1.solveGeometry();
            g2d.setPaint(p);
            List<Donut2DSlice> sections = donut1.getSlices();
            for (int j = 0; j < sections.size(); ++j) {
                Donut2DSlice s = sections.get(j);
                g2d.setComposite(AlphaComposite.getInstance(3, s.getAlpha()));
                g2d.fill(s.getSlicePath());
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    public static class GlassIncubator
    extends GaugeGlass {
        @Override
        public void paintGlass(Graphics2D g2d, RadialGauge radialGauge) {
            double centerX = radialGauge.getProjection().userToPixel(new Point2D.Double(radialGauge.getX(), 0.0)).getX();
            double centerY = radialGauge.getProjection().userToPixel(new Point2D.Double(0.0, radialGauge.getY())).getY();
            int gaugeRadius = radialGauge.getRadius();
            Point2D.Double p1 = new Point2D.Double(centerX, centerY + (double)gaugeRadius);
            Ellipse2D.Double e1 = new Ellipse2D.Double(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 4.0, 4.0);
            g2d.setColor(Color.CYAN);
            g2d.draw(e1);
            Point2D.Double center = new Point2D.Double(centerX, centerY + (double)gaugeRadius - 40.0);
            float radius = 60.0f;
            Point2D.Double focus = new Point2D.Double(centerX, centerY + (double)gaugeRadius - 20.0);
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{Color.RED, new Color(255, 255, 255, 0)};
            RadialGradientPaint p = new RadialGradientPaint(center, radius, focus, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2d.setPaint(p);
            g2d.fillOval((int)(centerX - (double)gaugeRadius), (int)(centerY - (double)gaugeRadius), 2 * gaugeRadius, 2 * gaugeRadius);
            g2d.setColor(Color.YELLOW);
            g2d.drawOval((int)(centerX - (double)gaugeRadius), (int)(centerY - (double)gaugeRadius), 2 * gaugeRadius, 2 * gaugeRadius);
        }
    }
}

