/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.gauge.RadialGaugePlugin;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugeEnvelope;
import org.jensoft.core.plugin.gauge.core.GaugeGlass;
import org.jensoft.core.projection.Projection;

public class RadialGauge {
    private double x;
    private double y;
    private int radius;
    private Projection projection;
    private RadialGaugePlugin host;
    private GaugeEnvelope envelop;
    private List<GaugeGlass> glasses;
    private List<GaugeBackground> backgrounds;
    private List<GaugeBody> bodies;

    public RadialGauge(double x, double y, int radius) {
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.backgrounds = new ArrayList<GaugeBackground>();
        this.glasses = new ArrayList<GaugeGlass>();
        this.bodies = new ArrayList<GaugeBody>();
    }

    public Point2D getCenterDevice() {
        double centerX = this.getProjection().userToPixel(new Point2D.Double(this.getX(), 0.0)).getX();
        double centerY = this.getProjection().userToPixel(new Point2D.Double(0.0, this.getY())).getY();
        return new Point2D.Double(centerX, centerY);
    }

    public Point2D getRadialPointAt(double radius, float angleDegree) {
        double centerX = this.getCenterDevice().getX();
        double centerY = this.getCenterDevice().getY();
        double shiftCenterX = centerX + radius * Math.cos(Math.toRadians(angleDegree));
        double shiftCenterY = centerY - radius * Math.sin(Math.toRadians(angleDegree));
        return new Point2D.Double(shiftCenterX, shiftCenterY);
    }

    public RadialGaugePlugin getHost() {
        return this.host;
    }

    public void setHost(RadialGaugePlugin host) {
        this.host = host;
    }

    public List<GaugeBackground> getBackgrounds() {
        return this.backgrounds;
    }

    public void setBackgrounds(List<GaugeBackground> backgrounds) {
        for (GaugeBackground gaugeBackground : backgrounds) {
            this.addBackground(gaugeBackground);
        }
    }

    public void addBackground(GaugeBackground background) {
        background.setGauge(this);
        this.backgrounds.add(background);
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public GaugeEnvelope getEnvelop() {
        return this.envelop;
    }

    public void setEnvelop(GaugeEnvelope envelop) {
        envelop.setGauge(this);
        this.envelop = envelop;
    }

    public List<GaugeGlass> getGlasses() {
        return this.glasses;
    }

    public void setGlasses(List<GaugeGlass> glasses) {
        for (GaugeGlass gaugeGlass : glasses) {
            this.addGlass(gaugeGlass);
        }
    }

    public void addGlass(GaugeGlass glass) {
        glass.setGauge(this);
        this.glasses.add(glass);
    }

    public void addGlass(GaugeGlass ... glasses) {
        for (int i = 0; i < glasses.length; ++i) {
            this.addGlass(glasses[i]);
        }
    }

    public List<GaugeBody> getBodies() {
        return this.bodies;
    }

    public void setBodies(List<GaugeBody> bodies) {
        for (GaugeBody body : bodies) {
            this.addBody(body);
        }
    }

    public void addBody(GaugeBody body) {
        body.setGauge(this);
        this.bodies.add(body);
    }

    public void addBody(GaugeBody ... bodies) {
        for (int i = 0; i < bodies.length; ++i) {
            this.addBody(bodies[i]);
        }
    }
}

