/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.binder.path;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.PathBinder;

public abstract class AbstractPathAutoBinder
extends PathBinder {
    protected int radius;
    protected int polarRadius;
    protected float polarDegree;
    protected Direction direction = Direction.Clockwise;
    protected double x0;
    protected double y0;
    protected double r0;
    protected double x1;
    protected double y1;
    protected double r1;
    protected Arc2D arc0;
    protected Arc2D arc1;
    protected Point2D intersectionPointStart;
    protected double theta1Radian1;
    protected Point2D intersectionPointEnd;
    protected double theta1Radian2;

    public AbstractPathAutoBinder(int radius, int polarRadius, float polarDegree) {
        this.radius = radius;
        this.polarRadius = polarRadius;
        this.polarDegree = polarDegree;
    }

    public AbstractPathAutoBinder(int radius, int polarRadius, float polarDegree, Direction direction) {
        this.radius = radius;
        this.polarRadius = polarRadius;
        this.polarDegree = polarDegree;
        this.direction = direction;
    }

    private double getPolarAngle(double refX, double refY, double px, double py) {
        double tethaRadian = -1.0;
        if (px - refX > 0.0 && refY - py >= 0.0) {
            tethaRadian = Math.atan((refY - py) / (px - refX));
        } else if (px - refX > 0.0 && refY - py < 0.0) {
            tethaRadian = Math.atan((refY - py) / (px - refX)) + Math.PI * 2;
        } else if (px - refX < 0.0) {
            tethaRadian = Math.atan((refY - py) / (px - refX)) + Math.PI;
        } else if (px - refX == 0.0 && refY - py > 0.0) {
            tethaRadian = 1.5707963267948966;
        } else if (px - refX == 0.0 && refY - py < 0.0) {
            tethaRadian = 4.71238898038469;
        }
        return tethaRadian;
    }

    @Override
    public Shape bindPath(RadialGauge gauge) {
        this.solveIntersectionPoints();
        return this.createPath();
    }

    public abstract Shape createPath();

    private void solveIntersectionPoints() {
        double x;
        double C;
        double A;
        double B;
        double delta;
        RadialGauge gauge = this.getMetricsPath().getBody().getGauge();
        this.x0 = gauge.getCenterDevice().getX();
        this.y0 = gauge.getCenterDevice().getY();
        this.r0 = gauge.getRadius();
        this.arc0 = new Arc2D.Double(this.x0 - this.r0, this.y0 - this.r0, 2.0 * this.r0, 2.0 * this.r0, 0.0, 360.0, 0);
        this.x1 = this.x0 + (double)this.polarRadius * Math.cos(Math.toRadians(this.polarDegree));
        this.y1 = this.y0 - (double)this.polarRadius * Math.sin(Math.toRadians(this.polarDegree));
        this.r1 = this.radius;
        this.arc1 = new Arc2D.Double(this.x1 - this.r1, this.y1 - this.r1, 2.0 * this.r1, 2.0 * this.r1, 0.0, 360.0, 0);
        if (this.polarDegree != 0.0f && this.polarDegree != 180.0f) {
            double C2;
            double N2 = (this.r1 * this.r1 - this.r0 * this.r0 - this.x1 * this.x1 + this.x0 * this.x0 - this.y1 * this.y1 + this.y0 * this.y0) / (2.0 * (this.y0 - this.y1));
            double B2 = 2.0 * this.y0 * (this.x0 - this.x1) / (this.y0 - this.y1) - 2.0 * N2 * (this.x0 - this.x1) / (this.y0 - this.y1) - 2.0 * this.x0;
            double A2 = Math.pow((this.x0 - this.x1) / (this.y0 - this.y1), 2.0) + 1.0;
            double delta2 = Math.sqrt(B2 * B2 - 4.0 * A2 * (C2 = this.x0 * this.x0 + this.y0 * this.y0 + N2 * N2 - this.r0 * this.r0 - 2.0 * this.y0 * N2));
            if (!(delta2 < 0.0) && delta2 >= 0.0) {
                double p1x = (-B2 - delta2) / (2.0 * A2);
                double p1y = N2 - p1x * (this.x0 - this.x1) / (this.y0 - this.y1);
                this.intersectionPointStart = new Point2D.Double(p1x, p1y);
                double p2x = (-B2 + delta2) / (2.0 * A2);
                double p2y = N2 - p2x * (this.x0 - this.x1) / (this.y0 - this.y1);
                this.intersectionPointEnd = new Point2D.Double(p2x, p2y);
                this.theta1Radian1 = this.getPolarAngle(this.x1, this.y1, p1x, p1y);
                this.theta1Radian2 = this.getPolarAngle(this.x1, this.y1, p2x, p2y);
            }
        } else if ((this.polarDegree == 0.0f || this.polarDegree == 180.0f) && !((delta = Math.sqrt((B = -2.0 * this.y1) * B - 4.0 * (A = 1.0) * (C = this.x1 * this.x1 + (x = (this.r1 * this.r1 - this.r0 * this.r0 - this.x1 * this.x1 + this.x0 * this.x0) / (2.0 * (this.x0 - this.x1))) * x - 2.0 * this.x1 * x + this.y1 * this.y1 - this.r1 * this.r1))) < 0.0) && delta >= 0.0) {
            double p1x = x;
            double p1y = (-B - delta) / 2.0 * A;
            this.intersectionPointStart = new Point2D.Double(p1x, p1y);
            double p2x = x;
            double p2y = (-B + delta) / 2.0 * A;
            this.intersectionPointEnd = new Point2D.Double(p2x, p2y);
            this.theta1Radian1 = this.getPolarAngle(this.x1, this.y1, p1x, p1y);
            this.theta1Radian2 = this.getPolarAngle(this.x1, this.y1, p2x, p2y);
        }
    }

    @Override
    public void debug(Graphics2D g2d, RadialGauge gauge) {
        this.solveIntersectionPoints();
        g2d.setColor(NanoChromatique.BLACK);
        g2d.draw(this.arc0);
        g2d.setColor(NanoChromatique.YELLOW.brighter());
        g2d.draw(this.arc1);
        g2d.setColor(NanoChromatique.YELLOW.brighter());
        g2d.setColor(NanoChromatique.YELLOW.brighter());
        Font f = new Font("Dialog", 0, 12);
        g2d.setFont(f);
        g2d.drawString("PATH BINDER : " + this.getClass().getSimpleName(), 20, 60);
        g2d.drawString("GAUGE RADIUS : " + this.getMetricsPath().getBody().getGauge().getRadius(), 20, 80);
        g2d.drawString("BINDER RADIUS : " + this.radius, 20, 100);
        g2d.drawString("BINDER POLAR RADIUS : " + this.polarRadius, 20, 120);
        g2d.drawString("BINDER POLAR DEGREE : " + this.polarDegree, 20, 140);
        g2d.drawString("BINDER DIRECTION : " + this.direction.name(), 20, 160);
        Color color = null;
        color = this.direction == Direction.Clockwise ? NanoChromatique.BLUE.brighter() : NanoChromatique.RED.brighter();
        if (this.intersectionPointStart == null || this.intersectionPointEnd == null) {
            return;
        }
        g2d.setColor(color);
        g2d.fill(new Ellipse2D.Double(this.intersectionPointStart.getX() - 3.0, this.intersectionPointStart.getY() - 3.0, 6.0, 6.0));
        g2d.fill(new Ellipse2D.Double(this.intersectionPointEnd.getX() - 3.0, this.intersectionPointEnd.getY() - 3.0, 6.0, 6.0));
        this.drawPath(g2d, this.createPath(), color);
        Font f14 = new Font("Dialog", 0, 14);
        g2d.setColor(NanoChromatique.BLUE.brighter());
        g2d.setFont(f14);
        g2d.drawString("I1", (int)this.intersectionPointStart.getX() + 5, (int)this.intersectionPointStart.getY());
        g2d.setColor(NanoChromatique.RED.brighter());
        g2d.drawString("I2", (int)this.intersectionPointEnd.getX() + 5, (int)this.intersectionPointEnd.getY());
    }

    private void drawPath(Graphics2D g2d, Shape path, Color c) {
        if (path == null) {
            return;
        }
        g2d.setColor(c);
        g2d.draw(path);
        GeometryPath geom = new GeometryPath(path);
        Shape s1 = this.creatTickDirection(path, geom.lengthOfPath() / 2.0f, 4);
        Shape s2 = this.creatTickDirection(path, geom.lengthOfPath() / 4.0f, 3);
        Shape s3 = this.creatTickDirection(path, geom.lengthOfPath() * 3.0f / 4.0f, 3);
        if (s1 != null) {
            g2d.fill(s1);
        }
        if (s2 != null) {
            g2d.fill(s2);
        }
        if (s3 != null) {
            g2d.fill(s3);
        }
    }

    private Shape creatTickDirection(Shape shape, float length, int size) {
        GeometryPath geom = new GeometryPath(shape);
        int div = size;
        if (length - (float)div > 0.0f && length + (float)(2 * div) < geom.lengthOfPath()) {
            GeneralPath path = new GeneralPath();
            Point2D p1 = geom.pointAtLength(length + (float)(2 * div));
            Point2D pl = geom.orthoLeftPointAtLength(length - (float)div, div);
            Point2D pr = geom.orthoRightPointAtLength(length - (float)div, div);
            path.moveTo(p1.getX(), p1.getY());
            path.lineTo(pr.getX(), pr.getY());
            path.lineTo(pl.getX(), pl.getY());
            path.closePath();
            return path;
        }
        return null;
    }

    public static enum Direction {
        Clockwise,
        AntiClockwise;

    }
}

