/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.binder.path;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.PathBinder;

public class PathArcManualBinder
extends PathBinder {
    private int radius;
    private float startAngleDegree;
    private float extendsAngleDegree;
    private int shiftRadius = 0;
    private float shiftAngleDegree = 0.0f;

    public PathArcManualBinder(int radius, float startAngleDegree, float extendsAngleDegree) {
        this.radius = radius;
        this.startAngleDegree = startAngleDegree;
        this.extendsAngleDegree = extendsAngleDegree;
    }

    public PathArcManualBinder(int radius, float startAngleDegree, float extendsAngleDegree, int shiftRadius, float shiftAngleDegree) {
        this(radius, startAngleDegree, extendsAngleDegree);
        this.shiftRadius = shiftRadius;
        this.shiftAngleDegree = shiftAngleDegree;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public float getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(float startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public float getExtendsAngleDegree() {
        return this.extendsAngleDegree;
    }

    public void setExtendsAngleDegree(float extendsAngleDegree) {
        this.extendsAngleDegree = extendsAngleDegree;
    }

    @Override
    public Shape bindPath(RadialGauge gauge) {
        double centerX = gauge.getCenterDevice().getX();
        double centerY = gauge.getCenterDevice().getY();
        double shiftCenterX = centerX + (double)this.shiftRadius * Math.cos(Math.toRadians(this.shiftAngleDegree));
        double shiftCenterY = centerY - (double)this.shiftRadius * Math.sin(Math.toRadians(this.shiftAngleDegree));
        Arc2D.Double arc = new Arc2D.Double(shiftCenterX - (double)this.getRadius(), shiftCenterY - (double)this.getRadius(), 2 * this.getRadius(), 2 * this.getRadius(), this.getStartAngleDegree(), this.getExtendsAngleDegree(), 0);
        return arc;
    }
}

