/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.core.binder.path;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.path.AbstractPathAutoBinder;

public class PathQuadAutoBinder
extends AbstractPathAutoBinder {
    private QuadCurve2D intersectionQuadCurve;
    private double controlOffsetRadius = 10.0;

    public PathQuadAutoBinder(int radius, int polarRadius, float polarDegree) {
        super(radius, polarRadius, polarDegree);
    }

    public PathQuadAutoBinder(int radius, int polarRadius, float polarDegree, AbstractPathAutoBinder.Direction direction) {
        super(radius, polarRadius, polarDegree, direction);
    }

    public QuadCurve2D getIntersectionQuadCurve() {
        return this.intersectionQuadCurve;
    }

    public void setIntersectionQuadCurve(QuadCurve2D intersectionQuadCurve) {
        this.intersectionQuadCurve = intersectionQuadCurve;
    }

    public double getControlOffsetRadius() {
        return this.controlOffsetRadius;
    }

    public void setControlOffsetRadius(double controlOffsetRadius) {
        if (controlOffsetRadius < 0.0) {
            throw new IllegalArgumentException("control offset radius must be positive");
        }
        this.controlOffsetRadius = controlOffsetRadius;
    }

    private QuadCurve2D createQuadStart2End() {
        return new QuadCurve2D.Double(this.intersectionPointStart.getX(), this.intersectionPointStart.getY(), this.getControlPoint().getX(), this.getControlPoint().getY(), this.intersectionPointEnd.getX(), this.intersectionPointEnd.getY());
    }

    private QuadCurve2D createQuadEnd2Start() {
        return new QuadCurve2D.Double(this.intersectionPointEnd.getX(), this.intersectionPointEnd.getY(), this.getControlPoint().getX(), this.getControlPoint().getY(), this.intersectionPointStart.getX(), this.intersectionPointStart.getY());
    }

    @Override
    public Shape createPath() {
        if (this.intersectionPointStart == null || this.intersectionPointEnd == null) {
            return null;
        }
        if (this.polarDegree >= 0.0f && this.polarDegree < 180.0f) {
            if (this.direction == AbstractPathAutoBinder.Direction.AntiClockwise) {
                this.intersectionQuadCurve = this.createQuadStart2End();
            } else if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
                this.intersectionQuadCurve = this.createQuadEnd2Start();
            }
        } else if (this.polarDegree >= 180.0f && this.polarDegree < 360.0f) {
            if (this.direction == AbstractPathAutoBinder.Direction.AntiClockwise) {
                this.intersectionQuadCurve = this.createQuadEnd2Start();
            } else if (this.direction == AbstractPathAutoBinder.Direction.Clockwise) {
                this.intersectionQuadCurve = this.createQuadStart2End();
            }
        }
        return this.intersectionQuadCurve;
    }

    private Point2D getControlPoint() {
        double x = this.x1 + ((double)this.radius + this.controlOffsetRadius) * Math.cos(Math.toRadians(this.polarDegree) + Math.PI);
        double y = this.y1 - ((double)this.radius + this.controlOffsetRadius) * Math.sin(Math.toRadians(this.polarDegree) + Math.PI);
        return new Point2D.Double(x, y);
    }

    @Override
    public void debug(Graphics2D g2d, RadialGauge gauge) {
        super.debug(g2d, gauge);
        g2d.setColor(NanoChromatique.GREEN);
        g2d.draw(new Ellipse2D.Double(this.getControlPoint().getX() - 2.0, this.getControlPoint().getY() - 2.0, 4.0, 4.0));
        g2d.setColor(new Alpha(NanoChromatique.GREEN, 100));
        g2d.draw(new Ellipse2D.Double(this.x1 - (this.r1 + this.controlOffsetRadius), this.y1 - (this.r1 + this.controlOffsetRadius), 2.0 * (this.r1 + this.controlOffsetRadius), 2.0 * (this.r1 + this.controlOffsetRadius)));
    }
}

