/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.oil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.DefaultMarker;
import org.jensoft.core.glyphmetrics.painter.marker.TriangleMarker;
import org.jensoft.core.palette.InputFonts;
import org.jensoft.core.palette.TexturePalette;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugeEnvelope;
import org.jensoft.core.plugin.gauge.core.GaugeGlass;
import org.jensoft.core.plugin.gauge.core.GaugeMetricsPath;
import org.jensoft.core.plugin.gauge.core.GaugeTextPath;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.AnchorBinder;
import org.jensoft.core.plugin.gauge.core.binder.PathBinder;
import org.jensoft.core.plugin.gauge.core.binder.path.PathArcManualBinder;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedleClassicPainter;

public class GaugeOil
extends RadialGauge {
    private static int gaugeRadius = 90;
    private static int centerUserX = 0;
    private static int centerUserY = 0;
    private GaugeBody body;
    private GaugeMetricsPath metricsPath1;
    private GaugeMetricsPath metricsPath2;
    private GaugeTextPath legendTop;
    private GaugeTextPath legendBottom;
    private GaugeTextPath legend1;
    private GaugeTextPath legend2;
    GlyphFill gfblue;
    GlyphFill gfred;
    GlyphFill gforange;
    GlyphFill gfyellow;
    TriangleMarker rmblue;
    TriangleMarker rmred;
    TriangleMarker rmyellow;
    TriangleMarker rmorange;
    TriangleMarker rmblue2;
    TriangleMarker rmred2;
    TriangleMarker rmyellow2;
    TriangleMarker rmorange2;
    Font f12;
    Font f10;

    public GaugeOil() {
        super(centerUserX, centerUserY, gaugeRadius);
        GaugeEnvelope.Cisero cisero = new GaugeEnvelope.Cisero();
        this.setEnvelop(cisero);
        GaugeBackground.Circular.Texture bg = new GaugeBackground.Circular.Texture(TexturePalette.getInterlacedCarbon1());
        this.addBackground(bg);
        GaugeGlass.GlassIncubator g3 = new GaugeGlass.GlassIncubator();
        GaugeGlass.Donut2DGlass g5 = new GaugeGlass.Donut2DGlass();
        GaugeGlass.JenSoftAPILabel g6 = new GaugeGlass.JenSoftAPILabel();
        GaugeGlass.GlassLinearEffect linearGlass = new GaugeGlass.GlassLinearEffect();
        this.addGlass((GaugeGlass)linearGlass);
        this.body = new GaugeBody();
        this.addBody(this.body);
        this.createStyle();
        this.createPath1();
        this.createPath2();
        this.createLegends();
    }

    private void createStyle() {
        this.gfblue = new GlyphFill(Color.WHITE, NanoChromatique.BLUE.brighter());
        this.gfred = new GlyphFill(Color.WHITE, NanoChromatique.RED.brighter());
        this.gforange = new GlyphFill(Color.WHITE, NanoChromatique.ORANGE.brighter());
        this.gfyellow = new GlyphFill(Color.WHITE, NanoChromatique.YELLOW.brighter());
        DefaultMarker dmred = new DefaultMarker(NanoChromatique.RED.brighter());
        DefaultMarker dmorange = new DefaultMarker(NanoChromatique.ORANGE.brighter());
        DefaultMarker dmyellow = new DefaultMarker(NanoChromatique.YELLOW.brighter());
        DefaultMarker dmblue = new DefaultMarker(NanoChromatique.BLUE.brighter());
        this.rmblue = new TriangleMarker(Color.WHITE, NanoChromatique.BLUE);
        this.rmblue.setGlobalRadialShift(5);
        this.rmblue.setDivergenceRadial(6);
        this.rmblue.setDirection(TriangleMarker.TriangleDirection.Out);
        this.rmblue2 = new TriangleMarker(Color.WHITE, NanoChromatique.BLUE);
        this.rmblue2.setGlobalRadialShift(-5);
        this.rmblue2.setDivergenceRadial(6);
        this.rmblue2.setDirection(TriangleMarker.TriangleDirection.In);
        this.rmred = new TriangleMarker(Color.WHITE, NanoChromatique.RED);
        this.rmred.setGlobalRadialShift(5);
        this.rmred.setDivergenceRadial(6);
        this.rmred.setDirection(TriangleMarker.TriangleDirection.Out);
        this.rmred2 = new TriangleMarker(Color.WHITE, NanoChromatique.RED);
        this.rmred2.setGlobalRadialShift(-5);
        this.rmred2.setDivergenceRadial(6);
        this.rmred2.setDirection(TriangleMarker.TriangleDirection.In);
        this.rmorange = new TriangleMarker(Color.WHITE, NanoChromatique.ORANGE);
        this.rmorange.setGlobalRadialShift(5);
        this.rmorange.setDivergenceRadial(6);
        this.rmorange.setDirection(TriangleMarker.TriangleDirection.Out);
        this.rmorange2 = new TriangleMarker(Color.WHITE, NanoChromatique.ORANGE);
        this.rmorange2.setGlobalRadialShift(-5);
        this.rmorange2.setDivergenceRadial(6);
        this.rmorange2.setDirection(TriangleMarker.TriangleDirection.In);
        this.rmyellow = new TriangleMarker(Color.WHITE, NanoChromatique.YELLOW);
        this.rmyellow.setGlobalRadialShift(5);
        this.rmyellow.setDivergenceRadial(6);
        this.rmyellow.setDirection(TriangleMarker.TriangleDirection.Out);
        this.rmyellow2 = new TriangleMarker(Color.WHITE, NanoChromatique.YELLOW);
        this.rmyellow2.setGlobalRadialShift(-5);
        this.rmyellow2.setDivergenceRadial(6);
        this.rmyellow2.setDirection(TriangleMarker.TriangleDirection.In);
        this.f12 = InputFonts.getFont(InputFonts.ELEMENT, 12.0f);
        this.f10 = InputFonts.getFont(InputFonts.ELEMENT, 12.0f);
    }

    private void createLegends() {
        this.legend1 = new GaugeTextPath();
        this.legend1.setPathBinder(new PathBinder(){

            @Override
            public Shape bindPath(RadialGauge gauge) {
                double centerX = GaugeOil.this.getCenterDevice().getX();
                double centerY = GaugeOil.this.getCenterDevice().getY();
                int radius = GaugeOil.this.getRadius();
                Arc2D.Double arc2TextPath1 = new Arc2D.Double(centerX - (double)radius, centerY - (double)radius, 2 * radius, 2 * radius, 240.0, -140.0, 0);
                return arc2TextPath1;
            }
        });
        float[] fractions = new float[]{0.0f, 0.8f, 1.0f};
        Color[] colors = new Color[]{NanoChromatique.WHITE, NanoChromatique.RED.brighter(), NanoChromatique.RED};
        Font f = new Font("Dialog", 0, 12);
        this.legend1.setLabelFont(f);
        this.legend1.setPathSide(TextPath.PathSide.Below);
        this.legend1.setDivergence(2);
        this.legend1.setOffsetLeft(0.0f);
        this.legend1.setOffsetRight(0.0f);
        this.legend1.setShader(fractions, colors);
        this.legend1.setLabel("PSI");
        this.body.registerGaugeTextPath(this.legend1);
        this.legend2 = new GaugeTextPath();
        this.legend2.setPathBinder(new PathBinder(){

            @Override
            public Shape bindPath(RadialGauge gauge) {
                double centerX = GaugeOil.this.getCenterDevice().getX();
                double centerY = GaugeOil.this.getCenterDevice().getY();
                int radius = GaugeOil.this.getRadius();
                Arc2D.Double arc2TextPath2 = new Arc2D.Double(centerX - (double)radius, centerY - (double)radius, 2 * radius, 2 * radius, 300.0, 140.0, 0);
                return arc2TextPath2;
            }
        });
        float[] fractions2 = new float[]{0.0f, 1.0f};
        Color[] colors2 = new Color[]{NanoChromatique.WHITE, NanoChromatique.BLUE};
        this.legend2.setLabelFont(f);
        this.legend2.setLabel("CELSIUS");
        this.legend2.setPathSide(TextPath.PathSide.Above);
        this.legend2.setShader(fractions2, colors2);
        this.legend2.setDivergence(4);
        this.legend2.setOffsetLeft(0.0f);
        this.legend2.setOffsetRight(0.0f);
        this.body.registerGaugeTextPath(this.legend2);
        this.legendTop = new GaugeTextPath();
        this.legendTop.setPathBinder(new PathBinder(){

            @Override
            public Shape bindPath(RadialGauge gauge) {
                double centerX = GaugeOil.this.getCenterDevice().getX();
                double centerY = GaugeOil.this.getCenterDevice().getY();
                int radius = GaugeOil.this.getRadius();
                int topRadius = radius + 2;
                Arc2D.Double arc2TextPathTop = new Arc2D.Double(centerX - (double)topRadius, centerY - (double)topRadius, 2 * topRadius, 2 * topRadius, 0.0, 180.0, 0);
                return arc2TextPathTop;
            }
        });
        float[] fractions3 = new float[]{0.0f, 1.0f};
        Color[] colors3 = new Color[]{NanoChromatique.WHITE, NanoChromatique.ORANGE};
        this.legendTop.setLabelFont(f);
        this.legendTop.setTextPosition(TextPath.TextPosition.Middle);
        this.legendTop.setPathSide(TextPath.PathSide.Below);
        this.legendTop.setDivergence(0);
        this.legendTop.setLockReverse(true);
        this.legendTop.setOffsetLeft(0.0f);
        this.legendTop.setOffsetRight(0.0f);
        this.legendTop.setShader(fractions3, colors3);
        this.legendTop.setLabel("*** jensoft avionics ***");
        this.body.registerGaugeTextPath(this.legendTop);
        this.legendBottom = new GaugeTextPath();
        this.legendBottom.setPathBinder(new PathBinder(){

            @Override
            public Shape bindPath(RadialGauge gauge) {
                double centerX = GaugeOil.this.getCenterDevice().getX();
                double centerY = GaugeOil.this.getCenterDevice().getY();
                int radius = GaugeOil.this.getRadius();
                int bottomRadius = radius - 10;
                Arc2D.Double arc2TextPathBottom = new Arc2D.Double(centerX - (double)bottomRadius, centerY - (double)bottomRadius, 2 * bottomRadius, 2 * bottomRadius, 180.0, 180.0, 0);
                return arc2TextPathBottom;
            }
        });
        float[] fractions4 = new float[]{0.0f, 1.0f};
        Color[] colors4 = new Color[]{NanoChromatique.WHITE, NanoChromatique.PURPLE};
        this.legendBottom.setLabelFont(f);
        this.legendBottom.setDivergence(5);
        this.legendBottom.setPathSide(TextPath.PathSide.Over);
        this.legendBottom.setTextPosition(TextPath.TextPosition.Middle);
        this.legendBottom.setOffsetLeft(0.0f);
        this.legendBottom.setOffsetRight(0.0f);
        this.legendBottom.setShader(fractions4, colors4);
        this.legendBottom.setLabel("OIL");
        this.body.registerGaugeTextPath(this.legendBottom);
    }

    private void createPath1() {
        this.metricsPath1 = new GaugeMetricsPath();
        this.metricsPath1.setMin(0.0);
        this.metricsPath1.setMax(120.0);
        this.metricsPath1.setCurrentValue(47.0);
        this.metricsPath1.setPathBinder(new PathArcManualBinder(2 * gaugeRadius - gaugeRadius / 4, -25.0f, 50.0f, 2 * gaugeRadius, 180.0f));
        this.metricsPath1.setNeedleBaseAnchorBinder(new AnchorBinder(){

            @Override
            public Point2D bindAnchor(RadialGauge gauge) {
                int radius = GaugeOil.this.getRadius();
                double anchorX = GaugeOil.this.getProjection().userToPixel(new Point2D.Double(GaugeOil.this.getX(), 0.0)).getX() - (double)radius + (double)(radius / 4);
                double anchorY = GaugeOil.this.getProjection().userToPixel(new Point2D.Double(0.0, GaugeOil.this.getY())).getY();
                return new Point2D.Double(anchorX, anchorY);
            }
        });
        this.metricsPath1.setNeedleValueAnchorBinder(new AnchorBinder(){

            @Override
            public Point2D bindAnchor(RadialGauge gauge) {
                Point2D anchorValue = GaugeOil.this.metricsPath1.getRadialPoint(GaugeOil.this.metricsPath1.getCurrentValue(), 20, Side.SideLeft);
                return anchorValue;
            }
        });
        this.body.registerGaugeMetricsPath(this.metricsPath1);
        GlyphMetric metric = new GlyphMetric();
        metric.setValue(20.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("20");
        metric.setLockReverse(true);
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfblue);
        metric.setGlyphMetricMarkerPainter(this.rmblue);
        metric.setFont(this.f10);
        this.metricsPath1.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(40.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("40");
        metric.setLockReverse(true);
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfyellow);
        metric.setGlyphMetricMarkerPainter(this.rmyellow);
        metric.setFont(this.f10);
        this.metricsPath1.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(80.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("80");
        metric.setLockReverse(true);
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gforange);
        metric.setGlyphMetricMarkerPainter(this.rmorange);
        metric.setFont(this.f10);
        this.metricsPath1.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(100.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("100");
        metric.setLockReverse(true);
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfred);
        metric.setGlyphMetricMarkerPainter(this.rmred);
        metric.setFont(this.f10);
        this.metricsPath1.addMetric(metric);
        this.metricsPath1.setGaugeNeedlePainter(new GaugeNeedleClassicPainter());
    }

    private void createPath2() {
        this.metricsPath2 = new GaugeMetricsPath();
        this.metricsPath2.setMin(0.0);
        this.metricsPath2.setMax(120.0);
        this.metricsPath2.setCurrentValue(80.0);
        this.metricsPath2.setPathBinder(new PathArcManualBinder(2 * gaugeRadius - gaugeRadius / 4, 205.0f, -50.0f, 2 * gaugeRadius, 0.0f));
        this.metricsPath2.setNeedleBaseAnchorBinder(new AnchorBinder(){

            @Override
            public Point2D bindAnchor(RadialGauge gauge) {
                int radius = GaugeOil.this.getRadius();
                double anchorX = GaugeOil.this.getProjection().userToPixel(new Point2D.Double(GaugeOil.this.getX(), 0.0)).getX() + (double)radius - (double)(radius / 4);
                double anchorY = GaugeOil.this.getProjection().userToPixel(new Point2D.Double(0.0, GaugeOil.this.getY())).getY();
                return new Point2D.Double(anchorX, anchorY);
            }
        });
        this.metricsPath2.setNeedleValueAnchorBinder(new AnchorBinder(){

            @Override
            public Point2D bindAnchor(RadialGauge gauge) {
                Point2D anchorValue = GaugeOil.this.metricsPath2.getRadialPoint(GaugeOil.this.metricsPath2.getCurrentValue(), 20, Side.SideRight);
                return anchorValue;
            }
        });
        this.metricsPath2.setGaugeNeedlePainter(new GaugeNeedleClassicPainter());
        this.body.registerGaugeMetricsPath(this.metricsPath2);
        GlyphMetric metric = new GlyphMetric();
        metric.setValue(20.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("20");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfblue);
        metric.setGlyphMetricMarkerPainter(this.rmblue2);
        metric.setFont(this.f10);
        this.metricsPath2.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(40.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("40");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfyellow);
        metric.setGlyphMetricMarkerPainter(this.rmyellow2);
        metric.setFont(this.f10);
        this.metricsPath2.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(80.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("80");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gforange);
        metric.setGlyphMetricMarkerPainter(this.rmorange2);
        metric.setFont(this.f10);
        this.metricsPath2.addMetric(metric);
        metric = new GlyphMetric();
        metric.setValue(100.0);
        metric.setStylePosition(StylePosition.Tangent);
        metric.setMetricsLabel("100");
        metric.setDivergence(5);
        metric.setGlyphMetricFill(this.gfred);
        metric.setGlyphMetricMarkerPainter(this.rmred2);
        metric.setFont(this.f10);
        this.metricsPath2.addMetric(metric);
    }
}

