/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.gauge.speedometer;

import java.awt.Color;
import java.awt.Font;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.glyphmetrics.Side;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.fill.GlyphFill;
import org.jensoft.core.glyphmetrics.painter.marker.TicTacMarker;
import org.jensoft.core.palette.InputFonts;
import org.jensoft.core.palette.TexturePalette;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.plugin.gauge.core.GaugeBackground;
import org.jensoft.core.plugin.gauge.core.GaugeBody;
import org.jensoft.core.plugin.gauge.core.GaugeEnvelope;
import org.jensoft.core.plugin.gauge.core.GaugeGlass;
import org.jensoft.core.plugin.gauge.core.GaugeMetricsPath;
import org.jensoft.core.plugin.gauge.core.RadialGauge;
import org.jensoft.core.plugin.gauge.core.binder.anchor.AnchorBaseBinder;
import org.jensoft.core.plugin.gauge.core.binder.anchor.AnchorValueBinder;
import org.jensoft.core.plugin.gauge.core.binder.path.PathArcManualBinder;
import org.jensoft.core.plugin.gauge.core.needle.GaugeNeedleClassicPainter;

public class Speedometer
extends RadialGauge {
    private static int gaugeRadius = 90;
    private static int centerUserX = 0;
    private static int centerUserY = 0;
    private GaugeMetricsPath metricsManager;

    public Speedometer() {
        super(centerUserX, centerUserY, gaugeRadius);
        GaugeEnvelope.Cisero cisero = new GaugeEnvelope.Cisero();
        this.setEnvelop(cisero);
        GaugeBackground.Circular.Texture bg = new GaugeBackground.Circular.Texture(TexturePalette.getSquareCarbonFiber());
        this.addBackground(bg);
        GaugeGlass.GlassIncubator g3 = new GaugeGlass.GlassIncubator();
        GaugeGlass.Donut2DGlass g5 = new GaugeGlass.Donut2DGlass();
        GaugeGlass.JenSoftAPILabel g6 = new GaugeGlass.JenSoftAPILabel();
        this.addGlass((GaugeGlass)g5);
        this.createBody();
    }

    public void createBody() {
        GaugeBody body = new GaugeBody();
        this.addBody(body);
        this.metricsManager = new GaugeMetricsPath();
        this.metricsManager.setMin(0.0);
        this.metricsManager.setMax(280.0);
        this.metricsManager.setCurrentValue(186.0);
        this.metricsManager.setGaugeNeedlePainter(new GaugeNeedleClassicPainter());
        this.metricsManager.setPathBinder(new PathArcManualBinder(gaugeRadius - 10, 260.0f, -340.0f));
        AnchorBaseBinder baseNeedleBinder = new AnchorBaseBinder();
        AnchorValueBinder valueNeedleBinder = new AnchorValueBinder(20, Side.SideRight);
        this.metricsManager.setNeedleBaseAnchorBinder(baseNeedleBinder);
        this.metricsManager.setNeedleValueAnchorBinder(valueNeedleBinder);
        body.registerGaugeMetricsPath(this.metricsManager);
        GlyphFill gf = new GlyphFill(Color.WHITE, NanoChromatique.RED.brighter());
        TicTacMarker ttm = new TicTacMarker(NanoChromatique.GREEN);
        ttm.setSize(3);
        ttm.setDivergence(3);
        Font f = InputFonts.getFont(InputFonts.ELEMENT, 14.0f);
        for (int i = 20; i < 250; i += 20) {
            GlyphMetric metric = new GlyphMetric();
            metric.setValue(i);
            metric.setStylePosition(StylePosition.Default);
            metric.setMetricsLabel(i + "");
            metric.setDivergence(16);
            metric.setGlyphMetricFill(gf);
            metric.setGlyphMetricMarkerPainter(ttm);
            metric.setFont(f);
            this.metricsManager.addMetric(metric);
        }
        GlyphMetric metric = new GlyphMetric();
        metric.setValue(280.0);
        metric.setStylePosition(StylePosition.Default);
        metric.setMetricsLabel("Km/h");
        metric.setDivergence(30);
        metric.setGlyphMetricFill(new GlyphFill(Color.WHITE, NanoChromatique.RED));
        Font f16 = new Font("Dialog", 0, 16);
        metric.setFont(f16);
        this.metricsManager.addMetric(metric);
    }
}

