/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.Color;
import java.awt.Stroke;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jensoft.core.plugin.PluginException;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;
import org.jensoft.core.projection.Projection;

public class ModeledGridManager
extends AbstractGridManager {
    private List<GridModel> gridModels;
    private boolean createMinimal = true;
    private GridModelComparator modelComparator = new GridModelComparator();

    public static List<GridModel> createSymmetricListModel(int exp) {
        ArrayList<GridModel> models = new ArrayList<GridModel>();
        for (int i = -exp; i <= exp; ++i) {
            GridModel m = ModeledGridManager.createExponentModel(i);
            models.add(m);
        }
        return models;
    }

    public static GridModel createExponentModel(int exp) {
        GridModel model = null;
        StringBuffer buffer = new StringBuffer();
        if (exp < 0) {
            buffer.append("0.");
            for (int j = 1; j < Math.abs(exp); ++j) {
                buffer.append("0");
            }
            buffer.append("1");
            String multiplier = buffer.toString();
            String pattern = multiplier.replace('1', '0');
            model = new GridModel(new BigDecimal(multiplier), new DecimalFormat(pattern));
        } else if (exp > 0) {
            buffer.append("1");
            for (int j = 1; j <= Math.abs(exp); ++j) {
                buffer.append("0");
            }
            String multiplier = buffer.toString();
            model = new GridModel(new BigDecimal(multiplier));
        } else if (exp == 0) {
            model = new GridModel(new BigDecimal("1"));
        }
        return model;
    }

    public ModeledGridManager(Grid.GridOrientation gridOrientation) {
        super(gridOrientation);
        this.gridModels = new ArrayList<GridModel>();
    }

    public ModeledGridManager(Grid.GridOrientation orientation, GridModel ... models) {
        this(orientation);
        this.registerGridModels(models);
    }

    public void registerGridModel(GridModel model) {
        GridModel clone = model.cloneModel();
        clone.setMetricsManager(this);
        this.gridModels.add(clone);
        if (this.createMinimal) {
            GridModel minimalModel = clone.cloneModel();
            minimalModel.setMinimal(true);
            minimalModel.setMetricsManager(this);
            this.gridModels.add(minimalModel);
        }
        Collections.sort(this.gridModels, this.modelComparator);
    }

    public void registerGridModels(GridModel ... models) {
        for (int i = 0; i < models.length; ++i) {
            this.registerGridModel(models[i]);
        }
    }

    public void registerGridModels(List<GridModel> models) {
        GridModel[] ma = models.toArray(new GridModel[models.size()]);
        this.registerGridModels(ma);
    }

    public void registerGridModels(GridModelCollections modelCollections) {
        this.registerGridModels(modelCollections.getModels());
    }

    public void unregisterGridModel(GridModel model) {
        this.gridModels.remove(model);
    }

    public void unregisterGridModels(GridModel ... models) {
        for (int i = 0; i < models.length; ++i) {
            this.unregisterGridModel(models[i]);
        }
    }

    public void unregisterGridModels(List<GridModel> models) {
        GridModel[] ma = models.toArray(new GridModel[models.size()]);
        this.unregisterGridModels(ma);
    }

    public void unregisterGridModels(GridModelCollections modelCollections) {
        this.unregisterGridModels(modelCollections.getModels());
    }

    public List<GridModel> getGridModels() {
        return this.gridModels;
    }

    public List<GridModel> getSequenceGrid() {
        ArrayList<GridModel> sequence = new ArrayList<GridModel>();
        Collections.sort(this.gridModels, this.modelComparator);
        int rank = 0;
        for (GridModel metricsModel : this.gridModels) {
            if (!metricsModel.isValid()) continue;
            sequence.add(metricsModel);
        }
        ArrayList<GridModel> remove = new ArrayList<GridModel>();
        for (GridModel model1 : sequence) {
            if (!model1.isMinimal()) continue;
            for (GridModel model2 : sequence) {
                if (model1.equals(model2) || model1.getFactor().compareTo(model2.getFactor()) != 0) continue;
                remove.add(model1);
            }
        }
        for (GridModel uselessModel : remove) {
            sequence.remove(uselessModel);
        }
        for (GridModel mm : sequence) {
            mm.setRank(rank++);
        }
        return sequence;
    }

    protected Grid generateGrid(double userValue, GridModel model) {
        double deviceValue = 0.0;
        double maxPixelValue = 0.0;
        if (this.getGridOrientation() == Grid.GridOrientation.Vertical) {
            deviceValue = this.getProjection().userToPixelX(userValue);
            maxPixelValue = this.getProjection().getPixelWidth();
        } else if (this.getGridOrientation() == Grid.GridOrientation.Horizontal) {
            deviceValue = this.getProjection().userToPixelY(userValue);
            maxPixelValue = this.getProjection().getPixelHeight();
        }
        if (deviceValue < 0.0 || deviceValue > maxPixelValue) {
            return null;
        }
        Grid grid = new Grid(this.getGridOrientation());
        grid.setGridDeviceValue(deviceValue);
        if (this.getGridColor() != null) {
            grid.setGridColor(this.getGridColor());
        } else {
            grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
        }
        if (this.getGridStroke() != null) {
            grid.setGridStroke(this.getGridStroke());
        } else {
            grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
        }
        if (model != null) {
            if (model.getGridColor() != null) {
                grid.setGridColor(model.getGridColor());
            }
            if (model.getGridStroke() != null) {
                grid.setGridStroke(model.getGridStroke());
            }
        }
        return grid;
    }

    @Override
    public List<Grid> getGrids() {
        return new ArrayList<Grid>();
    }

    public static class GridModel {
        private ModeledGridManager metricsManager;
        private DecimalFormat decimalFormat = new DecimalFormat();
        private BigDecimal factor;
        private BigDecimal ref;
        private BigDecimal maxValue;
        private int pixelLabelHolder = 6;
        private int rank;
        private Color gridColor;
        private Stroke gridStroke;
        private int pixelAxisHolder = 4;
        private boolean minimal = false;

        public boolean isValid() {
            BigDecimal bd1;
            Projection projection = this.metricsManager.getProjection();
            boolean valid = false;
            BigDecimal userSize = null;
            BigDecimal startRef = null;
            BigDecimal pixelSize = null;
            BigDecimal maxUserValue = null;
            if (this.getMetricsManager().getGridOrientation() == Grid.GridOrientation.Vertical) {
                userSize = new BigDecimal(projection.getUserWidth());
                bd1 = new BigDecimal(projection.getMinX()).divide(this.factor, RoundingMode.CEILING);
                BigInteger bi1 = bd1.toBigInteger();
                startRef = new BigDecimal(bi1).multiply(this.getFactor());
                pixelSize = new BigDecimal(projection.getPixelWidth());
                maxUserValue = new BigDecimal(projection.getMaxX());
            } else if (this.getMetricsManager().getGridOrientation() == Grid.GridOrientation.Horizontal) {
                userSize = new BigDecimal(projection.getUserHeight());
                bd1 = new BigDecimal(projection.getMinY()).divide(this.factor, RoundingMode.CEILING);
                BigInteger bi1 = bd1.toBigInteger();
                startRef = new BigDecimal(bi1).multiply(this.getFactor());
                pixelSize = new BigDecimal(projection.getPixelHeight());
                maxUserValue = new BigDecimal(projection.getMaxY());
            } else {
                throw new PluginException("Grid orientation should be supply.");
            }
            int compare = userSize.divide(this.factor, RoundingMode.HALF_EVEN).multiply(new BigDecimal(this.getPixelLabelHolder())).compareTo(pixelSize);
            if (compare == -1) {
                this.setRef(startRef);
                this.setMaxValue(maxUserValue);
                if (this.minimal) {
                    this.setPixelLabelHolder(10);
                    this.setPixelAxisHolder(0);
                } else {
                    this.setPixelLabelHolder(20);
                }
                valid = true;
            } else {
                valid = false;
            }
            return valid;
        }

        protected String formatValue(double value) {
            return this.decimalFormat.format(value);
        }

        public void setMinimal(boolean minimal) {
            this.minimal = minimal;
        }

        public boolean isMinimal() {
            return this.minimal;
        }

        public List<Grid> generateGrids() {
            ArrayList<Grid> grids = new ArrayList<Grid>();
            boolean count = false;
            for (double metricsValue = this.getRef().doubleValue(); metricsValue < this.getMaxValue().doubleValue(); metricsValue += this.getFactor().doubleValue()) {
                Grid m = this.getMetricsManager().generateGrid(metricsValue, this);
                if (m == null) continue;
                grids.add(m);
            }
            return grids;
        }

        public GridModel(BigDecimal factor) {
            this.factor = factor;
        }

        public GridModel(BigDecimal factor, DecimalFormat format) {
            this.factor = factor;
            this.decimalFormat = format;
        }

        public GridModel cloneModel() {
            GridModel clone = new GridModel(this.getFactor(), this.getDecimalFormat());
            clone.setMinimal(this.isMinimal());
            clone.setGridStroke(this.getGridStroke());
            clone.setGridColor(this.getGridColor());
            return clone;
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public int getPixelAxisHolder() {
            return this.pixelAxisHolder;
        }

        public void setPixelAxisHolder(int pixelAxisHolder) {
            this.pixelAxisHolder = pixelAxisHolder;
        }

        public ModeledGridManager getMetricsManager() {
            return this.metricsManager;
        }

        public void setMetricsManager(ModeledGridManager metricsManager) {
            this.metricsManager = metricsManager;
        }

        public BigDecimal getRef() {
            return this.ref;
        }

        public void setRef(BigDecimal ref) {
            this.ref = ref;
        }

        public BigDecimal getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(BigDecimal maxValue) {
            this.maxValue = maxValue;
        }

        public DecimalFormat getDecimalFormat() {
            return this.decimalFormat;
        }

        public void setDecimalFormat(DecimalFormat decimalFormat) {
            this.decimalFormat = decimalFormat;
        }

        public BigDecimal getFactor() {
            return this.factor;
        }

        public int getPixelLabelHolder() {
            return this.pixelLabelHolder;
        }

        public void setPixelLabelHolder(int pixelLabelHolder) {
            this.pixelLabelHolder = pixelLabelHolder;
        }

        public Color getGridColor() {
            return this.gridColor;
        }

        public void setGridColor(Color gridColor) {
            this.gridColor = gridColor;
        }

        public Stroke getGridStroke() {
            return this.gridStroke;
        }

        public void setGridStroke(Stroke stroke) {
            this.gridStroke = stroke;
        }

        public String toString() {
            return "MetricsModel [factor=" + this.factor + ", pixelLabelHolder=" + this.pixelLabelHolder + ", pixelAxisHolder=" + this.pixelAxisHolder + ", decimalFormat=" + this.decimalFormat.toPattern() + "]";
        }
    }

    public class GridModelComparator
    implements Comparator<GridModel> {
        @Override
        public int compare(GridModel m1, GridModel m2) {
            int i = m1.getFactor().compareTo(m2.getFactor());
            if (i != 0) {
                return i;
            }
            if (!m1.isMinimal() && m2.isMinimal()) {
                return 1;
            }
            if (m1.isMinimal() && m2.isMinimal()) {
                return -1;
            }
            return 0;
        }
    }

    public static enum GridModelStandard implements GridModelCollections
    {
        Yocto(-24),
        Zepto(-21),
        Atto(-18),
        Fempto(-15),
        Pico(-12),
        Nano(-9),
        Micro(-6),
        Milli(-3),
        Centi(-2),
        Deci(-1),
        Identity(0),
        Deca(1),
        Hecto(2),
        Kilo(3),
        Mega(6),
        Giga(9),
        Tera(12),
        Peta(15),
        Exa(18),
        Zeta(21),
        Yotta(24);

        private List<GridModel> models = new ArrayList<GridModel>();

        private GridModelStandard(int ... exp) {
            for (int i = 0; i < exp.length; ++i) {
                GridModel model = ModeledGridManager.createExponentModel(exp[i]);
                this.models.add(model);
            }
        }

        @Override
        public List<GridModel> getModels() {
            return this.models;
        }
    }

    public static enum GridModelRangeCollections implements GridModelCollections
    {
        YoctoYotta(24),
        ZeptoZeta(21),
        AttoExa(18),
        FemptoPeta(15),
        PicoTera(12),
        NanoGiga(9),
        MicroMega(6),
        MilliKilo(3),
        CentiHecto(2),
        DeciDeca(1),
        Identity(0);

        private List<GridModel> models = new ArrayList<GridModel>();

        private GridModelRangeCollections(int exp) {
            for (int i = -Math.abs(exp); i <= Math.abs(exp); ++i) {
                GridModel model = ModeledGridManager.createExponentModel(i);
                this.models.add(model);
            }
        }

        @Override
        public List<GridModel> getModels() {
            return this.models;
        }
    }

    public static interface GridModelCollections {
        public List<GridModel> getModels();
    }
}

