/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;

public class MultiplierGridManager
extends AbstractGridManager {
    private double multiplier = 0.0;
    private double ref = 0.0;
    private List<Grid> grids = new ArrayList<Grid>();

    public MultiplierGridManager(Grid.GridOrientation gridOrientation, double ref, double multiplier) {
        super(gridOrientation);
        this.ref = ref;
        this.multiplier = multiplier;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public double getRef() {
        return this.ref;
    }

    public void setRef(double ref) {
        this.ref = ref;
    }

    private void addGrid(Grid grid) {
        boolean flag = false;
        for (Grid g : this.grids) {
            if (!grid.equals(g)) continue;
            flag = true;
        }
        if (!flag) {
            this.grids.add(grid);
        }
    }

    @Override
    public List<Grid> getGrids() {
        Grid grid;
        Point2D p2dDevice;
        Point2D.Double p2dUser;
        Grid grid2;
        boolean flag1;
        int count1;
        int gridNumber;
        this.grids.clear();
        if (this.getGridOrientation() == Grid.GridOrientation.Vertical) {
            gridNumber = (int)(this.getProjection().getUserWidth() / this.multiplier);
            if (gridNumber < 0 || gridNumber > this.getGridMaxNumber() + 4) {
                this.grids.clear();
                return this.grids;
            }
            count1 = 0;
            flag1 = true;
            while (flag1) {
                if (this.ref + (double)count1 * this.multiplier > this.getProjection().getMinX()) {
                    Point2D.Double p2dUser2 = new Point2D.Double(this.ref + (double)count1 * this.multiplier, 0.0);
                    Point2D p2dDevice2 = this.getProjection().userToPixel(p2dUser2);
                    grid2 = new Grid(Grid.GridOrientation.Vertical);
                    grid2.setGridDeviceValue(p2dDevice2.getX());
                    if (this.getGridColor() != null) {
                        grid2.setGridColor(this.getGridColor());
                    } else {
                        grid2.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid2.setGridStroke(this.getGridStroke());
                    } else {
                        grid2.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    this.addGrid(grid2);
                }
                if (this.ref + (double)count1 * this.multiplier > this.getProjection().getMaxX()) {
                    flag1 = false;
                }
                ++count1;
            }
            int count2 = 0;
            boolean flag2 = true;
            while (flag2) {
                if (this.ref - (double)count2 * this.multiplier < this.getProjection().getMaxX()) {
                    p2dUser = new Point2D.Double(this.ref - (double)count2 * this.multiplier, 0.0);
                    p2dDevice = this.getProjection().userToPixel(p2dUser);
                    grid = new Grid(Grid.GridOrientation.Vertical);
                    grid.setGridDeviceValue(p2dDevice.getX());
                    if (this.getGridColor() != null) {
                        grid.setGridColor(this.getGridColor());
                    } else {
                        grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid.setGridStroke(this.getGridStroke());
                    } else {
                        grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    this.addGrid(grid);
                }
                if (this.ref - (double)count2 * this.multiplier < this.getProjection().getMinX()) {
                    flag2 = false;
                }
                ++count2;
            }
        }
        if (this.getGridOrientation() == Grid.GridOrientation.Horizontal) {
            gridNumber = (int)(this.getProjection().getUserHeight() / this.multiplier);
            if (gridNumber < 0 || gridNumber > this.getGridMaxNumber() + 4) {
                this.grids.clear();
                return this.grids;
            }
            count1 = 0;
            flag1 = true;
            while (flag1) {
                if (this.ref + (double)count1 * this.multiplier > this.getProjection().getMinY()) {
                    Point2D.Double p2dUser3 = new Point2D.Double(0.0, this.ref + (double)count1 * this.multiplier);
                    Point2D p2dDevice3 = this.getProjection().userToPixel(p2dUser3);
                    grid2 = new Grid(Grid.GridOrientation.Horizontal);
                    grid2.setGridDeviceValue(p2dDevice3.getY());
                    if (this.getGridColor() != null) {
                        grid2.setGridColor(this.getGridColor());
                    } else {
                        grid2.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid2.setGridStroke(this.getGridStroke());
                    } else {
                        grid2.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    this.addGrid(grid2);
                }
                if (this.ref + (double)count1 * this.multiplier > this.getProjection().getMaxY()) {
                    flag1 = false;
                }
                ++count1;
            }
            int count2 = 0;
            boolean flag2 = true;
            while (flag2) {
                if (this.ref - (double)count2 * this.multiplier < this.getProjection().getMaxY()) {
                    p2dUser = new Point2D.Double(0.0, this.ref - (double)count2 * this.multiplier);
                    p2dDevice = this.getProjection().userToPixel(p2dUser);
                    grid = new Grid(Grid.GridOrientation.Horizontal);
                    grid.setGridDeviceValue(p2dDevice.getY());
                    if (this.getGridColor() != null) {
                        grid.setGridColor(this.getGridColor());
                    } else {
                        grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid.setGridStroke(this.getGridStroke());
                    } else {
                        grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    this.addGrid(grid);
                }
                if (this.ref - (double)count2 * this.multiplier < this.getProjection().getMinY()) {
                    flag2 = false;
                }
                ++count2;
            }
        }
        if (this.grids.size() > this.getGridMaxNumber()) {
            this.grids.clear();
        }
        return this.grids;
    }
}

