/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.grid.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.grid.Grid;
import org.jensoft.core.plugin.grid.manager.AbstractGridManager;
import org.jensoft.core.plugin.grid.manager.GridManager;

public class StaticGridManager
extends AbstractGridManager {
    private int gridCount;

    public StaticGridManager(Grid.GridOrientation gridOrientation, int gridCount) {
        super(gridOrientation);
        this.gridCount = gridCount;
    }

    public int getGridCount() {
        return this.gridCount;
    }

    public void setGridCount(int gridCount) {
        this.gridCount = gridCount;
    }

    @Override
    public List<Grid> getGrids() {
        ArrayList<Grid> deviceGrids;
        block11: {
            block10: {
                deviceGrids = new ArrayList<Grid>();
                if (this.getGridOrientation() != Grid.GridOrientation.Vertical) break block10;
                double userSpaceWidth = this.getProjection().getUserWidth();
                double deltaGridUser = userSpaceWidth / (double)(this.gridCount + 1);
                for (int i = 1; i <= this.gridCount; ++i) {
                    double dx = this.getProjection().getMinX() + (double)i * deltaGridUser;
                    Point2D.Double p2dUser = new Point2D.Double(dx, 0.0);
                    Point2D p2ddevice = this.getProjection().userToPixel(p2dUser);
                    Grid grid = new Grid(Grid.GridOrientation.Vertical);
                    grid.setGridDeviceValue(p2ddevice.getX());
                    if (this.getGridColor() != null) {
                        grid.setGridColor(this.getGridColor());
                    } else {
                        grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                    }
                    if (this.getGridStroke() != null) {
                        grid.setGridStroke(this.getGridStroke());
                    } else {
                        grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                    }
                    deviceGrids.add(grid);
                }
                break block11;
            }
            if (this.getGridOrientation() != Grid.GridOrientation.Horizontal) break block11;
            double userSpaceWidth = this.getProjection().getUserHeight();
            double deltaGridUser = userSpaceWidth / (double)(this.gridCount + 1);
            for (int i = 1; i <= this.gridCount; ++i) {
                double dy = this.getProjection().getMinY() + (double)i * deltaGridUser;
                Point2D.Double p2dUser = new Point2D.Double(0.0, dy);
                Point2D p2ddevice = this.getProjection().userToPixel(p2dUser);
                Grid grid = new Grid(Grid.GridOrientation.Horizontal);
                grid.setGridDeviceValue(p2ddevice.getX());
                if (this.getGridColor() != null) {
                    grid.setGridColor(this.getGridColor());
                } else {
                    grid.setGridColor(GridManager.DEFAULT_BLACKCOLOR);
                }
                if (this.getGridStroke() != null) {
                    grid.setGridStroke(this.getGridStroke());
                } else {
                    grid.setGridStroke(GridManager.DEFAULT_BASICSTROKE);
                }
                deviceGrids.add(grid);
            }
        }
        return deviceGrids;
    }
}

