/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.data;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.legend.data.DataLegend;
import org.jensoft.core.plugin.legend.data.painter.AbstractDataLegendBackgroundPainter;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class DataLegendPlugin
extends AbstractPlugin {
    private DataLegend legend;

    public DataLegendPlugin() {
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.setName(DataLegendPlugin.class.getCanonicalName());
    }

    public DataLegendPlugin(DataLegend legend) {
        this();
        this.legend = legend;
    }

    public void setLegend(DataLegend legend) {
        this.legend = legend;
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        AbstractDataLegendBackgroundPainter painter;
        if (viewPart != this.legend.getPart()) {
            return;
        }
        if (this.legend.getFont() != null) {
            g2d.setFont(this.legend.getFont());
        }
        FontMetrics metrics = g2d.getFontMetrics();
        int height = metrics.getHeight();
        int descent = metrics.getDescent();
        int startX = this.legend.getMarginX() + this.legend.getPaddingLeft();
        int startY = this.legend.getMarginY() + this.legend.getPaddingTop();
        int symbolBoundWidth = this.legend.getSymbolBoundWidth();
        int deltaWrapLine = this.legend.getDeltaWrapLine();
        int currentX = startX;
        int currentY = startY;
        JComponent legendHolder = this.getProjection().getView().getViewPartComponent(this.legend.getPart());
        int partWidth = ((Component)legendHolder).getWidth();
        int partHeight = ((Component)legendHolder).getHeight();
        int maxCurrentY = 0;
        int maxCurrentX = 0;
        int extendsX = 0;
        int extendsY = 0;
        HashMap<DataLegend.Item, Point2D.Double> map1 = new HashMap<DataLegend.Item, Point2D.Double>();
        HashMap<DataLegend.Item, Rectangle2D.Double> map2 = new HashMap<DataLegend.Item, Rectangle2D.Double>();
        List<DataLegend.Item> items = this.legend.getItems();
        if (this.legend.getOrientation() == DataLegend.Orientation.Column) {
            int maxWidth = 0;
            for (DataLegend.Item item : items) {
                Rectangle2D.Double bound;
                int itemTextWidth = metrics.stringWidth(item.getText());
                maxWidth = Math.max(maxWidth, itemTextWidth);
                if (currentY + height < partHeight) {
                    bound = new Rectangle2D.Double(currentX, currentY - height + descent, symbolBoundWidth, height);
                    map2.put(item, bound);
                    map1.put(item, new Point2D.Double(currentX + symbolBoundWidth + this.legend.getMarkerTextInterval(), currentY));
                } else {
                    maxWidth = itemTextWidth;
                    currentX = currentX + maxWidth + symbolBoundWidth + 40;
                    currentY = startY;
                    bound = new Rectangle2D.Double(currentX, currentY - height + descent, symbolBoundWidth, height);
                    map2.put(item, bound);
                    map1.put(item, new Point2D.Double(currentX + symbolBoundWidth + this.legend.getMarkerTextInterval(), currentY));
                }
                currentY = currentY + height + deltaWrapLine;
                maxCurrentY = Math.max(currentY, maxCurrentY);
                extendsX = currentX + symbolBoundWidth + this.legend.getMarkerTextInterval() + maxWidth;
                extendsY = Math.max(currentY, maxCurrentY);
            }
        } else if (this.legend.getOrientation() == DataLegend.Orientation.Row) {
            int itemHInterval = 20;
            for (DataLegend.Item item : items) {
                Rectangle2D.Double bound;
                if (currentX + this.legend.getMarkerTextInterval() + itemHInterval + metrics.stringWidth(item.getText()) + this.legend.getPaddingRight() < partWidth) {
                    bound = new Rectangle2D.Double(currentX, currentY - height + descent, symbolBoundWidth, height);
                    map2.put(item, bound);
                    map1.put(item, new Point2D.Double(currentX + symbolBoundWidth + this.legend.getMarkerTextInterval(), currentY));
                } else {
                    currentX = startX;
                    currentY = currentY + height + deltaWrapLine;
                    bound = new Rectangle2D.Double(currentX, currentY - height + descent, symbolBoundWidth, height);
                    map2.put(item, bound);
                    map1.put(item, new Point2D.Double(currentX + symbolBoundWidth + this.legend.getMarkerTextInterval(), currentY));
                }
                currentX = currentX + symbolBoundWidth + this.legend.getMarkerTextInterval() + metrics.stringWidth(item.getText()) + itemHInterval;
                maxCurrentX = Math.max(currentX, maxCurrentX);
                maxCurrentY = Math.max(currentY, maxCurrentY);
            }
            extendsX = maxCurrentX - itemHInterval;
            extendsY = maxCurrentY + height;
        }
        if ((painter = this.legend.getBackgroundPainter()) != null) {
            painter.paintBackground(g2d, new Rectangle2D.Double(this.legend.getMarginX(), this.legend.getMarginY() - height, extendsX - this.legend.getMarginX() + this.legend.getPaddingRight(), extendsY - this.legend.getMarginY() + this.legend.getPaddingBottom()), this.legend);
        }
        for (DataLegend.Item item : items) {
            g2d.setColor(item.getColor());
            item.getSymbolPainter().paintSymbol(g2d, (Rectangle2D)map2.get(item), item);
            if (item.getTextColor() != null) {
                g2d.setColor(item.getTextColor());
            }
            g2d.drawString(item.getText(), (int)((Point2D)map1.get(item)).getX(), (int)((Point2D)map1.get(item)).getY());
        }
    }
}

