/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.data.painter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.plugin.legend.data.DataLegend;
import org.jensoft.core.plugin.legend.data.painter.AbstractDataLegendBackgroundPainter;

public class DefaultDataLegendBackgroundPainter
extends AbstractDataLegendBackgroundPainter {
    private int radius = 0;
    private float alpha = 1.0f;
    private BasicStroke stroke = new BasicStroke();
    private Color outlineColor;
    private Color fillColor;
    private TexturePaint texture;

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        this.alpha = alpha;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public TexturePaint getTexture() {
        return this.texture;
    }

    public void setTexture(TexturePaint texture) {
        this.texture = texture;
    }

    @Override
    public void paintDataLegendBackground(Graphics2D g2d, Rectangle2D backgroundBound, DataLegend legend) {
        float acomposite = ((AlphaComposite)g2d.getComposite()).getAlpha();
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(backgroundBound.getX(), backgroundBound.getY(), backgroundBound.getWidth(), backgroundBound.getHeight(), this.radius, this.radius);
        if (this.fillColor != null) {
            g2d.setColor(this.fillColor);
            g2d.fill(rect);
        }
        if (this.texture != null) {
            g2d.setPaint(this.texture);
            g2d.fill(rect);
        }
        if (this.outlineColor != null) {
            g2d.setStroke(this.stroke);
            g2d.setColor(this.outlineColor);
            g2d.draw(rect);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, acomposite));
    }
}

