/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.data.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.legend.data.DataLegend;
import org.jensoft.core.plugin.legend.data.painter.AbstractDataItemSymbolPainter;

public class LineSymbolPainter
extends AbstractDataItemSymbolPainter {
    private Stroke stroke = new BasicStroke();

    public LineSymbolPainter() {
    }

    public LineSymbolPainter(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void paintItemSymbol(Graphics2D g2d, Rectangle2D symbolBound, DataLegend.Item item) {
        g2d.setColor(item.getColor());
        g2d.setStroke(this.stroke);
        Line2D.Double line = new Line2D.Double(symbolBound.getX(), symbolBound.getY() + symbolBound.getHeight() / 2.0, symbolBound.getX() + symbolBound.getWidth(), symbolBound.getY() + symbolBound.getHeight() / 2.0);
        g2d.draw(line);
    }
}

