/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.title;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.TitleLegendPlugin;
import org.jensoft.core.plugin.legend.title.painter.AbstractTitleLegendDraw;
import org.jensoft.core.plugin.legend.title.painter.AbstractTitleLegendFill;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendGradientFill;

public class TitleLegend {
    private String text;
    private Font font;
    private Color themeColor;
    private TitleLegendConstraints constraints = new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth);
    private TitleLegendPlugin host;
    private AbstractTitleLegendFill legendFill = new TitleLegendGradientFill();
    private AbstractTitleLegendDraw legendDraw;
    private List<GlyphGeometry> legendGlyphs;

    public TitleLegend(String text) {
        this.text = text;
        this.legendGlyphs = new ArrayList<GlyphGeometry>();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public TitleLegendConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(TitleLegendConstraints constraints) {
        this.constraints = constraints;
    }

    public Font getFont() {
        if (this.font == null) {
            return new Font("tahoma", 0, 12);
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public TitleLegendPlugin getHost() {
        return this.host;
    }

    public void setHost(TitleLegendPlugin host) {
        this.host = host;
    }

    public AbstractTitleLegendFill getLegendFill() {
        return this.legendFill;
    }

    public void setLegendFill(AbstractTitleLegendFill legendFill) {
        this.legendFill = legendFill;
    }

    public AbstractTitleLegendDraw getLegendDraw() {
        return this.legendDraw;
    }

    public void setLegendDraw(AbstractTitleLegendDraw legendDraw) {
        this.legendDraw = legendDraw;
    }

    public List<GlyphGeometry> getLegendGlyphs() {
        return this.legendGlyphs;
    }

    public void setGlyphShapes(List<GlyphGeometry> legendGlyphs) {
        this.legendGlyphs = legendGlyphs;
    }

    public void addLegendGlyph(GlyphGeometry legendGlyph) {
        this.legendGlyphs.add(legendGlyph);
    }

    public void clearLegendGlyph() {
        this.legendGlyphs.clear();
    }
}

