/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.title;

public class TitleLegendConstraints {
    private float depth;
    private LegendPosition position;
    private LegendAlignment alignment = LegendAlignment.Middle;

    public TitleLegendConstraints(LegendPosition position, float depth, LegendAlignment alignment) {
        this.setPosition(position);
        this.setDepth(depth);
        this.setAlignement(alignment);
    }

    public LegendPosition getPosition() {
        return this.position;
    }

    public void setPosition(LegendPosition position) {
        this.position = position;
    }

    public void setDepth(float depth) {
        if (depth < 0.0f || depth > 1.0f) {
            throw new IllegalArgumentException("Illegal depth, supply value [0...1]");
        }
        this.depth = depth;
    }

    public float getDepth() {
        return this.depth;
    }

    public LegendAlignment getAlignement() {
        return this.alignment;
    }

    public void setAlignement(LegendAlignment alignement) {
        this.alignment = alignement;
    }

    public static enum LegendAlignment {
        Left("left"),
        Middle("middle"),
        Rigth("right");

        private String legendAlignment;

        private LegendAlignment(String alignment) {
            this.legendAlignment = alignment;
        }

        public String getLegendAlignment() {
            return this.legendAlignment;
        }

        public static LegendAlignment parse(String alignment) {
            if (Left.getLegendAlignment().equalsIgnoreCase(alignment)) {
                return Left;
            }
            if (Middle.getLegendAlignment().equalsIgnoreCase(alignment)) {
                return Middle;
            }
            if (Rigth.getLegendAlignment().equalsIgnoreCase(alignment)) {
                return Rigth;
            }
            return null;
        }
    }

    public static enum LegendPosition {
        South("south"),
        North("north"),
        West("west"),
        East("east");

        private String legendPosition;

        private LegendPosition(String position) {
            this.legendPosition = position;
        }

        public String getLegendPosition() {
            return this.legendPosition;
        }

        public static LegendPosition parse(String position) {
            if (South.getLegendPosition().equalsIgnoreCase(position)) {
                return South;
            }
            if (North.getLegendPosition().equalsIgnoreCase(position)) {
                return North;
            }
            if (West.getLegendPosition().equalsIgnoreCase(position)) {
                return West;
            }
            if (East.getLegendPosition().equalsIgnoreCase(position)) {
                return East;
            }
            return null;
        }
    }
}

