/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.title;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.glyphmetrics.GlyphUtil;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.Dithering;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.painter.fil.TitleLegendGradientFill;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class TitleLegendPlugin
extends AbstractPlugin {
    private List<TitleLegend> legends;

    public TitleLegendPlugin() {
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setDithering(Dithering.On);
        this.setName(TitleLegendPlugin.class.getCanonicalName());
        this.legends = new ArrayList<TitleLegend>();
    }

    public TitleLegendPlugin(TitleLegend legend) {
        this();
        this.addLegend(legend);
    }

    public void addLegend(TitleLegend legend) {
        legend.setHost(this);
        if (!this.legends.contains(legend)) {
            this.legends.add(legend);
        }
    }

    private boolean isAccessible(ViewPart viewPart, TitleLegend legend) {
        TitleLegendConstraints contraints = legend.getConstraints();
        if (contraints == null) {
            return false;
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.South && viewPart != ViewPart.South) {
            return false;
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.North && viewPart != ViewPart.North) {
            return false;
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.West && viewPart != ViewPart.West) {
            return false;
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.East && viewPart != ViewPart.East) {
            return false;
        }
        return viewPart != ViewPart.Device;
    }

    private void solveLegends(View view, Graphics2D g2d, TitleLegend legend) {
        JComponent windowComponent;
        TitleLegendConstraints contraints = legend.getConstraints();
        legend.clearLegendGlyph();
        String labelLegend = legend.getText();
        g2d.setFont(legend.getFont());
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector legendGlyphVector = legend.getFont().createGlyphVector(frc, labelLegend);
        float legendWidth = GlyphUtil.getGlyphWidth(legendGlyphVector);
        View v2d = legend.getHost().getProjection().getView();
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.West || contraints.getPosition() == TitleLegendConstraints.LegendPosition.East) {
            windowComponent = null;
            double depth = 0.0;
            if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.West) {
                windowComponent = v2d.getViewPartComponent(ViewPart.West);
                depth = (float)windowComponent.getWidth() * (1.0f - contraints.getDepth());
            }
            if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.East) {
                windowComponent = v2d.getViewPartComponent(ViewPart.East);
                depth = (float)windowComponent.getWidth() * contraints.getDepth();
            }
            int height = windowComponent.getHeight();
            AffineTransform af = new AffineTransform();
            for (int i = 0; i < legendGlyphVector.getNumGlyphs(); ++i) {
                Point2D p = legendGlyphVector.getGlyphPosition(i);
                float px = (float)p.getX();
                float py = (float)p.getY();
                Point2D pointGlyph = null;
                if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Middle) {
                    pointGlyph = new Point2D.Double(depth, (float)(height / 2) + legendWidth / 2.0f - GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i));
                } else if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Left) {
                    pointGlyph = new Point2D.Double(depth, (float)height - GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i));
                } else if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Rigth) {
                    pointGlyph = new Point2D.Double(depth, legendWidth - GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i));
                }
                Shape glyph = legendGlyphVector.getGlyphOutline(i);
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.rotate(-1.5707963267948966);
                af.translate(-px, -py);
                Shape ts = af.createTransformedShape(glyph);
                Point2D.Double srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                Point2D.Double dstNorth = new Point2D.Double();
                Point2D.Double srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                Point2D.Double dstSouth = new Point2D.Double();
                Point2D.Double srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstEast = new Point2D.Double();
                Point2D.Double srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                GlyphGeometry legendGlyph = new GlyphGeometry(ts, dstNorth, dstSouth, dstWest, dstEast);
                legend.addLegendGlyph(legendGlyph);
            }
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.South || contraints.getPosition() == TitleLegendConstraints.LegendPosition.North) {
            windowComponent = null;
            int startX = 0;
            int width = 0;
            double depth = 0.0;
            if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.South) {
                windowComponent = v2d.getViewPartComponent(ViewPart.South);
                depth = (float)windowComponent.getHeight() * contraints.getDepth();
            } else if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.North) {
                windowComponent = v2d.getViewPartComponent(ViewPart.North);
                depth = (float)windowComponent.getHeight() * (1.0f - contraints.getDepth());
            }
            startX = v2d.getPlaceHolderAxisWest();
            width = windowComponent.getWidth() - v2d.getPlaceHolderAxisEast() - v2d.getPlaceHolderAxisWest();
            AffineTransform af = new AffineTransform();
            for (int i = 0; i < legendGlyphVector.getNumGlyphs(); ++i) {
                Point2D p = legendGlyphVector.getGlyphPosition(i);
                float px = (float)p.getX();
                float py = (float)p.getY();
                Point2D pointGlyph = null;
                if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Middle) {
                    pointGlyph = new Point2D.Double((float)(startX + width / 2) - legendWidth / 2.0f + GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i), depth);
                } else if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Rigth) {
                    pointGlyph = new Point2D.Double((float)(startX + width) - legendWidth + GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i), depth);
                } else if (contraints.getAlignement() == TitleLegendConstraints.LegendAlignment.Left) {
                    pointGlyph = new Point2D.Double((float)startX + GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, i), depth);
                }
                Shape glyph = legendGlyphVector.getGlyphOutline(i);
                af.setToTranslation(pointGlyph.getX(), pointGlyph.getY());
                af.translate(-px, -py);
                Shape ts = af.createTransformedShape(glyph);
                Point2D.Double srcNorth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY());
                Point2D.Double dstNorth = new Point2D.Double();
                Point2D.Double srcSouth = new Point2D.Double(glyph.getBounds2D().getCenterX(), glyph.getBounds2D().getY() + glyph.getBounds2D().getHeight());
                Point2D.Double dstSouth = new Point2D.Double();
                Point2D.Double srcEast = new Point2D.Double(glyph.getBounds2D().getX() + glyph.getBounds2D().getWidth(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstEast = new Point2D.Double();
                Point2D.Double srcWest = new Point2D.Double(glyph.getBounds2D().getX(), glyph.getBounds2D().getCenterY());
                Point2D.Double dstWest = new Point2D.Double();
                af.transform(srcNorth, dstNorth);
                af.transform(srcSouth, dstSouth);
                af.transform(srcEast, dstEast);
                af.transform(srcWest, dstWest);
                GlyphGeometry legendGlyph = new GlyphGeometry(ts, dstNorth, dstSouth, dstWest, dstEast);
                legend.addLegendGlyph(legendGlyph);
            }
        }
    }

    public void paintLegend(View v2d, Graphics2D g2d, ViewPart viewPart) {
        for (TitleLegend legend : this.legends) {
            if (!this.isAccessible(viewPart, legend)) continue;
            this.solveLegends(v2d, g2d, legend);
            if (legend.getLegendFill() != null) {
                legend.getLegendFill().paintLegend(g2d, legend);
            }
            if (legend.getLegendDraw() == null) continue;
            legend.getLegendDraw().paintLegend(g2d, legend);
        }
    }

    @Override
    public final void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        this.paintLegend(view, g2d, viewPart);
    }

    public static TitleLegend createLegend(String label) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill());
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill());
        legend.setConstraints(constraints);
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill());
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill());
        legend.setConstraints(constraints);
        return legend;
    }

    public static TitleLegend createLegend(String label, Color color) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill(color, color));
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, Color color, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill(color, color));
        legend.setConstraints(constraints);
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font, Color color) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill(color, color));
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font, Color color, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill(color, color));
        legend.setConstraints(constraints);
        return legend;
    }

    public static TitleLegend createLegend(String label, Color color1, Color color2) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill(color1, color2));
        Font f = new Font("Dialog", 0, 12);
        legend.setFont(f);
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.North, 0.1f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, Color color1, Color color2, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setLegendFill(new TitleLegendGradientFill(color1, color2));
        legend.setConstraints(constraints);
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font, Color color1, Color color2) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill(color1, color2));
        legend.setConstraints(new TitleLegendConstraints(TitleLegendConstraints.LegendPosition.South, 0.8f, TitleLegendConstraints.LegendAlignment.Rigth));
        return legend;
    }

    public static TitleLegend createLegend(String label, Font font, Color color1, Color color2, TitleLegendConstraints constraints) {
        TitleLegend legend = new TitleLegend(label);
        legend.setFont(font);
        legend.setLegendFill(new TitleLegendGradientFill(color1, color2));
        legend.setConstraints(constraints);
        return legend;
    }
}

