/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.legend.title.painter.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphGeometry;
import org.jensoft.core.plugin.legend.title.TitleLegend;
import org.jensoft.core.plugin.legend.title.TitleLegendConstraints;
import org.jensoft.core.plugin.legend.title.painter.AbstractTitleLegendDraw;

public class TitleLegendDefaultDraw
extends AbstractTitleLegendDraw {
    private Color color1 = Color.BLACK;
    private Color color2 = Color.BLACK;

    public TitleLegendDefaultDraw() {
    }

    public TitleLegendDefaultDraw(Color color) {
        this.color1 = color;
        this.color2 = color;
    }

    public TitleLegendDefaultDraw(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    @Override
    protected void paintLegendDraw(Graphics2D g2d, TitleLegend legend) {
        LinearGradientPaint pg;
        Color[] colors;
        float[] dist;
        Point2D.Double end;
        Point2D.Double start;
        List<GlyphGeometry> legendGlyphs;
        TitleLegendConstraints contraints = legend.getConstraints();
        g2d.setFont(legend.getFont());
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.West || contraints.getPosition() == TitleLegendConstraints.LegendPosition.East) {
            g2d.setColor(legend.getThemeColor());
            legendGlyphs = legend.getLegendGlyphs();
            for (GlyphGeometry legendGlyph : legendGlyphs) {
                start = new Point2D.Double(legendGlyph.getNorthTransform().getX(), legendGlyph.getNorthTransform().getY());
                if (start.equals(end = new Point2D.Double(legendGlyph.getSouthTransform().getX(), legendGlyph.getSouthTransform().getY()))) continue;
                dist = new float[]{0.0f, 1.0f};
                colors = new Color[]{this.color1, this.color2};
                pg = new LinearGradientPaint(start, end, dist, colors);
                g2d.setPaint(pg);
                g2d.draw(legendGlyph.getGlyphShape());
            }
        }
        if (contraints.getPosition() == TitleLegendConstraints.LegendPosition.South || contraints.getPosition() == TitleLegendConstraints.LegendPosition.North) {
            g2d.setColor(legend.getThemeColor());
            legendGlyphs = legend.getLegendGlyphs();
            for (GlyphGeometry legendGlyph : legendGlyphs) {
                start = new Point2D.Double(legendGlyph.getNorthTransform().getX(), legendGlyph.getNorthTransform().getY());
                if (start.equals(end = new Point2D.Double(legendGlyph.getSouthTransform().getX(), legendGlyph.getSouthTransform().getY()))) continue;
                dist = new float[]{0.0f, 1.0f};
                colors = new Color[]{this.color1, this.color2};
                pg = new LinearGradientPaint(start, end, dist, colors);
                g2d.setPaint(pg);
                g2d.draw(legendGlyph.getGlyphShape());
            }
        }
    }
}

