/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.linesymbol.LineSymbolWidget;
import org.jensoft.core.plugin.linesymbol.LineSymbolWidgetGeometry;
import org.jensoft.core.plugin.linesymbol.core.LineSymbol;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolGroup;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.widget.Widget;

public class LineSymbolPlugin
extends AbstractPlugin
implements AbstractPlugin.OnMoveListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnClickListener,
AbstractPlugin.OnDragListener,
AbstractPlugin.OnWheelListener {
    private LineNature lineNature;
    private double startScrollX;
    private double startScrollY;
    private double currentScrollX;
    private double currentScrollY;
    private List<LineSymbolComponent> lineComponents = new ArrayList<LineSymbolComponent>();
    private LineSymbolWidget lineSymbolWidget;
    private boolean lockScroll = false;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int WEST = 2;
    public static final int EAST = 3;
    private int divergence = 0;
    private int divergenceIncrement = 50;

    public LineSymbolPlugin() {
        this.setName("Line Symbol Plugin");
        this.setSelectable(true);
        this.setOnMoveListener(this);
        this.setOnClickListener(this);
        this.setOnDragListener(this);
        this.setOnMoveListener(this);
        this.setOnReleaseListener(this);
        this.setOnPressListener(this);
        this.lineSymbolWidget = new LineSymbolWidget();
        this.registerWidget((Widget)this.lineSymbolWidget);
    }

    public LineNature getLineNature() {
        return this.lineNature;
    }

    public void setLineNature(LineNature lineNature) {
        this.lineNature = lineNature;
    }

    public void addLineComponent(LineSymbolComponent lineComponent) {
        lineComponent.setHost(this);
        this.lineComponents.add(lineComponent);
    }

    public void removeLineComponent(LineSymbolComponent lineComponent) {
        this.lineComponents.remove(lineComponent);
    }

    public List<LineSymbolComponent> getLineComponents() {
        return this.lineComponents;
    }

    public double getComponentXPosition(LineSymbolComponent lineComponent) {
        List<LineSymbolComponent> barComponents = this.getLineComponents();
        double positionX = 0.0;
        ArrayList<LineSymbolComponent> bcomps = new ArrayList<LineSymbolComponent>();
        for (LineSymbolComponent bc : barComponents) {
            if (bc instanceof LineSymbolGroup) {
                bcomps.addAll(((LineSymbolGroup)bc).getLineComponents());
                continue;
            }
            bcomps.add(bc);
        }
        for (LineSymbolComponent bc : bcomps) {
            if (!bc.equals(lineComponent)) {
                positionX += bc.getThickness();
                continue;
            }
            return positionX;
        }
        return positionX;
    }

    public double getComponentYPosition(LineSymbolComponent lineComponent) {
        List<LineSymbolComponent> barComponents = this.getLineComponents();
        double positionY = 0.0;
        ArrayList<LineSymbolComponent> bcomps = new ArrayList<LineSymbolComponent>();
        for (LineSymbolComponent bc : barComponents) {
            if (bc instanceof LineSymbolGroup) {
                bcomps.addAll(((LineSymbolGroup)bc).getLineComponents());
                continue;
            }
            bcomps.add(bc);
        }
        for (LineSymbolComponent bc : bcomps) {
            if (!bc.equals(lineComponent)) {
                positionY += bc.getThickness();
                continue;
            }
            return positionY;
        }
        return positionY;
    }

    private void resolveLineGeometry() {
        if (this.getLineNature() == LineNature.LineX) {
            this.resolveLineXComponents();
        }
        if (this.getLineNature() == LineNature.LineY) {
            this.resolveLineYComponents();
        }
    }

    private void resolveLineXComponents() {
        for (LineSymbolComponent barComponent : this.getLineComponents()) {
            this.resolveLineXComponent(barComponent);
        }
    }

    private void resolveLineYComponents() {
        for (LineSymbolComponent barComponent : this.getLineComponents()) {
            this.resolveLineYComponent(barComponent);
        }
    }

    private void resolveLineXComponent(LineSymbolComponent lineComponent) {
        lineComponent.setLineNature(LineNature.LineX);
        if (lineComponent instanceof LineSymbol) {
            if (lineComponent instanceof LineSymbolGroup) {
                this.resolveLineXGroup((LineSymbolGroup)lineComponent);
            } else {
                this.resolveLineX((LineSymbol)lineComponent);
            }
        }
    }

    private void resolveLineYComponent(LineSymbolComponent lineComponent) {
        lineComponent.setLineNature(LineNature.LineY);
        if (lineComponent instanceof LineSymbol) {
            if (lineComponent instanceof LineSymbolGroup) {
                this.resolveLineYGroup((LineSymbolGroup)lineComponent);
            } else {
                this.resolveLineY((LineSymbol)lineComponent);
            }
        }
    }

    private void resolveLineXGroup(LineSymbolGroup lineGroup) {
        List<LineSymbolComponent> bars = lineGroup.getLineComponents();
        for (LineSymbolComponent bc : bars) {
            this.resolveLineXComponent(bc);
        }
    }

    private void resolveLineYGroup(LineSymbolGroup lineGroup) {
        List<LineSymbolComponent> bars = lineGroup.getLineComponents();
        for (LineSymbolComponent bc : bars) {
            this.resolveLineYComponent(bc);
        }
    }

    private void resolveLineX(LineSymbol lineSymbol) {
        double yLocation = this.getComponentYPosition(lineSymbol);
        lineSymbol.setLocation(yLocation - (double)this.divergence);
    }

    private void resolveLineY(LineSymbol lineSymbol) {
        double xLocation = this.getComponentXPosition(lineSymbol);
        lineSymbol.setLocation(xLocation - (double)this.divergence);
    }

    protected void paintXLineSymbol(View v2d, Graphics2D g2d, LineSymbol ls) {
        if (ls.getLinePainter() != null) {
            ls.getLinePainter().paintLineSymbol(g2d, ls);
        }
        if (ls.getSymbolPainter() != null) {
            ls.getSymbolPainter().paintLineSymbol(g2d, ls);
        }
    }

    protected void paintYLineSymbol(View v2d, Graphics2D g2d, LineSymbol ls) {
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart == ViewPart.Device) {
            this.resolveLineGeometry();
            for (LineSymbolComponent lsc : this.getLineComponents()) {
                if (!(lsc instanceof LineSymbol)) continue;
                if (lsc.getLineNature() == LineNature.LineX) {
                    this.paintXLineSymbol(view, g2d, (LineSymbol)lsc);
                    continue;
                }
                if (lsc.getLineNature() != LineNature.LineY) continue;
                this.paintYLineSymbol(view, g2d, (LineSymbol)lsc);
            }
        }
    }

    @Override
    public void onWheel(MouseWheelEvent mwe) {
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (!this.isLockScroll()) {
            return;
        }
        this.scroll(me.getX(), me.getY());
    }

    @Override
    public void onClick(MouseEvent me) {
    }

    @Override
    public void onRelease(MouseEvent me) {
        this.handleControlReleased(me);
        this.stopScroll(me.getX(), me.getY());
    }

    @Override
    public void onPress(MouseEvent me) {
        this.handleControlMove(me);
        this.startScroll(me.getX(), me.getY());
    }

    public void startScroll(double x, double y) {
        this.startScrollX = x;
        this.startScrollY = y;
        this.lockScroll();
    }

    public boolean isLockScroll() {
        return this.lockScroll;
    }

    public void unlockScroll() {
        this.lockScroll = false;
    }

    public void lockScroll() {
        this.lockScroll = true;
    }

    public void scroll(double x, double y) {
        this.currentScrollX = x;
        this.currentScrollY = y;
        double deltaDeviceX = this.currentScrollX - this.startScrollX;
        double deltaDeviceY = this.currentScrollY - this.startScrollY;
        if (this.lineNature == LineNature.LineX) {
            this.divergence += (int)deltaDeviceY;
        } else if (this.lineNature == LineNature.LineY) {
            this.divergence += (int)deltaDeviceX;
        }
        this.startScrollX = this.currentScrollX;
        this.startScrollY = this.currentScrollY;
    }

    public void stopScroll(double x, double y) {
        this.unlockScroll();
    }

    @Override
    public void onMove(MouseEvent me) {
        this.handleControlMoved(me);
    }

    private void handleControlReleased(MouseEvent e) {
    }

    private void handleControlMoved(MouseEvent e) {
        if (this.lineSymbolWidget == null) {
            return;
        }
        LineSymbolWidgetGeometry lineSymbolPadWidget = this.lineSymbolWidget.getControl();
        if (lineSymbolPadWidget == null) {
            return;
        }
        if (e == null) {
            return;
        }
        if (!this.lineSymbolWidget.getWidgetFolder().getBounds2D().contains(e.getX(), e.getY())) {
            return;
        }
        lineSymbolPadWidget.unlockAllSensibleShape();
        if (lineSymbolPadWidget.getNorthSensibleShape() != null && lineSymbolPadWidget.getNorthSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            lineSymbolPadWidget.setLockNorthSensible(true);
        }
        if (lineSymbolPadWidget.getEastSensibleShape() != null && lineSymbolPadWidget.getEastSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            lineSymbolPadWidget.setLockEastSensible(true);
        }
        if (lineSymbolPadWidget.getSouthSensibleShape() != null && lineSymbolPadWidget.getSouthSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            lineSymbolPadWidget.setLockSouthSensible(true);
        }
        if (lineSymbolPadWidget.getWestSensibleShape() != null && lineSymbolPadWidget.getWestSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            lineSymbolPadWidget.setLockWestSensible(true);
        }
        this.getProjection().getView().getDevice2D().repaint();
    }

    private void inflate() {
        this.divergence += this.divergenceIncrement;
        this.getProjection().getDevice2D().repaintDevice();
    }

    private void deflate() {
        this.divergence -= this.divergenceIncrement;
        this.getProjection().getDevice2D().repaintDevice();
    }

    private void handleControlMove(MouseEvent e) {
        if (this.lineSymbolWidget == null) {
            return;
        }
        LineSymbolWidgetGeometry control = this.lineSymbolWidget.getControl();
        if (control == null) {
            return;
        }
        if (control.getNorthSensibleShape() != null && control.getNorthSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            this.inflate();
            return;
        }
        if (control.getEastSensibleShape() != null && control.getEastSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            new SmoothScroll(3).start();
            return;
        }
        if (control.getSouthSensibleShape() != null && control.getSouthSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            this.deflate();
            return;
        }
        if (control.getWestSensibleShape() != null && control.getWestSensibleShape().contains(new Point2D.Double(e.getX(), e.getY()))) {
            new SmoothScroll(2).start();
            return;
        }
    }

    class SmoothScroll
    extends Thread {
        private int direction;

        public SmoothScroll(int direction) {
            this.direction = direction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                switch (this.direction) {
                    case 0: {
                        this.interrupt();
                        break;
                    }
                    case 1: {
                        this.interrupt();
                        break;
                    }
                    case 2: {
                        this.interrupt();
                        break;
                    }
                    case 3: {
                        this.interrupt();
                    }
                }
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum LineNature {
        LineX,
        LineY;

    }
}

