/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.linesymbol.LineSymbolPlugin;
import org.jensoft.core.plugin.linesymbol.LineSymbolWidgetGeometry;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;

public class LineSymbolWidget
extends Widget {
    public static final String ID = "@widget/objectif";
    private static final int widgetRadius = 32;
    private LineSymbolWidgetGeometry objectifControl = new LineSymbolWidgetGeometry(0, 0, 32);

    public LineSymbolWidget() {
        super(ID, 64.0, 64.0, 100, 100);
    }

    @Override
    public final boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof LineSymbolPlugin;
    }

    public LineSymbolWidgetGeometry getControl() {
        return this.objectifControl;
    }

    private void paintEWLineSymbolWidget(Graphics2D g2d) {
        if (!((AbstractPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        this.setWidth(64.0);
        this.setHeight(32.0);
        WidgetFolder currentFolder = this.getWidgetFolder();
        int tcx = (int)(currentFolder.getX() + currentFolder.getWidth() / 2.0);
        int tcy = (int)(currentFolder.getY() + currentFolder.getHeight() / 2.0);
        this.objectifControl.setCenterX(tcx);
        this.objectifControl.setCenterY(tcy);
        this.objectifControl.buildEastWest();
        g2d.setColor(this.getThemeColor().darker());
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2d.setColor(this.getThemeColor().darker());
        g2d.setStroke(new BasicStroke(0.8f));
        g2d.fill(this.objectifControl.getControlShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getControlShape());
        if (this.objectifControl.isLockEastSensible()) {
            g2d.setColor(this.getThemeColor().brighter());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            g2d.setColor(this.getThemeColor().darker());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        g2d.fill(this.objectifControl.getEastSensibleShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getEastSensibleShape());
        if (this.objectifControl.isLockWestSensible()) {
            g2d.setColor(this.getThemeColor().brighter());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            g2d.setColor(this.getThemeColor().darker());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        g2d.fill(this.objectifControl.getWestSensibleShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getWestSensibleShape());
    }

    private void paintNSLineSymbolWidget(Graphics2D g2d) {
        if (!((AbstractPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        this.setWidth(32.0);
        this.setHeight(64.0);
        WidgetFolder currentFolder = this.getWidgetFolder();
        int tcx = (int)(currentFolder.getX() + currentFolder.getWidth() / 2.0);
        int tcy = (int)(currentFolder.getY() + currentFolder.getHeight() / 2.0);
        this.objectifControl.setCenterX(tcx);
        this.objectifControl.setCenterY(tcy);
        this.objectifControl.buildNorthSouth();
        g2d.setColor(this.getThemeColor().darker());
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g2d.setColor(this.getThemeColor().darker());
        g2d.setStroke(new BasicStroke(0.8f));
        g2d.fill(this.objectifControl.getControlShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getControlShape());
        if (this.objectifControl.isLockNorthSensible()) {
            g2d.setColor(this.getThemeColor().brighter());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            g2d.setColor(this.getThemeColor().darker());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        g2d.fill(this.objectifControl.getNorthSensibleShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getNorthSensibleShape());
        if (this.objectifControl.isLockSouthSensible()) {
            g2d.setColor(this.getThemeColor().brighter());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            g2d.setColor(this.getThemeColor().darker());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        g2d.fill(this.objectifControl.getSouthSensibleShape());
        g2d.setColor(Color.WHITE);
        g2d.draw(this.objectifControl.getSouthSensibleShape());
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        if (((LineSymbolPlugin)this.getHost()).isLockSelected() && ((LineSymbolPlugin)this.getHost()).getLineNature() == LineSymbolPlugin.LineNature.LineX) {
            this.paintNSLineSymbolWidget(g2d);
        }
        if (((LineSymbolPlugin)this.getHost()).getLineNature() == LineSymbolPlugin.LineNature.LineY) {
            this.paintEWLineSymbolWidget(g2d);
        }
    }
}

