/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol.core;

import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;

public class LineSymbolBox
extends LineSymbolComponent {
    private FillerAxis fillerAxis;
    private FillerType fillerType;

    public FillerAxis getFillerAxis() {
        return this.fillerAxis;
    }

    public void setFillerAxis(FillerAxis fillerAxis) {
        this.fillerAxis = fillerAxis;
    }

    public FillerType getFillerType() {
        return this.fillerType;
    }

    public void setFillerType(FillerType fillerType) {
        this.fillerType = fillerType;
    }

    public static LineSymbolBox createHorizontalStrut(double strut) {
        LineSymbolBox boxStrut = new LineSymbolBox();
        boxStrut.setName("LineBox.horizontal.Strut." + strut);
        boxStrut.setThickness(strut);
        boxStrut.setFillerType(FillerType.Strut);
        boxStrut.setFillerAxis(FillerAxis.XAxis);
        return boxStrut;
    }

    public static LineSymbolComponent createHorizontalGlue() {
        LineSymbolBox bGlue = new LineSymbolBox();
        bGlue.setName("LineBox.horizontal.Glue");
        bGlue.setFillerType(FillerType.Glue);
        bGlue.setFillerAxis(FillerAxis.XAxis);
        return bGlue;
    }

    public static LineSymbolComponent createVerticalStrut(double strut) {
        LineSymbolBox boxStrut = new LineSymbolBox();
        boxStrut.setName("LineBox.vertical.Strut." + strut);
        boxStrut.setThickness(strut);
        boxStrut.setFillerType(FillerType.Strut);
        boxStrut.setFillerAxis(FillerAxis.YAxis);
        return boxStrut;
    }

    public static LineSymbolComponent createVerticalGlue() {
        LineSymbolBox bGlue = new LineSymbolBox();
        bGlue.setName("LineBox.vertical.Glue");
        bGlue.setFillerType(FillerType.Glue);
        bGlue.setFillerAxis(FillerAxis.YAxis);
        return bGlue;
    }

    public static enum FillerType {
        Glue,
        Strut;

    }

    public static enum FillerAxis {
        YAxis,
        XAxis;

    }
}

