/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.linesymbol.raysymbol;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.linesymbol.LineSymbolPlugin;
import org.jensoft.core.plugin.linesymbol.core.LineSymbolComponent;
import org.jensoft.core.plugin.linesymbol.painter.AbstractLinePainter;
import org.jensoft.core.plugin.linesymbol.raysymbol.RayEntry;
import org.jensoft.core.plugin.linesymbol.raysymbol.RayLineSymbol;
import org.jensoft.core.projection.Projection;

public class RayLinePainter
extends AbstractLinePainter {
    private Color drawColor;
    private Color fillColor;

    public RayLinePainter(Color drawColor, Color fillColor) {
        this.drawColor = drawColor;
        this.fillColor = fillColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void paintLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        if (lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineX) {
            this.paintXLineSymbol(g2d, lineSymbolComponent);
        } else if (lineSymbolComponent.getLineNature() == LineSymbolPlugin.LineNature.LineY) {
            this.paintYLineSymbol(g2d, lineSymbolComponent);
        }
    }

    private void paintXLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        Projection w2d = lineSymbolComponent.getHost().getProjection();
        RayLineSymbol rls = (RayLineSymbol)lineSymbolComponent;
        for (RayEntry entry : rls.getEntries()) {
            double rayStart = entry.getRayStart();
            double rayEnd = entry.getRayEnd();
            Point2D deviceStartX = w2d.userToPixel(new Point2D.Double(rayStart, 0.0));
            Point2D deviceEndX = w2d.userToPixel(new Point2D.Double(rayEnd, 0.0));
            double y = rls.getGeometry().getBaseLine().getY1();
            Rectangle2D.Double rayBar = new Rectangle2D.Double(deviceStartX.getX(), y - 2.0, deviceEndX.getX() - deviceStartX.getX(), 4.0);
            g2d.setColor(this.fillColor);
            g2d.fill(rayBar);
            g2d.setColor(this.drawColor);
            g2d.draw(rayBar);
        }
        Line2D baseLine = lineSymbolComponent.getGeometry().getBaseLine();
        double ystart = baseLine.getY1();
        g2d.setColor(TangoPalette.SKYBLUE2);
        g2d.drawString(rls.getSymbol(), 20, (int)(ystart - 4.0));
    }

    private void paintYLineSymbol(Graphics2D g2d, LineSymbolComponent lineSymbolComponent) {
        RayLineSymbol ils = (RayLineSymbol)lineSymbolComponent;
        for (RayEntry entry : ils.getEntries()) {
            double value = entry.getRayStart();
            Projection w2d = lineSymbolComponent.getHost().getProjection();
            Point2D deviceStartY = w2d.userToPixel(new Point2D.Double(0.0, value));
            double x = lineSymbolComponent.getLocation();
        }
    }
}

