/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.map;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.map.layer.AbstractMapLayer;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.map.projection.Projection2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class MapLayerPlugin
extends AbstractPlugin {
    private List<AbstractMapLayer> mapLayers = new ArrayList<AbstractMapLayer>();
    private Projection2D projectionAdapter = new Projection2D(){

        @Override
        public double pixelToLongitude(double pixelX) {
            return MapLayerPlugin.this.getMapProjection().pixelToUserX(pixelX);
        }

        @Override
        public double pixelToLatitude(double pixelY) {
            return MapLayerPlugin.this.getMapProjection().pixelToUserY(pixelY);
        }

        @Override
        public GeoPosition pixelToGeo(Point2D pixel) {
            Point2D geo = MapLayerPlugin.this.getMapProjection().pixelToUser(pixel);
            return new GeoPosition(geo.getY(), geo.getX());
        }

        @Override
        public double longitudeToPixel(double longitude) {
            return MapLayerPlugin.this.getMapProjection().userToPixelX(longitude);
        }

        @Override
        public double latitudeToPixel(double latitude) {
            return MapLayerPlugin.this.getMapProjection().userToPixelY(latitude);
        }

        @Override
        public Point2D geoToPixel(GeoPosition position) {
            return MapLayerPlugin.this.getMapProjection().userToPixel(new Point2D.Double(position.getLongitude(), position.getLatitude()));
        }
    };

    public MapLayerPlugin() {
        this.setName("MapLayerPlugin");
    }

    public void registerLayer(AbstractMapLayer mapLayer) {
        this.mapLayers.add(mapLayer);
    }

    public Projection.Map getMapProjection() {
        return (Projection.Map)this.getProjection();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        for (AbstractMapLayer layer : this.mapLayers) {
            layer.setProjection2D(this.projectionAdapter);
            layer.doPaint(g2d);
        }
    }
}

