/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.marker;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.marker.marker.AbstractMarker;
import org.jensoft.core.plugin.marker.marker.CrossMarker;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.view.WidgetPlugin;

public class MarkerPlugin
extends AbstractPlugin
implements AbstractPlugin.OnDragListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnEnterListener,
AbstractPlugin.OnExitListener {
    private List<AbstractMarker> markers;
    private AbstractMarker floatingMarker;
    private boolean lockCross = false;
    private Stroke bs = new BasicStroke();
    int count = 1;
    private int SENSITIVITY = 5;

    public MarkerPlugin() {
        this.setSelectable(true);
        this.setName("MarkerPlugin");
        this.markers = new ArrayList<AbstractMarker>();
        this.floatingMarker = new CrossMarker();
        this.floatingMarker.setHost(this);
        this.setOnDragListener(this);
        this.setOnEnterListener(this);
        this.setOnExitListener(this);
        this.setOnMoveListener(this);
        this.setOnPressListener(this);
        this.setOnReleaseListener(this);
        this.setPriority(10000);
        this.setTextAntialising(TextAntialiasing.On);
    }

    public void addMarker(AbstractMarker marker) {
        marker.setHost(this);
        this.markers.add(marker);
    }

    public void removeMarker(AbstractMarker marker) {
        marker.setHost(null);
        this.markers.remove(marker);
    }

    public AbstractMarker getFloatingMarker() {
        return this.floatingMarker;
    }

    public void setFloatingMarker(AbstractMarker floatingMarker) {
        this.floatingMarker = floatingMarker;
    }

    @Override
    public void lockSelected() {
        super.lockSelected();
        this.getProjection().getView().getWidgetPlugin().pushMessage("LOCK " + this.getName().toUpperCase(), this, WidgetPlugin.PushingBehavior.Fast);
    }

    @Override
    public void unlockSelected() {
        super.unlockSelected();
        this.getProjection().getDevice2D().repaintDevice();
    }

    public MarkerLockUnlockAction getMarkerLockUnlockAction() {
        return new MarkerLockUnlockAction();
    }

    public CreateMarkerAction getCreateMarkerAction(AbstractMarker marker) {
        return new CreateMarkerAction(marker);
    }

    public MarkerDeleteAllAction getMarkerDeleteAllAction() {
        return new MarkerDeleteAllAction();
    }

    public void deleteMarker(CrossMarker marker) {
        this.markers.remove(marker);
    }

    private void pasteNewMarker(AbstractMarker marker) {
        marker.setHost(this);
        Projection proj = this.getProjection();
        Point2D.Double p2dCross = new Point2D.Double(this.floatingMarker.getMarkerX(), this.floatingMarker.getMarkerY());
        Point2D p2dCrossUser = proj.pixelToUser(p2dCross);
        marker.setMarkerX(p2dCrossUser.getX());
        marker.setMarkerY(p2dCrossUser.getY());
        ++this.count;
        this.markers.add(marker);
        this.getProjection().getDevice2D().repaintDevice();
    }

    private void deleteAllMarkers() {
        this.markers.clear();
        this.getProjection().getDevice2D().repaintDevice();
    }

    public void lockCross() {
        this.lockCross = true;
    }

    public void unlockCross() {
        this.lockCross = false;
    }

    public boolean isLockCross() {
        return this.lockCross;
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onRelease(MouseEvent me) {
        for (int i = 0; i < this.markers.size(); ++i) {
            AbstractMarker cm = this.markers.get(i);
            if (!cm.isLockMove()) continue;
            cm.unlockMove();
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            AbstractMarker cm = this.markers.get(i);
            if (!cm.isLockIntercept()) continue;
            cm.lockMove();
            this.unlockCross();
            return;
        }
        if (me.getModifiers() == 4) {
            return;
        }
        if (me.getModifiers() == 16) {
            int currentX = me.getX();
            int currentY = me.getY();
            this.floatingMarker.setMarkerX(currentX);
            this.floatingMarker.setMarkerY(currentY);
            this.lockCross();
            this.getProjection().getDevice2D().repaintDevice();
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        this.interceptCrossMarker(me);
    }

    @Override
    public void onDrag(MouseEvent me) {
        if (!this.isLockSelected()) {
            return;
        }
        if (!this.isLockCross()) {
            return;
        }
        int currentX = me.getX();
        int currentY = me.getY();
        Projection w2d = this.getProjection();
        for (int i = 0; i < this.markers.size(); ++i) {
            AbstractMarker cm = this.markers.get(i);
            if (!cm.isLockMove()) continue;
            Point2D.Double curentDevice = new Point2D.Double(currentX, currentY);
            Point2D curentUser = w2d.pixelToUser(curentDevice);
            cm.setMarkerX(curentUser.getX());
            cm.setMarkerY(curentUser.getY());
            this.getProjection().getDevice2D().repaintDevice();
        }
        if (!this.isLockCross()) {
            return;
        }
        this.floatingMarker.setMarkerX(currentX);
        this.floatingMarker.setMarkerY(currentY);
        this.getProjection().getDevice2D().repaintDevice();
    }

    private void interceptCrossMarker(MouseEvent e) {
        Projection window = this.getProjection();
        for (int i = 0; i < this.markers.size(); ++i) {
            AbstractMarker cm = this.markers.get(i);
            Point2D.Double targetP2dUser = new Point2D.Double(cm.getMarkerX(), cm.getMarkerY());
            Point2D targetP2dDevice = window.userToPixel(targetP2dUser);
            if ((double)e.getX() < targetP2dDevice.getX() + (double)this.SENSITIVITY && (double)e.getX() > targetP2dDevice.getX() - (double)this.SENSITIVITY && (double)e.getY() < targetP2dDevice.getY() + (double)this.SENSITIVITY && (double)e.getY() > targetP2dDevice.getY() - (double)this.SENSITIVITY) {
                cm.lockIntercept();
                continue;
            }
            cm.unlockIntercept();
        }
        this.getProjection().getDevice2D().repaintDevice();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        this.floatingMarker.paintMarker(v2d, g2d);
        for (AbstractMarker marker : this.markers) {
            marker.paintMarker(v2d, g2d);
        }
    }

    class DeleteMarkerAction
    implements ActionListener {
        private CrossMarker marker;

        public DeleteMarkerAction(CrossMarker marker) {
            this.marker = marker;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarkerPlugin.this.deleteMarker(DeleteMarkerAction.this.marker);
                }
            });
        }
    }

    public class MarkerDeleteAllAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarkerPlugin.this.deleteAllMarkers();
                }
            });
        }
    }

    public class CreateMarkerAction
    implements ActionListener {
        private AbstractMarker marker;

        public CreateMarkerAction(AbstractMarker marker) {
            this.marker = marker;
        }

        public AbstractMarker getMarker() {
            return this.marker;
        }

        public void setMarker(AbstractMarker marker) {
            this.marker = marker;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarkerPlugin.this.pasteNewMarker(CreateMarkerAction.this.marker);
                }
            });
        }
    }

    public class MarkerLockUnlockAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (MarkerPlugin.this.isLockSelected()) {
                MarkerPlugin.this.unlockSelected();
            } else {
                MarkerPlugin.this.lockSelected();
            }
        }
    }
}

