/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.message;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneLayout;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.message.MessagePlugin;
import org.jensoft.core.plugin.message.ui.MessageScrollbarUI;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public class Message
extends JComponent {
    static final long serialVersionUID = 2615212624870835049L;
    private MessageArea area;
    private MessagePlugin host;
    private boolean visibleMessage = false;
    private String text;
    private String title;
    private int messageWidth = 300;
    private int messageHeight = 150;
    private Header header;
    int xStartMove;
    int yStartMove;
    boolean move = false;
    boolean resize = false;
    private JTextArea textArea;
    private boolean lockDeleteBackground = false;
    private boolean lockMinimizeBackground = false;
    private boolean lockMaximizeBackground = false;
    private boolean lockMinimize = true;
    private boolean lockMaximize = false;
    private Rectangle2D miniFrame;
    private boolean lockMiniFrameRollover = false;
    private SizerComponent NSizer = new SizerComponent(SizerPart.N);
    private SizerComponent SSizer = new SizerComponent(SizerPart.S);
    private SizerComponent WSizer = new SizerComponent(SizerPart.W);
    private SizerComponent ESizer = new SizerComponent(SizerPart.E);
    private SizerComponent NESizer = new SizerComponent(SizerPart.NE);
    private SizerComponent NWSizer = new SizerComponent(SizerPart.NW);
    private SizerComponent SESizer = new SizerComponent(SizerPart.SE);
    private SizerComponent SWSizer = new SizerComponent(SizerPart.SW);

    public Message() {
        this.area = new MessageArea();
        this.area.getArea().setForeground(Color.BLACK);
        this.area.getArea().setFont(new Font("Tahoma", 0, 11));
        this.area.getArea().setSelectionColor(new Alpha(Spectral.SPECTRAL_RED.brighter(), 100));
        this.header = new Header();
        this.header.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Message.this.move) {
                    int tx = e.getX();
                    int ty = e.getY();
                    int x = (int)(Message.this.getBounds().getX() + (double)(tx - Message.this.xStartMove));
                    int y = (int)(Message.this.getBounds().getY() + (double)(ty - Message.this.yStartMove));
                    int width = (int)Message.this.getBounds().getWidth();
                    int height = (int)Message.this.getBounds().getHeight();
                    if (x < 5) {
                        x = 5;
                    }
                    if (x + width > Message.this.getHost().getProjection().getDevice2D().getDeviceWidth() - 5) {
                        x = Message.this.getHost().getProjection().getDevice2D().getDeviceWidth() - width - 5;
                    }
                    if (y < 5) {
                        y = 5;
                    }
                    if (y + height > Message.this.getHost().getProjection().getDevice2D().getDeviceHeight() - 5) {
                        y = Message.this.getHost().getProjection().getDevice2D().getDeviceHeight() - height - 5;
                    }
                    Rectangle newBound = new Rectangle(x, y, width, height);
                    Message.this.setBounds(newBound);
                }
            }
        });
        this.header.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Message.this.move = true;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Message.this.xStartMove = e.getX();
                Message.this.yStartMove = e.getY();
                Message.this.move = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Message.this.move = true;
                Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public void setScrollerColor(Color color) {
        this.area.getVerticalScrollBar().setUI(new MessageScrollbarUI(color));
        this.area.getHorizontalScrollBar().setUI(new MessageScrollbarUI(color));
        this.area.updateUI();
    }

    public void setMessageDimension(int width, int height) {
        this.messageWidth = width;
        this.messageHeight = height;
    }

    @Override
    public void setSize(Dimension d) {
        this.setMessageDimension((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(int width, int height) {
        this.setMessageDimension(width, height);
    }

    public int getMessageWidth() {
        return this.messageWidth;
    }

    public void setMessageWidth(int messageWidth) {
        this.messageWidth = messageWidth;
    }

    public int getMessageHeight() {
        return this.messageHeight;
    }

    public void setMessageHeight(int messageHeight) {
        this.messageHeight = messageHeight;
    }

    public Rectangle2D getMiniFrame() {
        return this.miniFrame;
    }

    public void setMessageFont(Font f) {
        this.textArea.setFont(f);
    }

    public void setMessageForeground(Color fg) {
        this.textArea.setForeground(fg);
    }

    public void setMessageTitleColor(Color fg) {
        this.header.titleLabel.setForeground(fg);
    }

    public void setMiniFrame(Rectangle2D miniFrame) {
        this.miniFrame = miniFrame;
    }

    public boolean isLockDeleteBackground() {
        return this.lockDeleteBackground;
    }

    public void setLockDeleteBackground(boolean lockDeleteBackground) {
        this.lockDeleteBackground = lockDeleteBackground;
    }

    public boolean isLockMinimizeBackground() {
        return this.lockMinimizeBackground;
    }

    public void setLockMinimizeBackground(boolean lockMinimizeBackground) {
        this.lockMinimizeBackground = lockMinimizeBackground;
    }

    public boolean isLockMaximize() {
        return this.lockMaximize;
    }

    public void setLockMaximize(boolean lockMaximize) {
        this.lockMaximize = lockMaximize;
    }

    public boolean isLockMaximizeBackground() {
        return this.lockMaximizeBackground;
    }

    public void setLockMaximizeBackground(boolean lockMaximizeBackground) {
        this.lockMaximizeBackground = lockMaximizeBackground;
    }

    public boolean isLockMinimize() {
        return this.lockMinimize;
    }

    public void setLockMinimize(boolean lockMinimize) {
        this.lockMinimize = lockMinimize;
    }

    public boolean isLockMiniFrameRollover() {
        return this.lockMiniFrameRollover;
    }

    public void setLockMiniFrameRollover(boolean lockMinimizedFrameRollover) {
        this.lockMiniFrameRollover = lockMinimizedFrameRollover;
    }

    public Message(String text) {
        this();
        this.setText(text);
    }

    public Message(String title, String text) {
        this();
        this.setText(text);
        this.setTitle(title);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textArea.setText(text);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.header.setTitle(title);
    }

    public boolean isVisibleMessage() {
        return this.visibleMessage;
    }

    public void setVisibleMessage(boolean visibleMessage) {
        this.visibleMessage = visibleMessage;
    }

    public void onClose() {
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        try {
            super.setBounds(x, y, width, height);
            int sizerSensible = 6;
            int headerHeight = 30;
            this.area.setBounds(sizerSensible, headerHeight + sizerSensible, width - 2 * sizerSensible, height - headerHeight - 2 * sizerSensible);
            this.header.setBounds(sizerSensible, sizerSensible, width - 2 * sizerSensible, headerHeight);
            this.NSizer.setBounds(sizerSensible, 0, width - 2 * sizerSensible, sizerSensible);
            this.SSizer.setBounds(sizerSensible, height - sizerSensible, width - 2 * sizerSensible, sizerSensible);
            this.WSizer.setBounds(0, sizerSensible, sizerSensible, height - 2 * sizerSensible);
            this.ESizer.setBounds(width - sizerSensible, sizerSensible, sizerSensible, height - 2 * sizerSensible);
            this.NESizer.setBounds(width - sizerSensible, 0, sizerSensible, sizerSensible);
            this.NWSizer.setBounds(0, 0, sizerSensible, sizerSensible);
            this.SESizer.setBounds(width - sizerSensible, height - sizerSensible, sizerSensible, sizerSensible);
            this.SWSizer.setBounds(0, height - sizerSensible, sizerSensible, sizerSensible);
            this.add(this.NSizer);
            this.add(this.SSizer);
            this.add(this.WSizer);
            this.add(this.ESizer);
            this.add(this.NESizer);
            this.add(this.NWSizer);
            this.add(this.SESizer);
            this.add(this.SWSizer);
            this.add(this.area);
            this.add(this.header);
            this.area.updateUI();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public MessagePlugin getHost() {
        return this.host;
    }

    public void setHost(MessagePlugin host) {
        this.host = host;
    }

    public MessageArea getArea() {
        return this.area;
    }

    @Override
    protected void paintComponent(Graphics g) {
        RectangularShape r = null;
        r = !this.isLockMaximize() ? new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 2, this.getHeight() - 2, 20.0, 20.0) : new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (this.lockDeleteBackground) {
            g2d.setColor(new Alpha(Color.red, 80));
        } else if (this.lockMinimizeBackground) {
            g2d.setColor(new Alpha(Color.YELLOW, 80));
        } else if (this.lockMaximizeBackground) {
            g2d.setColor(new Alpha(TangoPalette.ORANGE3, 80));
        } else {
            g2d.setColor(new Alpha(Spectral.SPECTRAL_BLUE2, 80));
        }
        g2d.fill(r);
        g2d.setStroke(new BasicStroke(1.0f));
        if (this.lockDeleteBackground) {
            g2d.setColor(new Alpha(Color.red, 250));
        } else if (this.lockMinimizeBackground) {
            g2d.setColor(new Alpha(Color.WHITE, 240));
        } else if (!this.isLockMaximize()) {
            g2d.setColor(new Alpha(Color.WHITE, 240));
            g2d.draw(r);
        }
    }

    class MessageArea
    extends JScrollPane {
        private static final long serialVersionUID = 7540521627693732418L;

        public MessageArea() {
            this.setName("Jensoft MessageArea");
            Message.this.textArea = new JTextArea();
            Message.this.textArea.setOpaque(false);
            this.setLayout(new ScrollPaneLayout.UIResource());
            this.setVerticalScrollBarPolicy(20);
            this.setHorizontalScrollBarPolicy(30);
            this.setViewport(this.createViewport());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getViewport().setOpaque(false);
            this.setOpaque(false);
            this.setVerticalScrollBar(this.createVerticalScrollBar());
            this.setHorizontalScrollBar(this.createHorizontalScrollBar());
            this.getVerticalScrollBar().setUI(new MessageScrollbarUI());
            this.getHorizontalScrollBar().setUI(new MessageScrollbarUI());
            this.getVerticalScrollBar().setPreferredSize(new Dimension(12, 1000));
            this.getHorizontalScrollBar().setPreferredSize(new Dimension(1000, 12));
            this.setViewportView(Message.this.textArea);
            if (!this.getComponentOrientation().isLeftToRight()) {
                this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
            }
            this.updateUI();
        }

        public JTextArea getArea() {
            return Message.this.textArea;
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }

    class SizerComponent
    extends JComponent {
        private SizerPart part;
        private int startX;
        private int startY;
        private int currentX;
        private int currentY;

        public SizerComponent(SizerPart part) {
            this.part = part;
            this.createSizerListener();
        }

        private void resizeMessage() {
            int deltaX = this.currentX - this.startX;
            int deltaY = this.currentY - this.startY;
            Rectangle r = Message.this.getBounds();
            Rectangle newBound = null;
            if (this.part == SizerPart.N) {
                newBound = new Rectangle((int)r.getX(), (int)(r.getY() + (double)deltaY), (int)r.getWidth(), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.S) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)(r.getHeight() + (double)deltaY));
            } else if (this.part == SizerPart.W) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)r.getY(), (int)(r.getWidth() - (double)deltaX), (int)r.getHeight());
            } else if (this.part == SizerPart.E) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)(r.getWidth() + (double)deltaX), (int)r.getHeight());
            } else if (this.part == SizerPart.NE) {
                newBound = new Rectangle((int)r.getX(), (int)(r.getY() + (double)deltaY), (int)(r.getWidth() + (double)deltaX), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.NW) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)(r.getY() + (double)deltaY), (int)(r.getWidth() - (double)deltaX), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.SE) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)(r.getWidth() + (double)deltaX), (int)(r.getHeight() + (double)deltaY));
            } else if (this.part == SizerPart.SW) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)r.getY(), (int)(r.getWidth() - (double)deltaX), (int)(r.getHeight() + (double)deltaY));
            }
            if (newBound.getX() < 5.0 || newBound.getX() + newBound.getWidth() > (double)(Message.this.getHost().getProjection().getDevice2D().getDeviceWidth() - 5)) {
                return;
            }
            if (newBound.getY() < 5.0 || newBound.getY() + newBound.getHeight() > (double)(Message.this.getHost().getProjection().getDevice2D().getDeviceHeight() - 5)) {
                return;
            }
            Message.this.setBounds(newBound);
        }

        private void createSizerListener() {
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!Message.this.resize) {
                        return;
                    }
                    if (SizerComponent.this.part == SizerPart.N) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(8));
                    } else if (SizerComponent.this.part == SizerPart.S) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(9));
                    } else if (SizerComponent.this.part == SizerPart.W) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(10));
                    } else if (SizerComponent.this.part == SizerPart.E) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(11));
                    } else if (SizerComponent.this.part == SizerPart.NE) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(7));
                    } else if (SizerComponent.this.part == SizerPart.NW) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(6));
                    } else if (SizerComponent.this.part == SizerPart.SE) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(5));
                    } else if (SizerComponent.this.part == SizerPart.SW) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(4));
                    }
                    SizerComponent.this.currentX = e.getX();
                    SizerComponent.this.currentY = e.getY();
                    SizerComponent.this.resizeMessage();
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Message.this.resize = false;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Message.this.resize = true;
                    SizerComponent.this.startX = e.getX();
                    SizerComponent.this.startY = e.getY();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (Message.this.resize) {
                        return;
                    }
                    Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (Message.this.resize) {
                        return;
                    }
                    if (SizerComponent.this.part == SizerPart.N) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(8));
                    } else if (SizerComponent.this.part == SizerPart.S) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(9));
                    } else if (SizerComponent.this.part == SizerPart.W) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(10));
                    } else if (SizerComponent.this.part == SizerPart.E) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(11));
                    } else if (SizerComponent.this.part == SizerPart.NE) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(7));
                    } else if (SizerComponent.this.part == SizerPart.NW) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(6));
                    } else if (SizerComponent.this.part == SizerPart.SE) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(5));
                    } else if (SizerComponent.this.part == SizerPart.SW) {
                        Message.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(4));
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }

    public static enum SizerPart {
        N,
        S,
        W,
        E,
        NE,
        NW,
        SE,
        SW;

    }

    class Header
    extends JComponent {
        private static final long serialVersionUID = -6679725693988970902L;
        JLabel titleLabel;
        JLabel close;
        JLabel maximize;
        JLabel minimize;

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.titleLabel.setBounds(10, y, 260, height);
            this.minimize.setBounds(width - 65, y, 20, height);
            this.maximize.setBounds(width - 45, y, 20, height);
            this.close.setBounds(width - 25, y, 20, height);
            this.add(this.titleLabel);
            this.add(this.minimize);
            this.add(this.maximize);
            this.add(this.close);
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        public Header() {
            ImageIcon iconClose = SharedIcon.getCommon(Common.CLOSE_SQUARE);
            ImageIcon iconMaximize = SharedIcon.getCommon(Common.MAXIMIZE_SQUARE);
            ImageIcon iconMinimize = SharedIcon.getCommon(Common.MINIMIZE_SQUARE);
            this.titleLabel = new JLabel("");
            this.titleLabel.setForeground(NanoChromatique.ORANGE);
            this.add(this.titleLabel);
            this.close = new JLabel("");
            this.close.setIcon(iconClose);
            this.add(this.close);
            this.close.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Message.this.getHost().closeCurrentMessage();
                    Message.this.onClose();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    Message.this.lockDeleteBackground = true;
                    if (Message.this.getHost() != null) {
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    Message.this.lockDeleteBackground = false;
                    if (Message.this.getHost() != null) {
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Message.this.lockDeleteBackground = false;
                    Message.this.getHost().repaintDevice();
                }
            });
            this.maximize = new JLabel("");
            this.maximize.setIcon(iconMaximize);
            this.add(this.maximize);
            this.maximize.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Message.this.lockMaximize = true;
                    Message.this.lockMinimize = false;
                    Message.this.lockMaximizeBackground = false;
                    Message.this.getHost().maximizeMessage(Message.this);
                    Message.this.getHost().repaintDevice();
                    Header.this.maximize.setEnabled(false);
                    Header.this.minimize.setEnabled(true);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    if (!Message.this.lockMaximize) {
                        Message.this.lockMaximizeBackground = true;
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (!Message.this.lockMaximize) {
                        Message.this.lockMaximizeBackground = false;
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Message.this.lockMaximizeBackground = false;
                    Message.this.getHost().repaintDevice();
                }
            });
            this.minimize = new JLabel("");
            this.minimize.setIcon(iconMinimize);
            this.minimize.setEnabled(false);
            this.add(this.minimize);
            this.minimize.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Message.this.lockMinimize = true;
                    Message.this.lockMinimizeBackground = false;
                    if (Message.this.lockMaximize) {
                        Message.this.getHost().unMaximizeMessage(Message.this);
                        Message.this.lockMaximize = false;
                    }
                    Header.this.maximize.setEnabled(true);
                    Header.this.minimize.setEnabled(false);
                    Message.this.getHost().repaintDevice();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    if (!Message.this.lockMinimize) {
                        Message.this.lockMinimizeBackground = true;
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (!Message.this.lockMinimize) {
                        Message.this.lockMinimizeBackground = false;
                        Message.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Message.this.lockMinimizeBackground = false;
                    Message.this.getHost().repaintDevice();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }
}

