/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.message;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.message.Message;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;
import org.jensoft.core.widget.Widget;

public class MessagePlugin
extends AbstractPlugin
implements AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnMoveListener,
AbstractPlugin.OnDragListener {
    private List<Message> messages = new ArrayList<Message>();
    private int currentIndex = -1;
    private Message maximizedMessage;
    private Message volatileMessage;
    private boolean sliding = false;
    private Message currentMessage;
    private VolatileMessageUnshow unshow;
    private ComponentListener messageBoundAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (MessagePlugin.this.volatileMessage != null) {
                if (MessagePlugin.this.volatileMessage.isLockMaximize()) {
                    int width = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    int height = MessagePlugin.this.getProjection().getDevice2D().getDeviceHeight();
                    MessagePlugin.this.volatileMessage.setBounds(5, 5, width - 10, height - 10);
                } else if (MessagePlugin.this.volatileMessage.isLockMinimize()) {
                    int width = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    int height = MessagePlugin.this.getProjection().getDevice2D().getDeviceHeight();
                    MessagePlugin.this.volatileMessage.setBounds(width / 2 - MessagePlugin.this.volatileMessage.getMessageWidth() / 2, height / 2 - MessagePlugin.this.volatileMessage.getMessageHeight() / 2, MessagePlugin.this.volatileMessage.getMessageWidth(), MessagePlugin.this.volatileMessage.getMessageHeight());
                }
            } else if (MessagePlugin.this.currentMessage != null) {
                if (MessagePlugin.this.currentMessage.isLockMaximize()) {
                    int width = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    int height = MessagePlugin.this.getProjection().getDevice2D().getDeviceHeight();
                    MessagePlugin.this.currentMessage.setBounds(5, 5, width - 10, height - 10);
                } else if (MessagePlugin.this.currentMessage.isLockMinimize()) {
                    int width = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    int height = MessagePlugin.this.getProjection().getDevice2D().getDeviceHeight();
                    MessagePlugin.this.currentMessage.setBounds(width / 2 - MessagePlugin.this.currentMessage.getMessageWidth() / 2, height / 2 - MessagePlugin.this.currentMessage.getMessageHeight() / 2, MessagePlugin.this.currentMessage.getMessageWidth(), MessagePlugin.this.currentMessage.getMessageHeight());
                }
            }
        }
    };

    public MessagePlugin() {
        this.setName("MessagePlugin");
        this.setOnDragListener(this);
        this.setOnMoveListener(this);
        this.setOnPressListener(this);
        this.setOnReleaseListener(this);
        this.setPriority(1000000);
    }

    public void registerMessage(Message message) {
        if (!this.messages.contains(message)) {
            message.setHost(this);
            this.messages.add(message);
        }
    }

    public boolean isLastMessage(Message message) {
        return this.messages.contains(message) && this.messages.get(this.messages.size() - 1).equals(message);
    }

    public boolean isFirstMessage(Message message) {
        return this.messages.contains(message) && this.messages.get(0).equals(message);
    }

    public boolean hasNext() {
        return this.currentIndex < this.messages.size() - 1 && this.messages.size() >= 1;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0 && this.messages.size() >= 1;
    }

    public boolean isSliding() {
        return this.sliding;
    }

    public void maximizeMessage(Message message) {
        int width = this.getProjection().getDevice2D().getDeviceWidth();
        int height = this.getProjection().getDevice2D().getDeviceHeight();
        message.setBounds(0, 0, width, height);
        this.lockPassive();
        for (Widget widget : this.getWidgets()) {
            widget.unlockWidget();
        }
        this.maximizedMessage = message;
    }

    public void unMaximizeMessage(Message message) {
        if (message.equals(this.maximizedMessage)) {
            int width = this.getProjection().getDevice2D().getDeviceWidth();
            int height = this.getProjection().getDevice2D().getDeviceHeight();
            int x = width / 2 - message.getMessageWidth() / 2;
            int y = height / 2 - message.getMessageHeight() / 2;
            message.setBounds(x, y, message.getMessageWidth() - 10, message.getMessageHeight() - 10);
            this.unlockPassive();
            for (Widget widget : this.getWidgets()) {
                widget.lockWidget();
            }
            this.maximizedMessage = null;
        }
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public int messageCount() {
        return this.messages.size();
    }

    public void showMessage(int index, Slide slide) {
        DevicePartComponent comp = this.getProjection().getView().getDevice2D();
        if (this.volatileMessage != null) {
            comp.remove(this.volatileMessage);
        }
        if (this.messages.isEmpty()) {
            return;
        }
        if (index >= -1 && index <= this.messages.size()) {
            if (index >= 0 && index <= this.messages.size() - 1) {
                Message message = this.messages.get(index);
                comp.add(message);
                MessageSlideShow ms = new MessageSlideShow(message, slide);
                ms.start();
            } else {
                MessageSlideShow ms = new MessageSlideShow(null, slide);
                ms.start();
            }
        }
    }

    public void slideToMessage(int fromIndex, int toIndex) {
        SlideRunner runner = new SlideRunner(fromIndex, toIndex);
        runner.start();
    }

    public void slideToMessage(int toIndex) {
        if (this.currentIndex < 0) {
            SlideRunner runner = new SlideRunner(0, toIndex);
            runner.start();
        } else {
            SlideRunner runner = new SlideRunner(this.getCurrentIndex(), toIndex);
            runner.start();
        }
    }

    public void closeCurrentMessage() {
        if (this.unshow != null && this.unshow.isAlive()) {
            this.unshow.interrupt();
            try {
                this.unshow.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Message msgToClose = null;
        if (this.volatileMessage != null) {
            msgToClose = this.volatileMessage;
            this.volatileMessage = null;
        } else if (this.currentMessage != null) {
            msgToClose = this.currentMessage;
            this.currentMessage = null;
        }
        if (msgToClose != null) {
            msgToClose.setLockDeleteBackground(false);
            if (msgToClose.isLockMaximize()) {
                this.unMaximizeMessage(msgToClose);
                msgToClose.setLockMaximize(false);
            }
            if (msgToClose.isLockMinimize()) {
                msgToClose.setLockMinimize(false);
            }
            this.unshow = new VolatileMessageUnshow(msgToClose, Slide.NextMessage);
            this.unshow.start();
        }
    }

    public void showVolatileMessage(Message message) {
        DevicePartComponent comp = this.getProjection().getView().getDevice2D();
        if (this.unshow != null && this.unshow.isAlive()) {
            this.unshow.interrupt();
            try {
                this.unshow.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.volatileMessage = message;
        this.volatileMessage.setHost(this);
        for (int i = 0; i < this.messages.size(); ++i) {
            comp.remove(this.messages.get(i));
        }
        this.volatileMessage.setText(this.volatileMessage.getText());
        comp.add(message);
        VolatileMessageShow vms = new VolatileMessageShow(this.volatileMessage, Slide.NextMessage);
        vms.start();
    }

    public void showVolatileMessage(Message message, long waitAndUnshow) {
        DevicePartComponent comp = this.getProjection().getView().getDevice2D();
        if (this.unshow != null && this.unshow.isAlive()) {
            this.unshow.interrupt();
            try {
                this.unshow.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.volatileMessage = message;
        this.volatileMessage.setHost(this);
        for (int i = 0; i < this.messages.size(); ++i) {
            comp.remove(this.messages.get(i));
        }
        this.volatileMessage.setText(this.volatileMessage.getText());
        comp.add(message);
        VolatileMessageShow vms = new VolatileMessageShow(this.volatileMessage, Slide.NextMessage);
        vms.start();
        final long wait = waitAndUnshow;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(wait);
                    MessagePlugin.this.closeCurrentMessage();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public void unshowVolatileMessage() {
        if (this.volatileMessage != null) {
            DevicePartComponent comp = this.getProjection().getView().getDevice2D();
            comp.remove(this.volatileMessage);
            this.volatileMessage = null;
        }
    }

    public void nextMessage() {
        ++this.currentIndex;
        if (this.currentIndex > this.messages.size() - 1) {
            this.currentIndex = this.messages.size() - 1;
        } else {
            this.showMessage(this.currentIndex, Slide.NextMessage);
        }
    }

    public void previousMessage() {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        } else {
            this.showMessage(this.currentIndex, Slide.PreviousMessage);
        }
    }

    public void unregisterMessage(Message message) {
        if (this.messages.contains(message)) {
            if (message.isLockMaximize()) {
                this.unlockPassive();
                for (Widget widget : this.getWidgets()) {
                    widget.lockWidget();
                }
            }
            this.messages.remove(message);
        }
    }

    public MessageLockUnlockAction getMessageLockUnlockAction() {
        return new MessageLockUnlockAction();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        this.getProjection().getView().removeComponentListener(this.messageBoundAdapter);
        this.getProjection().getView().addComponentListener(this.messageBoundAdapter);
        if (viewPart != ViewPart.Device) {
            return;
        }
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        double startX = 2.0;
        double startY = 2.0;
        double cellWidth = 8.0;
        double cellHeight = 8.0;
        for (int i = 0; i < this.messages.size(); ++i) {
            Rectangle2D.Double rec1 = new Rectangle2D.Double(startX, startY, cellWidth, cellHeight);
            Ellipse2D.Double rec = new Ellipse2D.Double(startX, startY, cellWidth, cellHeight);
            Message msg = this.messages.get(i);
            msg.setMiniFrame(rec1);
            if (msg.equals(this.currentMessage)) {
                if (msg.isLockDeleteBackground()) {
                    g2d.setColor(new Alpha(Color.red, 200));
                } else if (msg.isLockMaximizeBackground()) {
                    g2d.setColor(new Alpha(Spectral.SPECTRAL_BLUE2, 200));
                } else {
                    g2d.setColor(new Alpha(Spectral.SPECTRAL_YELLOW.brighter(), 200));
                }
            } else if (msg.isLockDeleteBackground()) {
                g2d.setColor(new Alpha(Color.red, 100));
            } else {
                g2d.setColor(new Color(0, 0, 0, 40));
            }
            if (msg.isLockMiniFrameRollover()) {
                g2d.setColor(new Alpha(Spectral.SPECTRAL_YELLOW.brighter(), 250));
            }
            g2d.fill(rec);
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2d.setColor(Color.WHITE);
            g2d.draw(rec);
            startY = startY + cellHeight + 4.0;
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
    }

    @Override
    public void onMove(MouseEvent me) {
        for (int i = 0; i < this.messages.size(); ++i) {
            Message msg = this.messages.get(i);
            if (msg.getMiniFrame() == null) continue;
            if (msg.getMiniFrame().contains(me.getX(), me.getY())) {
                msg.setLockMiniFrameRollover(true);
                this.getProjection().getView().repaintDevice(msg.getMiniFrame().getBounds());
                this.showVolatileMessage(msg);
                continue;
            }
            if (!msg.isLockMiniFrameRollover()) continue;
            msg.setLockMiniFrameRollover(false);
            this.getProjection().getView().repaintDevice();
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
    }

    @Override
    public void onPress(MouseEvent me) {
        for (int i = 0; i < this.messages.size(); ++i) {
            Message msg = this.messages.get(i);
            if (msg.getMiniFrame() == null || !msg.getMiniFrame().contains(me.getX(), me.getY())) continue;
            this.unshowVolatileMessage();
            this.showVolatileMessage(msg);
        }
    }

    class MessageLockUnlockAction
    implements ActionListener {
        MessageLockUnlockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MessagePlugin.this.isLockSelected()) {
                        MessagePlugin.this.unlockSelected();
                    } else {
                        MessagePlugin.this.lockSelected();
                    }
                }
            });
        }
    }

    class MessageSlideShow
    extends Thread {
        private Message m;
        private Slide slide;

        public MessageSlideShow(Message m, Slide slide) {
            this.m = m;
            this.slide = slide;
            if (m != null) {
                DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
                int x = comp.getWidth() / 2 - m.getMessageWidth() / 2;
                int y = comp.getHeight() / 2 - m.getMessageHeight() / 2;
                int w = m.getMessageWidth();
                int h = m.getMessageHeight();
                if (m.getMessageWidth() <= comp.getWidth()) {
                    x = comp.getWidth() / 2 - m.getMessageWidth() / 2;
                    w = m.getMessageWidth();
                } else {
                    x = 5;
                    w = comp.getWidth() - 10;
                    m.setMessageWidth(comp.getWidth() - 10);
                }
                if (m.getMessageHeight() <= comp.getHeight()) {
                    y = comp.getHeight() / 2 - m.getMessageHeight() / 2;
                    h = m.getMessageHeight();
                } else {
                    y = 5;
                    h = comp.getHeight();
                    m.setMessageHeight(comp.getHeight() - 10);
                }
                this.m.setBounds(-w - 100, y, w, h);
            }
        }

        @Override
        public void run() {
            MessagePlugin.this.sliding = true;
            try {
                if (this.m != null) {
                    int x;
                    int count;
                    int endX;
                    int startX;
                    this.m.setLockDeleteBackground(false);
                    MessagePlugin.this.getProjection().getView().repaintDevice();
                    this.m.setText(this.m.getText());
                    int devicewidth = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    Rectangle msgSize = this.m.getBounds();
                    Rectangle currentInitialBound = null;
                    if (MessagePlugin.this.currentMessage != null) {
                        currentInitialBound = MessagePlugin.this.currentMessage.getBounds();
                    }
                    if (this.slide == Slide.PreviousMessage) {
                        startX = (int)(-msgSize.getWidth());
                        endX = (int)((double)(devicewidth / 2) - msgSize.getWidth() / 2.0);
                        count = 1;
                        for (x = startX; x <= endX; x += 20) {
                            this.m.setBounds(x, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            if (MessagePlugin.this.currentMessage != null && MessagePlugin.this.currentMessage != this.m) {
                                MessagePlugin.this.currentMessage.setBounds((int)currentInitialBound.getX() + count++ * 20, (int)MessagePlugin.this.currentMessage.getBounds().getY(), MessagePlugin.this.currentMessage.getMessageWidth(), MessagePlugin.this.currentMessage.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        this.m.setBounds(endX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        this.m.setText(this.m.getText());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (this.slide == Slide.NextMessage) {
                        startX = devicewidth;
                        endX = (int)((double)(devicewidth / 2) - msgSize.getWidth() / 2.0);
                        count = 1;
                        for (x = startX; x >= endX; x -= 20) {
                            this.m.setBounds(x, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            if (MessagePlugin.this.currentMessage != null && MessagePlugin.this.currentMessage != this.m) {
                                MessagePlugin.this.currentMessage.setBounds((int)currentInitialBound.getX() - count++ * 20, (int)MessagePlugin.this.currentMessage.getBounds().getY(), MessagePlugin.this.currentMessage.getMessageWidth(), MessagePlugin.this.currentMessage.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        this.m.setBounds(endX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        this.m.setText(this.m.getText());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (MessagePlugin.this.currentMessage != null) {
                        DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
                        comp.remove(MessagePlugin.this.currentMessage);
                    }
                    MessagePlugin.this.currentMessage = this.m;
                } else if (MessagePlugin.this.currentMessage != null) {
                    int x;
                    int count;
                    int endX;
                    int startX;
                    MessagePlugin.this.getProjection().getView().repaintDevice();
                    int devicewidth = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    Rectangle currentInitialBound = null;
                    if (MessagePlugin.this.currentMessage != null) {
                        currentInitialBound = MessagePlugin.this.currentMessage.getBounds();
                    }
                    if (this.slide == Slide.PreviousMessage) {
                        startX = -MessagePlugin.this.currentMessage.getMessageWidth();
                        endX = devicewidth / 2 - MessagePlugin.this.currentMessage.getMessageWidth() / 2;
                        count = 1;
                        for (x = startX; x <= endX; x += 20) {
                            if (MessagePlugin.this.currentMessage != null && MessagePlugin.this.currentMessage != this.m) {
                                MessagePlugin.this.currentMessage.setBounds((int)currentInitialBound.getX() + count++ * 20, (int)MessagePlugin.this.currentMessage.getBounds().getY(), MessagePlugin.this.currentMessage.getMessageWidth(), MessagePlugin.this.currentMessage.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (this.slide == Slide.NextMessage) {
                        startX = devicewidth;
                        endX = devicewidth / 2 - MessagePlugin.this.currentMessage.getMessageWidth() / 2;
                        count = 1;
                        for (x = startX; x >= endX; x -= 20) {
                            if (MessagePlugin.this.currentMessage != null && MessagePlugin.this.currentMessage != this.m) {
                                MessagePlugin.this.currentMessage.setBounds((int)currentInitialBound.getX() - count++ * 20, (int)MessagePlugin.this.currentMessage.getBounds().getY(), MessagePlugin.this.currentMessage.getMessageWidth(), MessagePlugin.this.currentMessage.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (MessagePlugin.this.currentMessage != null) {
                        DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
                        comp.remove(MessagePlugin.this.currentMessage);
                    }
                    MessagePlugin.this.currentMessage = null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MessagePlugin.this.sliding = false;
        }
    }

    class VolatileMessageShow
    extends Thread {
        private Message m;
        private Slide slide;

        public VolatileMessageShow(Message m, Slide slide) {
            this.m = m;
            this.slide = slide;
            if (m != null) {
                DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
                int x = comp.getWidth() / 2 - m.getMessageWidth() / 2;
                int y = comp.getHeight() / 2 - m.getMessageHeight() / 2;
                int w = m.getMessageWidth();
                int h = m.getMessageHeight();
                if (m.getMessageWidth() <= comp.getWidth()) {
                    x = comp.getWidth() / 2 - m.getMessageWidth() / 2;
                    w = m.getMessageWidth();
                } else {
                    x = 5;
                    w = comp.getWidth() - 10;
                    m.setMessageWidth(comp.getWidth() - 10);
                }
                if (m.getMessageHeight() <= comp.getHeight()) {
                    y = comp.getHeight() / 2 - m.getMessageHeight() / 2;
                    h = m.getMessageHeight();
                } else {
                    y = 5;
                    h = comp.getHeight();
                    m.setMessageHeight(comp.getHeight() - 10);
                }
                if (slide == Slide.PreviousMessage) {
                    this.m.setBounds(-w - 100, y, w, h);
                } else {
                    this.m.setBounds(comp.getWidth() + 100, y, w, h);
                }
            }
        }

        @Override
        public void run() {
            MessagePlugin.this.sliding = true;
            try {
                if (this.m != null) {
                    int x;
                    boolean count;
                    int endX;
                    int startX;
                    this.m.setLockDeleteBackground(false);
                    MessagePlugin.this.getProjection().getView().repaintDevice();
                    this.m.setText(this.m.getText());
                    int devicewidth = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    Rectangle msgSize = this.m.getBounds();
                    if (this.slide == Slide.PreviousMessage) {
                        startX = (int)(-msgSize.getWidth());
                        endX = (int)((double)(devicewidth / 2) - msgSize.getWidth() / 2.0);
                        count = true;
                        this.m.setBounds(startX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                        for (x = startX; x <= endX; x += 20) {
                            this.m.setBounds(x, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        this.m.setBounds(endX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        this.m.setText(this.m.getText());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (this.slide == Slide.NextMessage) {
                        startX = devicewidth;
                        endX = (int)((double)(devicewidth / 2) - msgSize.getWidth() / 2.0);
                        count = true;
                        this.m.setBounds(startX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                        for (x = startX; x >= endX; x -= 20) {
                            this.m.setBounds(x, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        this.m.setBounds(endX, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                        this.m.setText(this.m.getText());
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MessagePlugin.this.sliding = false;
        }
    }

    class VolatileMessageUnshow
    extends Thread {
        private Message m;
        private Slide slide;

        public VolatileMessageUnshow(Message m, Slide slide) {
            this.m = m;
            this.slide = slide;
        }

        @Override
        public void run() {
            MessagePlugin.this.sliding = true;
            try {
                if (this.m != null) {
                    int x;
                    int count;
                    int endX;
                    int startX;
                    MessagePlugin.this.getProjection().getView().repaintDevice();
                    int devicewidth = MessagePlugin.this.getProjection().getDevice2D().getDeviceWidth();
                    Rectangle currentInitialBound = null;
                    if (this.m != null) {
                        currentInitialBound = this.m.getBounds();
                    }
                    if (this.slide == Slide.PreviousMessage) {
                        startX = -this.m.getMessageWidth();
                        endX = devicewidth / 2 - this.m.getMessageWidth() / 2;
                        count = 1;
                        for (x = startX; x <= endX; x += 20) {
                            if (this.m != null) {
                                this.m.setBounds((int)currentInitialBound.getX() + count++ * 20, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                    if (this.slide == Slide.NextMessage) {
                        startX = devicewidth;
                        endX = devicewidth / 2 - this.m.getMessageWidth() / 2;
                        count = 1;
                        for (x = startX; x >= endX; x -= 20) {
                            if (this.m != null) {
                                this.m.setBounds((int)currentInitialBound.getX() - count++ * 20, (int)this.m.getBounds().getY(), this.m.getMessageWidth(), this.m.getMessageHeight());
                            }
                            MessagePlugin.this.getProjection().getView().repaintDevice();
                            Thread.sleep(10L);
                        }
                        MessagePlugin.this.getProjection().getView().repaintDevice();
                    }
                }
            }
            catch (Exception e) {
                DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
                comp.remove(this.m);
                Thread.currentThread().interrupt();
            }
            DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
            comp.remove(this.m);
            MessagePlugin.this.sliding = false;
        }
    }

    class SlideRunner
    extends Thread {
        int fromIndex;
        int toIndex;

        public SlideRunner(int fromIndex, int toIndex) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public void run() {
            DevicePartComponent comp = MessagePlugin.this.getProjection().getView().getDevice2D();
            try {
                MessageSlideShow mssi;
                Message m;
                int i;
                if (this.toIndex > this.fromIndex) {
                    for (i = this.fromIndex; i <= this.toIndex; ++i) {
                        m = (Message)MessagePlugin.this.messages.get(i);
                        comp.add(m);
                        mssi = new MessageSlideShow(m, Slide.NextMessage);
                        mssi.start();
                        mssi.join();
                    }
                }
                if (this.toIndex < this.fromIndex) {
                    for (i = this.fromIndex; i >= this.toIndex; --i) {
                        m = (Message)MessagePlugin.this.messages.get(i);
                        comp.add(m);
                        mssi = new MessageSlideShow(m, Slide.PreviousMessage);
                        mssi.start();
                        mssi.join();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Slide {
        NextMessage,
        PreviousMessage;

    }
}

