/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.metrics.AbstractMetricsPlugin;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.format.IMetricsFormat;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.plugin.metrics.manager.FlowMetricsManager;
import org.jensoft.core.plugin.metrics.manager.FreeMetricsManager;
import org.jensoft.core.plugin.metrics.manager.ModeledMetricsManager;
import org.jensoft.core.plugin.metrics.manager.StaticMetricsManager;
import org.jensoft.core.plugin.metrics.manager.TimeMetricsManager;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class AxisMetricsPlugin<M extends AbstractMetricsManager>
extends AbstractMetricsPlugin<M> {
    private Axis axis;
    private int axisSpacing = 0;

    public AxisMetricsPlugin(M manager, Axis axis) {
        super(manager);
        this.axis = axis;
        this.setPriority(1000);
        this.setTextAntialising(TextAntialiasing.On);
        this.setAntialiasing(Antialiasing.On);
    }

    public void setMetricsFormat(IMetricsFormat format) {
        ((AbstractMetricsManager)this.getMetricsManager()).setMetricsFormat(format);
    }

    public IMetricsFormat getMetricsFormat() {
        return ((AbstractMetricsManager)this.getMetricsManager()).getMetricsFormat();
    }

    public int getAxisSpacing() {
        return this.axisSpacing;
    }

    public void setAxisSpacing(int axisSpacing) {
        this.axisSpacing = axisSpacing;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void setAxis(Axis axis) {
        this.axis = axis;
    }

    protected boolean isAccessible(ViewPart viewPart) {
        if (viewPart == ViewPart.View) {
            return true;
        }
        if (this.axis == Axis.AxisSouth && viewPart != ViewPart.South) {
            return false;
        }
        if (this.axis == Axis.AxisNorth && viewPart != ViewPart.North) {
            return false;
        }
        if (this.axis == Axis.AxisWest && viewPart != ViewPart.West) {
            return false;
        }
        if (this.axis == Axis.AxisEast && viewPart != ViewPart.East) {
            return false;
        }
        return viewPart != ViewPart.Device;
    }

    protected void paintBaseLine(View view, Graphics2D g2d, ViewPart viewPart) {
        if (this.isBaseLinePaint()) {
            JComponent component;
            Point2D.Double axisStartLocation = new Point2D.Double();
            Point2D.Double axisEndLocation = new Point2D.Double();
            if (viewPart == ViewPart.South) {
                component = view.getViewPartComponent(ViewPart.South);
                axisStartLocation = new Point2D.Double(view.getPlaceHolderAxisWest(), this.axisSpacing);
                axisEndLocation = new Point2D.Double(component.getWidth() - view.getPlaceHolderAxisEast(), this.axisSpacing);
            }
            if (viewPart == ViewPart.West) {
                component = view.getViewPartComponent(ViewPart.West);
                axisStartLocation = new Point2D.Double(component.getWidth() - 1 - this.axisSpacing, 0.0);
                axisEndLocation = new Point2D.Double(component.getWidth() - 1 - this.axisSpacing, component.getHeight());
            }
            if (viewPart == ViewPart.East) {
                component = view.getViewPartComponent(ViewPart.East);
                axisStartLocation = new Point2D.Double(this.axisSpacing, 0.0);
                axisEndLocation = new Point2D.Double(this.axisSpacing, component.getHeight());
            }
            if (viewPart == ViewPart.North) {
                component = view.getViewPartComponent(ViewPart.North);
                axisStartLocation = new Point2D.Double(view.getPlaceHolderAxisWest(), component.getHeight() - 1 - this.axisSpacing);
                axisEndLocation = new Point2D.Double(component.getWidth() - view.getPlaceHolderAxisEast(), component.getHeight() - 1 - this.axisSpacing);
            }
            Color axisBaseLineColor = this.getBaseLineColor() != null ? this.getBaseLineColor() : this.getProjection().getThemeColor();
            this.getMetricsPainter().doPaintLineMetrics(g2d, axisStartLocation, axisEndLocation, axisBaseLineColor);
        }
    }

    protected void paintMetricsLabelIndicator(View v2d, Graphics2D g2d, ViewPart viewPart) {
        List<Metrics> metrics = null;
        try {
            metrics = this.getMetricsManager().getDeviceMetrics();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        Collections.sort(metrics, Metrics.getComparator());
        for (int i = 0; i < metrics.size(); ++i) {
            JComponent component;
            Metrics m = metrics.get(i);
            Point2D.Double markerLocation = new Point2D.Double();
            if (viewPart == ViewPart.South) {
                markerLocation = new Point2D.Double((double)v2d.getPlaceHolderAxisWest() + m.getDeviceValue(), this.axisSpacing);
                m.setMarkerLocation(markerLocation);
                m.setMarkerPosition(Metrics.MarkerPosition.S);
            }
            if (viewPart == ViewPart.West) {
                component = v2d.getViewPartComponent(ViewPart.West);
                markerLocation = new Point2D.Double(component.getWidth() - 1 - this.axisSpacing, m.getDeviceValue());
                m.setMarkerLocation(markerLocation);
                m.setMarkerPosition(Metrics.MarkerPosition.W);
            }
            if (viewPart == ViewPart.East) {
                markerLocation = new Point2D.Double(this.axisSpacing, m.getDeviceValue());
                m.setMarkerLocation(markerLocation);
                m.setMarkerPosition(Metrics.MarkerPosition.E);
            }
            if (viewPart != ViewPart.North) continue;
            component = v2d.getViewPartComponent(ViewPart.North);
            markerLocation = new Point2D.Double((double)v2d.getPlaceHolderAxisWest() + m.getDeviceValue(), component.getHeight() - 1 - this.axisSpacing);
            m.setMarkerLocation(markerLocation);
            m.setMarkerPosition(Metrics.MarkerPosition.N);
        }
        this.getMetricsPainter().doPaintMetrics(g2d, metrics);
    }

    protected void assignType() {
        if (this.axis == Axis.AxisSouth || this.axis == Axis.AxisNorth) {
            ((AbstractMetricsManager)this.getMetricsManager()).setMetricsType(Metrics.MetricsType.XMetrics);
        }
        if (this.axis == Axis.AxisEast || this.axis == Axis.AxisWest) {
            ((AbstractMetricsManager)this.getMetricsManager()).setMetricsType(Metrics.MetricsType.YMetrics);
        }
    }

    protected void paintMetrics(View view, Graphics2D g2d, ViewPart viewPart) {
        if (!this.isAccessible(viewPart)) {
            return;
        }
        this.assignType();
        ((AbstractMetricsManager)this.getMetricsManager()).setMetricsPlugin(this);
        this.getMetricsPainter().setMetricsPlugin(this);
        this.paintMetricsLabelIndicator(view, g2d, viewPart);
        this.paintBaseLine(view, g2d, viewPart);
    }

    @Override
    public final void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        this.paintMetrics(view, g2d, viewPart);
    }

    public static enum Axis {
        AxisSouth("AxisSouth"),
        AxisNorth("AxisNorth"),
        AxisWest("AxisWest"),
        AxisEast("AxisEast");

        private String name;

        private Axis(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Axis parse(String axisName) {
            if (axisName == null) {
                return null;
            }
            if (axisName.equalsIgnoreCase(AxisSouth.getName())) {
                return AxisSouth;
            }
            if (axisName.equalsIgnoreCase(AxisNorth.getName())) {
                return AxisNorth;
            }
            if (axisName.equalsIgnoreCase(AxisWest.getName())) {
                return AxisWest;
            }
            if (axisName.equalsIgnoreCase(AxisEast.getName())) {
                return AxisEast;
            }
            return null;
        }
    }

    public static class ModeledMetrics
    extends AxisMetricsPlugin<ModeledMetricsManager> {
        public ModeledMetrics(Axis axis) {
            super(new ModeledMetricsManager(), axis);
            this.setName(ModeledMetrics.class.getCanonicalName());
        }

        public void setMetricsIntervalDensity(int intervalDensity) {
            ((ModeledMetricsManager)this.getMetricsManager()).setIntervalDensity(intervalDensity);
        }

        public void setMedianMetricsOption(boolean medianOption) {
            ((ModeledMetricsManager)this.getMetricsManager()).setMedianMetricsOption(medianOption);
        }

        public void setMinorMetricsOption(boolean minorOption) {
            ((ModeledMetricsManager)this.getMetricsManager()).setMinorMetricsOption(minorOption);
        }

        public void setMedianMetricsDensityThreshold(double medianMetricsDensityThreshold) {
            ((ModeledMetricsManager)this.getMetricsManager()).setMedianMetricsDensityThreshold(medianMetricsDensityThreshold);
        }

        public void setMinorMetricsDensityThreshold(double minorMetricsDensityThreshold) {
            ((ModeledMetricsManager)this.getMetricsManager()).setMinorMetricsDensityThreshold(minorMetricsDensityThreshold);
        }

        public List<ModeledMetricsManager.MetricsModel> getMetricsModels() {
            return ((ModeledMetricsManager)this.getMetricsManager()).getMetricsModels();
        }

        public static class S
        extends ModeledMetrics {
            public S() {
                super(Axis.AxisSouth);
            }
        }

        public static class N
        extends ModeledMetrics {
            public N() {
                super(Axis.AxisNorth);
            }
        }

        public static class E
        extends ModeledMetrics {
            public E() {
                super(Axis.AxisEast);
            }
        }

        public static class W
        extends ModeledMetrics {
            public W() {
                super(Axis.AxisWest);
            }
        }
    }

    public static class TimeMetrics
    extends AxisMetricsPlugin<TimeMetricsManager> {
        public TimeMetrics(Axis axis) {
            super(new TimeMetricsManager(), axis);
            this.setName(TimeMetrics.class.getCanonicalName());
        }

        public void registerTimeModel(TimeMetricsManager.TimeModel model) {
            ((TimeMetricsManager)this.getMetricsManager()).registerTimingModel(model);
        }

        public void registerTimeModels(TimeMetricsManager.TimeModel ... models) {
            ((TimeMetricsManager)this.getMetricsManager()).registerTimingModels(models);
        }

        public void registerTimeModels(List<TimeMetricsManager.TimeModel> models) {
            ((TimeMetricsManager)this.getMetricsManager()).registerTimingModels(models);
        }

        public void unregisterTimeModel(TimeMetricsManager.TimeModel model) {
            ((TimeMetricsManager)this.getMetricsManager()).unregisterTimingModel(model);
        }

        public void unregisterTimeModels(TimeMetricsManager.TimeModel ... models) {
            ((TimeMetricsManager)this.getMetricsManager()).unregisterTimingModels(models);
        }

        public void unregisterTimeModels(List<TimeMetricsManager.TimeModel> models) {
            ((TimeMetricsManager)this.getMetricsManager()).unregisterTimingModels(models);
        }

        public List<TimeMetricsManager.TimeModel> getTimingModels() {
            return ((TimeMetricsManager)this.getMetricsManager()).getTimingModels();
        }

        @Override
        public void paintMetrics(View view, Graphics2D g2d, ViewPart viewPart) {
            if (!super.isAccessible(viewPart)) {
                return;
            }
            super.assignType();
            ((TimeMetricsManager)this.getMetricsManager()).setMetricsPlugin(this);
            this.getMetricsPainter().setMetricsPlugin(this);
            int axisSpacing = 0;
            List<TimeMetricsManager.TimeModel> sequence = ((TimeMetricsManager)this.getMetricsManager()).getTimingSequence();
            for (TimeMetricsManager.TimeModel timingManager : sequence) {
                List<Metrics> metrics = timingManager.generateMetrics();
                Collections.sort(metrics, Metrics.getComparator());
                for (int i = 0; i < metrics.size(); ++i) {
                    JComponent component;
                    Metrics m = metrics.get(i);
                    m.setLockMarker(true);
                    if (axisSpacing > 0) {
                        m.setLockMarker(false);
                    }
                    if (m instanceof TimeMetricsManager.TimeDurationMetrics) {
                        m.setLockMarker(false);
                    }
                    Point2D.Double markerLocation = new Point2D.Double();
                    if (viewPart == ViewPart.South) {
                        markerLocation = new Point2D.Double((double)view.getPlaceHolderAxisWest() + m.getDeviceValue(), axisSpacing);
                        m.setMarkerLocation(markerLocation);
                        m.setMarkerPosition(Metrics.MarkerPosition.S);
                    }
                    if (viewPart == ViewPart.West) {
                        component = view.getViewPartComponent(ViewPart.West);
                        markerLocation = new Point2D.Double(component.getWidth() - 1 - axisSpacing, m.getDeviceValue());
                        m.setMarkerLocation(markerLocation);
                        m.setMarkerPosition(Metrics.MarkerPosition.W);
                    }
                    if (viewPart == ViewPart.East) {
                        markerLocation = new Point2D.Double(axisSpacing, m.getDeviceValue());
                        m.setMarkerLocation(markerLocation);
                        m.setMarkerPosition(Metrics.MarkerPosition.E);
                    }
                    if (viewPart != ViewPart.North) continue;
                    component = view.getViewPartComponent(ViewPart.North);
                    markerLocation = new Point2D.Double((double)view.getPlaceHolderAxisWest() + m.getDeviceValue(), component.getHeight() - 1 - axisSpacing);
                    m.setMarkerLocation(markerLocation);
                    m.setMarkerPosition(Metrics.MarkerPosition.N);
                }
                this.getMetricsPainter().doPaintMetrics(g2d, metrics);
                axisSpacing += timingManager.getPixelAxisHolder();
            }
        }

        public static class S
        extends TimeMetrics {
            public S() {
                super(Axis.AxisSouth);
            }
        }

        public static class N
        extends TimeMetrics {
            public N() {
                super(Axis.AxisNorth);
            }
        }

        public static class E
        extends TimeMetrics {
            public E() {
                super(Axis.AxisEast);
            }
        }

        public static class W
        extends TimeMetrics {
            public W() {
                super(Axis.AxisWest);
            }
        }
    }

    public static class FlowMetrics
    extends AxisMetricsPlugin<FlowMetricsManager> {
        public FlowMetrics(double flowStart, double flowEnd, double flowInterval, Axis axis) {
            super(new FlowMetricsManager(flowStart, flowEnd, flowInterval), axis);
        }

        public void setFlowStart(double flowStart) {
            ((FlowMetricsManager)this.getMetricsManager()).setFlowStart(flowStart);
        }

        public void setFlowEnd(double flowEnd) {
            ((FlowMetricsManager)this.getMetricsManager()).setFlowEnd(flowEnd);
        }

        public void setFlowInterval(double flowInterval) {
            ((FlowMetricsManager)this.getMetricsManager()).setFlowInterval(flowInterval);
        }

        public double getFlowStart() {
            return ((FlowMetricsManager)this.getMetricsManager()).getFlowStart();
        }

        public double getFlowEnd() {
            return ((FlowMetricsManager)this.getMetricsManager()).getFlowEnd();
        }

        public double getFlowInterval() {
            return ((FlowMetricsManager)this.getMetricsManager()).getFlowInterval();
        }

        public static class S
        extends FlowMetrics {
            public S(double flowStart, double flowEnd, double flowInterval) {
                super(flowStart, flowEnd, flowInterval, Axis.AxisSouth);
            }
        }

        public static class N
        extends FlowMetrics {
            public N(double flowStart, double flowEnd, double flowInterval) {
                super(flowStart, flowEnd, flowInterval, Axis.AxisNorth);
            }
        }

        public static class E
        extends FlowMetrics {
            public E(double flowStart, double flowEnd, double flowInterval) {
                super(flowStart, flowEnd, flowInterval, Axis.AxisEast);
            }
        }

        public static class W
        extends FlowMetrics {
            public W(double flowStart, double flowEnd, double flowInterval) {
                super(flowStart, flowEnd, flowInterval, Axis.AxisWest);
            }
        }
    }

    public static class FreeMetrics
    extends AxisMetricsPlugin<FreeMetricsManager> {
        public FreeMetrics(Axis axis) {
            super(new FreeMetricsManager(), axis);
        }

        public void addMetrics(double m) {
            ((FreeMetricsManager)this.getMetricsManager()).addMetrics(m);
        }

        public void addMetrics(double m, String label) {
            ((FreeMetricsManager)this.getMetricsManager()).addMetrics(m, label);
        }

        public static class S
        extends FreeMetrics {
            public S() {
                super(Axis.AxisSouth);
            }
        }

        public static class N
        extends FreeMetrics {
            public N() {
                super(Axis.AxisNorth);
            }
        }

        public static class E
        extends FreeMetrics {
            public E() {
                super(Axis.AxisEast);
            }
        }

        public static class W
        extends FreeMetrics {
            public W() {
                super(Axis.AxisWest);
            }
        }
    }

    public static class StaticMetrics
    extends AxisMetricsPlugin<StaticMetricsManager> {
        public StaticMetrics(int metricsCount, Axis axis) {
            super(new StaticMetricsManager(metricsCount), axis);
        }

        public static class S
        extends StaticMetrics {
            public S(int metricsCount) {
                super(metricsCount, Axis.AxisSouth);
            }
        }

        public static class N
        extends StaticMetrics {
            public N(int metricsCount) {
                super(metricsCount, Axis.AxisNorth);
            }
        }

        public static class E
        extends StaticMetrics {
            public E(int metricsCount) {
                super(metricsCount, Axis.AxisEast);
            }
        }

        public static class W
        extends StaticMetrics {
            public W(int metricsCount) {
                super(metricsCount, Axis.AxisWest);
            }
        }
    }
}

