/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.manager.AbstractMetricsManager;
import org.jensoft.core.projection.Projection;

public class StaticMetricsManager
extends AbstractMetricsManager {
    private List<Metrics> metricsDevice = new ArrayList<Metrics>();
    private int metricsCount;

    public StaticMetricsManager(int metricsCount) {
        this.metricsCount = metricsCount;
    }

    @Override
    public List<Metrics> getDeviceMetrics() {
        block7: {
            Projection w2d;
            block6: {
                this.metricsDevice.clear();
                w2d = this.getMetricsPlugin().getProjection();
                if (this.getType() != Metrics.MetricsType.XMetrics) break block6;
                double userWidth = w2d.getUserWidth();
                for (int i = 0; i < this.metricsCount; ++i) {
                    double userMetricsX = w2d.getMinX() + (double)i * userWidth / new Double(this.metricsCount - 1);
                    Point2D.Double p2dUserMetrics = new Point2D.Double(userMetricsX, 0.0);
                    Point2D p2dDeviceMetrics = w2d.userToPixel(p2dUserMetrics);
                    Metrics metrics = new Metrics(Metrics.MetricsType.XMetrics);
                    metrics.setDeviceValue(p2dDeviceMetrics.getX());
                    metrics.setUserValue(userMetricsX);
                    if (this.getMetricsFormat() == null) {
                        metrics.setMetricsLabel(this.getDefaultFormat().format(userMetricsX));
                    } else {
                        metrics.setMetricsLabel(this.getMetricsFormat().format(userMetricsX));
                    }
                    this.metricsDevice.add(metrics);
                }
                break block7;
            }
            if (this.getType() != Metrics.MetricsType.YMetrics) break block7;
            double userHeight = w2d.getUserHeight();
            for (int i = 0; i < this.metricsCount; ++i) {
                double userMetricsY = w2d.getMinY() + (double)i * userHeight / new Double(this.metricsCount - 1);
                Point2D.Double p2dUserMetrics = new Point2D.Double(0.0, userMetricsY);
                Point2D p2dDeviceMetrics = w2d.userToPixel(p2dUserMetrics);
                Metrics metrics = new Metrics(Metrics.MetricsType.YMetrics);
                metrics.setDeviceValue(p2dDeviceMetrics.getY());
                metrics.setUserValue(userMetricsY);
                if (this.getMetricsFormat() == null) {
                    metrics.setMetricsLabel(this.getDefaultFormat().format(userMetricsY));
                } else {
                    metrics.setMetricsLabel(this.getMetricsFormat().format(userMetricsY));
                }
                this.metricsDevice.add(metrics);
            }
        }
        return this.metricsDevice;
    }
}

