/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.metrics.painter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GlyphUtil;
import org.jensoft.core.plugin.metrics.Metrics;
import org.jensoft.core.plugin.metrics.painter.AbstractMetricsPainter;
import org.jensoft.core.view.ViewPart;

public class MetricsGlyphPainter
extends AbstractMetricsPainter {
    @Override
    public void doPaintLineMetrics(Graphics2D g2d, Point2D start, Point2D end, Color axisBaseColor) {
        g2d.setColor(axisBaseColor);
        Line2D.Double lineMetrics = new Line2D.Double(start, end);
        g2d.draw(lineMetrics);
    }

    protected void paintMetricsMarker(Graphics2D g2d, Metrics metric) {
        g2d.setFont(this.getMetricsPlugin().getMetricsTextFont(metric));
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        if (metric.getMetricsMarkerColor() != null) {
            g2d.setColor(metric.getMetricsMarkerColor());
        } else if (this.getMetricsPlugin().getMetricsMarkerColor(metric) != null) {
            g2d.setColor(this.getMetricsPlugin().getMetricsMarkerColor(metric));
        } else {
            g2d.setColor(this.getMetricsPlugin().getProjection().getThemeColor());
        }
        if (metric.getMetricsMarkerStroke() != null) {
            g2d.setColor(metric.getMetricsMarkerColor());
        } else if (this.getMetricsPlugin().getMetricsMarkerStroke(metric) != null) {
            g2d.setStroke(this.getMetricsPlugin().getMetricsMarkerStroke(metric));
        } else {
            g2d.setStroke(new BasicStroke());
        }
        Line2D.Double metricsShapeIndicator = null;
        Point2D position = metric.getMarkerLocation();
        if (metric.getMetricsType() == Metrics.MetricsType.XMetrics) {
            if (metric.getMarkerPosition() == Metrics.MarkerPosition.S) {
                metricsShapeIndicator = new Line2D.Double(position.getX(), position.getY() + 2.0, position.getX(), position.getY() + (double)markerSize + 2.0);
            }
            if (metric.getMarkerPosition() == Metrics.MarkerPosition.N) {
                metricsShapeIndicator = new Line2D.Double(position.getX(), position.getY() - 2.0, position.getX(), position.getY() - (double)markerSize - 2.0);
            }
        }
        if (metric.getMetricsType() == Metrics.MetricsType.YMetrics) {
            if (metric.getMarkerPosition() == Metrics.MarkerPosition.W) {
                metricsShapeIndicator = new Line2D.Double(position.getX() - (double)markerSize - 2.0, position.getY(), position.getX() - 2.0, position.getY());
            }
            if (metric.getMarkerPosition() == Metrics.MarkerPosition.E) {
                metricsShapeIndicator = new Line2D.Double(position.getX() + 2.0, position.getY(), position.getX() + (double)markerSize + 2.0, position.getY());
            }
        }
        if (metricsShapeIndicator != null && metric.isLockMarker()) {
            g2d.draw(metricsShapeIndicator);
        }
    }

    protected void paintNorthMetricsLabel(Graphics2D g2d, Metrics metric) {
        Point2D position = metric.getMarkerLocation();
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        int tickLabelWidth = g2d.getFontMetrics(f).stringWidth(metric.getMetricsLabel());
        g2d.drawString(metric.getMetricsLabel(), (int)(position.getX() - (double)(tickLabelWidth / 2)), (int)(position.getY() - (double)markerSize - 4.0));
    }

    protected void paintSouthMetricsLabel2(Graphics2D g2d, Metrics metric) {
        Point2D position = metric.getMarkerLocation();
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        int tickLabelWidth = g2d.getFontMetrics(f).stringWidth(metric.getMetricsLabel());
        AffineTransform af = new AffineTransform();
        af.rotate(-0.7853981633974483, position.getX(), position.getY() + (double)markerSize + 10.0);
        g2d.setTransform(af);
        g2d.drawString(metric.getMetricsLabel(), (int)(position.getX() - (double)(tickLabelWidth / 2)), (int)(position.getY() + (double)markerSize + (double)g2d.getFontMetrics(f).getHeight() + 2.0));
        g2d.setTransform(new AffineTransform());
    }

    protected void paintSouthMetricsLabel(Graphics2D g2d, Metrics metric) {
        Point2D position = metric.getMarkerLocation();
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector legendGlyphVector = f.createGlyphVector(frc, metric.getMetricsLabel());
        float legendWidth = GlyphUtil.getGlyphWidth(legendGlyphVector);
        AffineTransform af = new AffineTransform();
        for (int g = 0; g < legendGlyphVector.getNumGlyphs(); ++g) {
            Shape ts;
            Point2D p = legendGlyphVector.getGlyphPosition(g);
            float px = (float)p.getX();
            float py = (float)p.getY();
            Point2D.Double pointGlyph = null;
            Shape glyph = legendGlyphVector.getGlyphOutline(g);
            if (this.getMetricsPlugin().getGravity() == Metrics.Gravity.Rotate) {
                pointGlyph = new Point2D.Double(position.getX() + (double)(g2d.getFontMetrics().getAscent() / 2), position.getY() + (double)markerSize + (double)this.getMetricsPlugin().getMetricsTextOffset(metric) + (double)legendWidth - (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g));
                af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
                af.rotate(-1.5707963267948966);
                af.translate(-px, -py);
                ts = af.createTransformedShape(glyph);
                g2d.fill(ts);
                continue;
            }
            pointGlyph = new Point2D.Double(position.getX() - (double)(legendWidth / 2.0f) + (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g), position.getY() + (double)markerSize + (double)this.getMetricsPlugin().getMetricsTextOffset(metric) + (double)g2d.getFontMetrics().getHeight());
            af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
            af.translate(-px, -py);
            ts = af.createTransformedShape(glyph);
            g2d.fill(ts);
        }
    }

    protected void paintWestMetricsLabel(Graphics2D g2d, Metrics metric) {
        Point2D position = metric.getMarkerLocation();
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector legendGlyphVector = f.createGlyphVector(frc, metric.getMetricsLabel());
        float legendWidth = GlyphUtil.getGlyphWidth(legendGlyphVector);
        AffineTransform af = new AffineTransform();
        for (int g = 0; g < legendGlyphVector.getNumGlyphs(); ++g) {
            Point2D p = legendGlyphVector.getGlyphPosition(g);
            float px = (float)p.getX();
            float py = (float)p.getY();
            Point2D.Double pointGlyph = null;
            Shape glyph = legendGlyphVector.getGlyphOutline(g);
            boolean paintFlag = false;
            if (this.getMetricsPlugin().getGravity() == Metrics.Gravity.Rotate) {
                pointGlyph = new Point2D.Double(position.getX() - (double)markerSize - (double)this.getMetricsPlugin().getMetricsTextOffset(metric) - (double)(g2d.getFontMetrics(f).getHeight() / 2), position.getY() + (double)(legendWidth / 2.0f) - (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g));
                af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
                af.rotate(-1.5707963267948966);
                af.translate(-px, -py);
                int tickLabelWidth = g2d.getFontMetrics(f).stringWidth(metric.getMetricsLabel());
                int height = this.getMetricsPlugin().getProjection().getDevice2D().getDeviceHeight();
                if (position.getY() < (double)(height - tickLabelWidth / 2) && position.getY() > (double)(tickLabelWidth / 2)) {
                    paintFlag = true;
                }
                if (!paintFlag) continue;
                Shape ts = af.createTransformedShape(glyph);
                g2d.fill(ts);
                continue;
            }
            pointGlyph = new Point2D.Double(position.getX() - (double)legendWidth - (double)markerSize - (double)this.getMetricsPlugin().getMetricsTextOffset(metric) + (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g), position.getY() + (double)(g2d.getFontMetrics().getAscent() / 2));
            af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
            af.translate(-px, -py);
            int westPartHeight = this.getMetricsPlugin().getProjection().getView().getViewPartComponent(ViewPart.West).getHeight();
            if (position.getY() > (double)(g2d.getFontMetrics().getAscent() / 2) && position.getY() < (double)(westPartHeight - g2d.getFontMetrics().getAscent() / 2)) {
                paintFlag = true;
            }
            if (!paintFlag) continue;
            Shape ts = af.createTransformedShape(glyph);
            g2d.fill(ts);
        }
    }

    protected void paintEastMetricsLabel(Graphics2D g2d, Metrics metric) {
        Point2D position = metric.getMarkerLocation();
        int markerSize = this.getMetricsPlugin().getMetricsMarkerSize(metric);
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector legendGlyphVector = f.createGlyphVector(frc, metric.getMetricsLabel());
        float legendWidth = GlyphUtil.getGlyphWidth(legendGlyphVector);
        AffineTransform af = new AffineTransform();
        for (int g = 0; g < legendGlyphVector.getNumGlyphs(); ++g) {
            Point2D p = legendGlyphVector.getGlyphPosition(g);
            float px = (float)p.getX();
            float py = (float)p.getY();
            Point2D.Double pointGlyph = null;
            Shape glyph = legendGlyphVector.getGlyphOutline(g);
            boolean paintFlag = false;
            if (this.getMetricsPlugin().getGravity() == Metrics.Gravity.Rotate) {
                pointGlyph = new Point2D.Double(position.getX() + (double)markerSize + (double)g2d.getFontMetrics(f).getHeight(), position.getY() + (double)(legendWidth / 2.0f) - (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g));
                af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
                af.rotate(-1.5707963267948966);
                af.translate(-px, -py);
                int tickLabelWidth = g2d.getFontMetrics(f).stringWidth(metric.getMetricsLabel());
                int height = this.getMetricsPlugin().getProjection().getDevice2D().getDeviceHeight();
                if (position.getY() < (double)(height - tickLabelWidth / 2) && position.getY() > (double)(tickLabelWidth / 2)) {
                    paintFlag = true;
                }
                if (!paintFlag) continue;
                Shape ts = af.createTransformedShape(glyph);
                g2d.fill(ts);
                continue;
            }
            pointGlyph = new Point2D.Double(position.getX() + (double)markerSize + 10.0 + (double)GlyphUtil.getGlyphWidthAtToken(legendGlyphVector, g), position.getY() + (double)(g2d.getFontMetrics().getAscent() / 2));
            af.setToTranslation(((Point2D)pointGlyph).getX(), ((Point2D)pointGlyph).getY());
            af.translate(-px, -py);
            int westPartHeight = this.getMetricsPlugin().getProjection().getView().getViewPartComponent(ViewPart.West).getHeight();
            if (position.getY() > (double)(g2d.getFontMetrics().getAscent() / 2) && position.getY() < (double)(westPartHeight - g2d.getFontMetrics().getAscent() / 2)) {
                paintFlag = true;
            }
            if (!paintFlag) continue;
            Shape ts = af.createTransformedShape(glyph);
            g2d.fill(ts);
        }
    }

    protected void paintMetricsText(Graphics2D g2d, Metrics metric) {
        Font f = this.getMetricsPlugin().getMetricsTextFont(metric);
        g2d.setFont(f);
        if ((metric.getNature() == Metrics.MetricsNature.Major || metric.getNature() == Metrics.MetricsNature.Median) && metric.isLockLabel()) {
            if (metric.getMetricsLabelColor() != null) {
                g2d.setColor(metric.getMetricsLabelColor());
            } else if (this.getMetricsPlugin().getMetricsTextColor(metric) != null) {
                g2d.setColor(this.getMetricsPlugin().getMetricsTextColor(metric));
            } else {
                g2d.setColor(this.getMetricsPlugin().getProjection().getThemeColor());
            }
            if (metric.getMetricsLabel() != null) {
                if (metric.getMetricsType() == Metrics.MetricsType.XMetrics) {
                    if (metric.getMarkerPosition() == Metrics.MarkerPosition.S) {
                        this.paintSouthMetricsLabel(g2d, metric);
                    }
                    if (metric.getMarkerPosition() == Metrics.MarkerPosition.N) {
                        this.paintNorthMetricsLabel(g2d, metric);
                    }
                }
                if (metric.getMetricsType() == Metrics.MetricsType.YMetrics) {
                    if (metric.getMarkerPosition() == Metrics.MarkerPosition.W) {
                        this.paintWestMetricsLabel(g2d, metric);
                    }
                    if (metric.getMarkerPosition() == Metrics.MarkerPosition.E) {
                        this.paintEastMetricsLabel(g2d, metric);
                    }
                }
            }
        }
    }

    @Override
    public void doPaintMetrics(Graphics2D g2d, List<Metrics> metrics) {
        g2d.setStroke(new BasicStroke());
        for (int i = 0; i < metrics.size(); ++i) {
            Metrics metric = metrics.get(i);
            if (!metric.isVisible()) continue;
            this.paintMetricsMarker(g2d, metric);
            this.paintMetricsText(g2d, metric);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }
}

