/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.minidevice;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.device.Device;
import org.jensoft.core.device.DeviceMenuManager;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.minidevice.MiniDeviceWidget;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class MiniDevicePlugin
extends AbstractPlugin
implements Device {
    private Color miniCurrentDeviceDrawColor;
    private Color miniInitialDeviceDrawColor;
    int miniDeviceRatioX = 5;
    int miniDeviceRatioY = 5;
    int miniDevicePixelX = 120;
    int miniDevicePixelY = 80;
    private DimensionType dimentionType = DimensionType.Ratio;
    private Projection.Linear miniDeviceProjection;
    private MiniDeviceWidget miniDeviceWidget;

    public MiniDevicePlugin() {
        this.setName("MiniDeviceLayout");
        this.createControls();
    }

    public void setDimensionType(DimensionType dimType, int x, int y) {
        this.dimentionType = dimType;
        if (dimType == DimensionType.Ratio) {
            this.miniDeviceRatioX = x;
            this.miniDeviceRatioY = y;
        } else if (dimType == DimensionType.Fix) {
            this.miniDevicePixelX = x;
            this.miniDevicePixelY = y;
        }
    }

    @Override
    public DeviceMenuManager getDeviceMenuManager() {
        return null;
    }

    public DimensionType getDimentionType() {
        return this.dimentionType;
    }

    public int getMiniDeviceRatioX() {
        return this.miniDeviceRatioX;
    }

    public void setMiniDeviceRatioX(int miniDeviceRatioX) {
        this.miniDeviceRatioX = miniDeviceRatioX;
    }

    public int getMiniDeviceRatioY() {
        return this.miniDeviceRatioY;
    }

    public void setMiniDeviceRatioY(int miniDeviceRatioY) {
        this.miniDeviceRatioY = miniDeviceRatioY;
    }

    public int getMiniDevicePixelX() {
        return this.miniDevicePixelX;
    }

    public void setMiniDevicePixelX(int miniDevicePixelX) {
        this.miniDevicePixelX = miniDevicePixelX;
    }

    public int getMiniDevicePixelY() {
        return this.miniDevicePixelY;
    }

    public void setMiniDevicePixelY(int miniDevicePixelY) {
        this.miniDevicePixelY = miniDevicePixelY;
    }

    public void createControls() {
    }

    public Color getMiniInitialDeviceDrawColor() {
        return this.miniInitialDeviceDrawColor;
    }

    public void setMiniInitialDeviceDrawColor(Color miniInitialDeviceDrawColor) {
        this.miniInitialDeviceDrawColor = miniInitialDeviceDrawColor;
    }

    public Color getMiniCurrentDeviceDrawColor() {
        return this.miniCurrentDeviceDrawColor;
    }

    public void setMiniCurrentDeviceDrawColor(Color miniDeviceDrawColor) {
        this.miniCurrentDeviceDrawColor = miniDeviceDrawColor;
    }

    @Override
    public int getDeviceHeight() {
        return (int)this.miniDeviceWidget.getWidgetFolder().getHeight();
    }

    @Override
    public int getDeviceWidth() {
        return (int)this.miniDeviceWidget.getWidgetFolder().getWidth();
    }

    @Override
    public int getOriginX() {
        return (int)this.miniDeviceWidget.getWidgetFolder().getX();
    }

    @Override
    public int getOriginY() {
        return (int)this.miniDeviceWidget.getWidgetFolder().getY();
    }

    public Projection getPrivateProjection() {
        if (this.miniDeviceProjection == null) {
            this.miniDeviceProjection = new Projection.Linear();
        }
        this.miniDeviceProjection.setDevice2D(this);
        if (this.getProjection() instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)this.getProjection();
            double iminX = wl.getInitialMinX();
            double imaxX = wl.getInitialMaxX();
            double iminY = wl.getInitialMinY();
            double imaxY = wl.getInitialMaxY();
            this.miniDeviceProjection.bound(iminX, imaxX, iminY, imaxY);
            double minX = this.getProjection().getMinX();
            double maxX = this.getProjection().getMaxX();
            double minY = this.getProjection().getMinY();
            double maxY = this.getProjection().getMaxY();
            this.miniDeviceProjection.bound(minX, maxX, minY, maxY);
        }
        return this.miniDeviceProjection;
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
    }

    @Override
    public void repaintDevice(int x, int y, int w, int h) {
    }

    @Override
    public void repaintDevice() {
    }

    public static enum DimensionType {
        Ratio,
        Fix;

    }
}

