/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.morphe;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.morphe.Primitive;
import org.jensoft.core.projection.Projection;

public class Line
extends Primitive {
    private double startX;
    private double startY;
    private double endX;
    private double endY;

    public Line(double startX, double startY, double endX, double endY) {
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.getNature() == Primitive.PrimitiveNature.DEVICE) {
            Line2D.Double line2DDevice = new Line2D.Double(this.startX, this.endX, this.startY, this.endY);
            g2d.setColor(this.getHost().getThemeColor());
            g2d.draw(line2DDevice);
        } else if (this.getNature() == Primitive.PrimitiveNature.USER) {
            Projection w2d = this.getHost().getProjection();
            Point2D start = w2d.userToPixel(new Point2D.Double(this.startX, this.startY));
            Point2D end = w2d.userToPixel(new Point2D.Double(this.endX, this.endY));
            Line2D.Double line2DUser = new Line2D.Double(start.getX(), start.getY(), end.getX(), end.getY());
            g2d.setColor(this.getHost().getThemeColor());
            g2d.draw(line2DUser);
        }
    }
}

