/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie;

import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.plugin.pie.PieListener;
import org.jensoft.core.plugin.pie.PiePlugin;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;
import org.jensoft.core.plugin.pie.painter.draw.AbstractPieDraw;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieFill;

public class Pie {
    private String name;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double radius = 0.0;
    private double startAngleDegree = 0.0;
    private AbstractPieDraw pieDraw;
    private AbstractPieFill pieFill;
    private AbstractPieEffect pieEffect;
    private PiePlugin hostPlugin;
    private List<PieSlice> slices;
    private PieNature pieNature = PieNature.User;
    private double passiveLabelAtMinPercent = 0.0;
    private EventListenerList pieListenerList;

    public Pie() {
        this.slices = new ArrayList<PieSlice>();
        this.pieListenerList = new EventListenerList();
    }

    public Pie(String name) {
        this();
        this.name = name;
    }

    public Pie(String name, double radius) {
        this(name);
        this.radius = radius;
    }

    public Pie(String name, double centerX, double centerY, double radius) {
        this(name);
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
    }

    public Pie(String name, PieNature pieNature, int centerX, int centerY, double radius) {
        this(name, centerX, centerY, radius);
        this.pieNature = pieNature;
    }

    public void addPieAnimator(AbstractPieAnimator animator) {
        animator.setPie(this);
        this.addPieListener(animator);
    }

    public void addPieListener(PieListener listener) {
        this.pieListenerList.add(PieListener.class, listener);
    }

    public EventListenerList getPieListenerList() {
        return this.pieListenerList;
    }

    public void removePieListener(PieListener listener) {
        this.pieListenerList.remove(PieListener.class, listener);
    }

    public PiePlugin getHostPlugin() {
        return this.hostPlugin;
    }

    public void setHostPlugin(PiePlugin host) {
        this.hostPlugin = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public double getStartAngleDegree() {
        return this.startAngleDegree;
    }

    public void setStartAngleDegree(double startAngleDegree) {
        this.startAngleDegree = startAngleDegree;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public AbstractPieDraw getPieDraw() {
        return this.pieDraw;
    }

    public void setPieDraw(AbstractPieDraw pieDraw) {
        this.pieDraw = pieDraw;
    }

    public AbstractPieFill getPieFill() {
        return this.pieFill;
    }

    public void setPieFill(AbstractPieFill pieFill) {
        this.pieFill = pieFill;
    }

    public AbstractPieEffect getPieEffect() {
        return this.pieEffect;
    }

    public void setPieEffect(AbstractPieEffect pieEffect) {
        this.pieEffect = pieEffect;
    }

    public List<PieSlice> getSlices() {
        return this.slices;
    }

    public void setSlices(List<PieSlice> slices) {
        this.slices = slices;
    }

    public void addSlice(PieSlice slice) {
        slice.setHost(this);
        this.slices.add(slice);
    }

    public void addSlices(PieSlice ... slices) {
        for (int i = 0; i < slices.length; ++i) {
            this.addSlice(slices[i]);
        }
    }

    public PieNature getPieNature() {
        return this.pieNature;
    }

    public void setPieNature(PieNature pieNature) {
        this.pieNature = pieNature;
    }

    private void makeSum() {
        PieSlice s;
        int i;
        double sum = 0.0;
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            sum += s.getValue();
        }
        for (i = 0; i < this.slices.size(); ++i) {
            s = this.slices.get(i);
            double percent = s.getValue() / sum;
            s.setPercent(percent);
        }
    }

    public Area getPieArea() {
        Area pieArea = new Area();
        for (PieSlice slice : this.getSlices()) {
            pieArea.add(new Area(slice.getSlicePath()));
        }
        return pieArea;
    }

    public double getPassiveLabelAtMinPercent() {
        return this.passiveLabelAtMinPercent;
    }

    public void setPassiveLabelAtMinPercent(double passiveLabelAtMinPercent) {
        this.passiveLabelAtMinPercent = passiveLabelAtMinPercent;
    }

    public void removeAllSliceLabels() {
        for (PieSlice slice : this.getSlices()) {
            slice.removeAllSliceLabels();
        }
    }

    public boolean isDivergent() {
        for (int i = 0; i < this.slices.size(); ++i) {
            PieSlice s = this.slices.get(i);
            if (s.getDivergence() == 0) continue;
            return true;
        }
        return false;
    }

    public void build() {
        this.makeSum();
        for (PieSlice slice : this.slices) {
            this.buildSlice(slice);
        }
    }

    private void buildSlice(PieSlice slice) {
        double medianDegree;
        double deltaDegree = slice.getPercent() * 360.0;
        if (this.startAngleDegree > 360.0) {
            int intPart = (int)this.startAngleDegree / 360;
            this.startAngleDegree -= (double)(intPart * 360);
        }
        if ((medianDegree = this.startAngleDegree + deltaDegree / 2.0) > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (this.pieNature == PieNature.User) {
            c = this.getHostPlugin().getProjection().userToPixel(new Point2D.Double(this.centerX, this.centerY));
        }
        if (this.pieNature == PieNature.Device) {
            c = new Point2D.Double(this.centerX, this.centerY);
        }
        double sliceCenterX = c.getX() + (double)slice.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        double sliceCenterY = c.getY() - (double)slice.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        double cornerExternalX = sliceCenterX - this.radius;
        double cornerExternalY = sliceCenterY - this.radius;
        Arc2D.Double piePath = new Arc2D.Double(cornerExternalX, cornerExternalY, 2.0 * this.radius, 2.0 * this.radius, this.startAngleDegree, deltaDegree, 2);
        slice.setSlicePath(new GeneralPath(piePath));
        Arc2D.Double externalPath = new Arc2D.Double(cornerExternalX, cornerExternalY, 2.0 * this.radius, 2.0 * this.radius, this.startAngleDegree, deltaDegree, 0);
        slice.setExternalArc(externalPath);
        Line2D.Double lineStart = new Line2D.Double(new Point2D.Double(sliceCenterX, sliceCenterY), externalPath.getStartPoint());
        Line2D.Double lineEnd = new Line2D.Double(externalPath.getEndPoint(), new Point2D.Double(sliceCenterX, sliceCenterY));
        slice.setLineStart(lineStart);
        slice.setLineEnd(lineEnd);
        slice.setStartAngleDegree(this.startAngleDegree);
        slice.setEndAngleDegree(this.startAngleDegree + deltaDegree);
        this.startAngleDegree += deltaDegree;
    }

    public static enum PieNature {
        Device("Device"),
        User("User");

        private String nature;

        private PieNature(String nature) {
            this.nature = nature;
        }

        public String getNature() {
            return this.nature;
        }

        public static PieNature parseNature(String nature) {
            if (Device.getNature().equals(nature)) {
                return Device;
            }
            if (User.getNature().equals(nature)) {
                return User;
            }
            return Device;
        }
    }
}

