/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import java.util.HashMap;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;
import org.jensoft.core.view.View;

public class PieFlashAnimator
extends AbstractPieAnimator {
    private View view2D;
    public float alphaMin = 0.0f;
    public float alphaMax = 1.0f;
    private FlashSpeed flashSpeed = FlashSpeed.Default;
    private ShowFlashBehavior showFlashBehavior = ShowFlashBehavior.ShowOnSliceRollover;
    private HashMap<PieSlice, AlphaRunner> cacheAnimator = new HashMap();

    public PieFlashAnimator() {
    }

    public PieFlashAnimator(float alphaMin, float alphaMax) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
    }

    public PieFlashAnimator(float alphaMin, float alphaMax, FlashSpeed flashSpeed) {
        this.alphaMin = alphaMin;
        this.alphaMax = alphaMax;
        this.flashSpeed = flashSpeed;
    }

    public float getAlphaMin() {
        return this.alphaMin;
    }

    public ShowFlashBehavior getShowFlashBehavior() {
        return this.showFlashBehavior;
    }

    public void setShowFlashBehavior(ShowFlashBehavior showFlashBehavior) {
        this.showFlashBehavior = showFlashBehavior;
    }

    public void setAlphaMin(float alphaMin) {
        this.alphaMin = alphaMin;
    }

    public float getAlphaMax() {
        return this.alphaMax;
    }

    public void setAlphaMax(float alphaMax) {
        this.alphaMax = alphaMax;
    }

    @Override
    protected void onPressed(PieSlice slice) {
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSlicePressed) {
            this.view2D = slice.getHost().getHostPlugin().getProjection().getView();
            AlphaRunner runner = (AlphaRunner)this.getAnimator(slice);
            if (!runner.isRunning()) {
                Thread t = new Thread(this.getAnimator(slice));
                runner.setHost(t);
                t.start();
            } else {
                runner.getHost().interrupt();
                slice.setAlpha(runner.getInitialAlpha());
            }
        }
    }

    @Override
    protected void onEntered(PieSlice slice) {
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSliceRollover) {
            this.view2D = slice.getHost().getHostPlugin().getProjection().getView();
            AlphaRunner runner = (AlphaRunner)this.getAnimator(slice);
            if (!runner.isRunning()) {
                Thread t = new Thread(this.getAnimator(slice));
                runner.setHost(t);
                t.start();
            }
        }
    }

    @Override
    protected void onExited(PieSlice slice) {
        AlphaRunner runner;
        if (this.showFlashBehavior == ShowFlashBehavior.ShowOnSliceRollover && (runner = (AlphaRunner)this.getAnimator(slice)).isRunning()) {
            runner.getHost().interrupt();
            slice.setAlpha(runner.getInitialAlpha());
            this.getView(slice).repaintDevice();
        }
    }

    @Override
    public Runnable getAnimator(PieSlice slice) {
        AlphaRunner runner = null;
        if (this.cacheAnimator.get(slice) != null) {
            runner = this.cacheAnimator.get(slice);
        } else {
            runner = new AlphaRunner(slice);
            this.cacheAnimator.put(slice, runner);
        }
        return runner;
    }

    public class AlphaRunner
    implements Runnable {
        private float initialAlpha;
        private PieSlice slice;
        private boolean running = false;
        private Thread host;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public Thread getHost() {
            return this.host;
        }

        public void setHost(Thread host) {
            this.host = host;
        }

        public float getInitialAlpha() {
            return this.initialAlpha;
        }

        public void setInitialAlpha(float initialAlpha) {
            this.initialAlpha = initialAlpha;
        }

        public PieSlice getSlice() {
            return this.slice;
        }

        public void setSlice(PieSlice slice) {
            this.slice = slice;
        }

        public AlphaRunner(PieSlice slice) {
            this.slice = slice;
            this.initialAlpha = slice.getAlpha();
        }

        @Override
        public void run() {
            this.running = true;
            int sleep = 300;
            if (PieFlashAnimator.this.flashSpeed == FlashSpeed.VeryFast) {
                sleep = 100;
            }
            if (PieFlashAnimator.this.flashSpeed == FlashSpeed.Fast) {
                sleep = 200;
            }
            if (PieFlashAnimator.this.flashSpeed == FlashSpeed.Slow) {
                sleep = 400;
            }
            if (PieFlashAnimator.this.flashSpeed == FlashSpeed.VerySlow) {
                sleep = 500;
            }
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.slice.setAlpha(PieFlashAnimator.this.alphaMin);
                    PieFlashAnimator.this.view2D.repaintDevice();
                    Thread.sleep(sleep);
                    this.slice.setAlpha(PieFlashAnimator.this.alphaMax);
                    PieFlashAnimator.this.view2D.repaintDevice();
                    Thread.sleep(sleep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.running = false;
        }
    }

    public static enum ShowFlashBehavior {
        ShowOnSlicePressed,
        ShowOnSliceRollover;

    }

    public static enum FlashSpeed {
        VeryFast,
        Fast,
        Slow,
        VerySlow,
        Default;

    }
}

