/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.animator;

import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.animator.AbstractPieAnimator;

public class PieShiftStartAngleAnimator
extends AbstractPieAnimator {
    private PieShifting pieShifting;

    public void shift(ShiftVelocity velocity) {
        this.interrupt();
        this.pieShifting = new PieShifting(velocity);
        this.pieShifting.start();
    }

    public void interrupt() {
        if (this.pieShifting != null && this.pieShifting.isAlive()) {
            this.pieShifting.interrupt();
        }
    }

    public void interruptShiftingAfter(final int millis) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millis);
                    this.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public void shiftAndInterrupt(ShiftVelocity velocity, int millis) {
        this.shift(velocity);
        this.interruptShiftingAfter(millis);
    }

    @Override
    protected Runnable getAnimator(PieSlice slice) {
        return null;
    }

    class PieShifting
    extends Thread {
        private ShiftVelocity velocity;

        public PieShifting(ShiftVelocity velocity) {
            this.velocity = velocity;
        }

        public ShiftVelocity getVelocity() {
            return this.velocity;
        }

        public void setVelocity(ShiftVelocity velocity) {
            this.velocity = velocity;
        }

        @Override
        public void run() {
            Pie pie = PieShiftStartAngleAnimator.this.getPie();
            try {
                while (!PieShifting.interrupted()) {
                    pie.setStartAngleDegree(pie.getStartAngleDegree() + 1.0);
                    Thread.sleep(this.velocity.getVelocity());
                    pie.getHostPlugin().getProjection().getView().repaintDevice();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum ShiftVelocity {
        Slow(40),
        Default(20),
        Speed(10);

        private int velocity;

        private ShiftVelocity(int velocity) {
            this.velocity = velocity;
        }

        public int getVelocity() {
            return this.velocity;
        }
    }
}

