/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.draw.AbstractPieSliceDraw;

public class PieSliceDefaultDraw
extends AbstractPieSliceDraw {
    private Color drawColor;
    private Stroke drawStroke;
    private Stroke defaultStroke = new BasicStroke();

    public PieSliceDefaultDraw() {
    }

    public PieSliceDefaultDraw(Color drawColor, Stroke drawStroke) {
        this.drawColor = drawColor;
        this.drawStroke = drawStroke;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Stroke getDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(Stroke drawStroke) {
        this.drawStroke = drawStroke;
    }

    @Override
    protected final void paintPieSliceDraw(Graphics2D g2d, Pie pie, PieSlice slice) {
        if (this.drawColor != null) {
            g2d.setColor(this.drawColor);
        } else {
            g2d.setColor(Color.WHITE);
        }
        if (this.drawStroke != null) {
            g2d.setStroke(this.drawStroke);
        } else {
            g2d.setStroke(this.defaultStroke);
        }
        g2d.draw(slice.getSlicePath());
    }
}

