/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectFrame;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectKey;
import org.jensoft.core.plugin.pie.painter.effect.PieSliceCubicEffect;

public class PieCubicEffect
extends AbstractPieEffect {
    private Color startColor;
    private Color endColor;
    private int incidenceAngleDegree = 300;
    private int offsetRadius = 4;
    private PieSliceCubicEffect sectionEffect;
    private CubicEffectKey key;
    private CubicEffectFrame frame;
    private boolean reload = false;

    public PieCubicEffect() {
    }

    public PieCubicEffect(Color startColor, Color endColor, int incidenceAngleDegree) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public PieCubicEffect(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public PieCubicEffect(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
        this.setReload(true);
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
        this.setReload(true);
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
        this.setReload(true);
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
        this.setReload(true);
    }

    public CubicEffectKey getCubicKey() {
        return this.key;
    }

    public void setCubicKey(CubicEffectKey key) {
        this.key = key;
    }

    public CubicEffectFrame getFrame() {
        return this.frame;
    }

    public void setFrame(CubicEffectFrame frame) {
        this.frame = frame;
        this.setCubicKey(frame.getKeyFrame());
    }

    @Override
    public final void paintPieEffect(Graphics2D g2d, Pie pie) {
        if (this.sectionEffect == null || this.reload) {
            this.sectionEffect = new PieSliceCubicEffect(this.startColor, this.endColor, this.incidenceAngleDegree);
            this.sectionEffect.setOffsetRadius(this.offsetRadius);
            if (this.key != null) {
                this.sectionEffect.setCubicKey(this.key);
            }
        }
        for (PieSlice pieSection : pie.getSlices()) {
            this.sectionEffect.paintPieSlice(g2d, pie, pieSection);
        }
    }
}

