/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieSliceEffect;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectKey;

public class PieSliceCubicEffect
extends AbstractPieSliceEffect {
    private Color startColor;
    private Color endColor;
    private int startAngleDelta = 45;
    private int endAngleDelta = 90;
    private float startControlFractionRadius = 0.5f;
    private float endControlFractionRadius = 0.5f;
    private int incidenceAngleDegree = 90;
    private int offsetRadius = 5;

    public PieSliceCubicEffect() {
    }

    public PieSliceCubicEffect(Color startColor, Color endColor, int incidenceAngleDegree) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public PieSliceCubicEffect(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    public PieSliceCubicEffect(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    public void setCubicKey(CubicEffectKey key) {
        this.setStartAngleDelta(key.getStartAngleDelta());
        this.setStartControlFractionRadius(key.getStartControlFractionRadius());
        this.setEndAngleDelta(key.getEndAngleDelta());
        this.setEndControlFractionRadius(key.getEndControlFractionRadius());
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        this.offsetRadius = offsetRadius;
    }

    public int getStartAngleDelta() {
        return this.startAngleDelta;
    }

    public void setStartAngleDelta(int startAngleDelta) {
        if (startAngleDelta < -60 || startAngleDelta > 150) {
            throw new IllegalArgumentException("startAngleDelta out of range [-100,100]");
        }
        this.startAngleDelta = startAngleDelta;
    }

    public int getEndAngleDelta() {
        return this.endAngleDelta;
    }

    public void setEndAngleDelta(int endAngleDelta) {
        if (endAngleDelta < -100 || endAngleDelta > 150) {
            throw new IllegalArgumentException("endAngleDelta out of range [-100,100]");
        }
        this.endAngleDelta = endAngleDelta;
    }

    public float getStartControlFractionRadius() {
        return this.startControlFractionRadius;
    }

    public void setStartControlFractionRadius(float startControlFractionRadius) {
        if (startControlFractionRadius < 0.0f || startControlFractionRadius > 1.0f) {
            throw new IllegalArgumentException("startControlFractionRadius out of range [0,1]");
        }
        this.startControlFractionRadius = startControlFractionRadius;
    }

    public float getEndControlFractionRadius() {
        return this.endControlFractionRadius;
    }

    public void setEndControlFractionRadius(float endControlFractionRadius) {
        if (endControlFractionRadius < 0.0f || endControlFractionRadius > 1.0f) {
            throw new IllegalArgumentException("endControlFractionRadius out of range [0,1]");
        }
        this.endControlFractionRadius = endControlFractionRadius;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setEndColor(Color endColor) {
        this.endColor = endColor;
    }

    public int getIncidenceAngleDegree() {
        return this.incidenceAngleDegree;
    }

    public void setIncidenceAngleDegree(int incidenceAngleDegree) {
        this.incidenceAngleDegree = incidenceAngleDegree;
    }

    @Override
    public final void paintPieSliceEffect(Graphics2D g2d, Pie pie, PieSlice pieSection) {
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        double deltaDegree = pieSection.getPercent() * 360.0;
        double medianDegree = pieSection.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        centerX = c.getX() + (double)pieSection.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - (double)pieSection.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        double radius = pie.getRadius() - (double)this.offsetRadius;
        double controlStartX = centerX + (double)this.startControlFractionRadius * radius * Math.cos(Math.toRadians(this.incidenceAngleDegree + this.startAngleDelta));
        double controlStartY = centerY - (double)this.startControlFractionRadius * radius * Math.sin(Math.toRadians(this.incidenceAngleDegree + this.startAngleDelta));
        double controlEndX = centerX + (double)this.endControlFractionRadius * radius * Math.cos(Math.toRadians(this.incidenceAngleDegree - this.endAngleDelta));
        double controlEndY = centerY - (double)this.endControlFractionRadius * radius * Math.sin(Math.toRadians(this.incidenceAngleDegree - this.endAngleDelta));
        Point2D.Double controlStart = new Point2D.Double(controlStartX, controlStartY);
        Point2D.Double controlStop = new Point2D.Double(controlEndX, controlEndY);
        int extendsDegrees = 140;
        int startAngleDegree = this.incidenceAngleDegree - 70;
        int endAngleDegree = startAngleDegree + extendsDegrees;
        Arc2D.Double arc2d = new Arc2D.Double(centerX - radius, centerY - radius, 2.0 * radius, 2.0 * radius, startAngleDegree, endAngleDegree - startAngleDegree, 0);
        Point2D.Double start = new Point2D.Double(centerX + radius * Math.cos(Math.toRadians(endAngleDegree)), centerY - radius * Math.sin(Math.toRadians(endAngleDegree)));
        Point2D.Double end = new Point2D.Double(centerX + radius * Math.cos(Math.toRadians(startAngleDegree)), centerY - radius * Math.sin(Math.toRadians(startAngleDegree)));
        g2d.setColor(Color.RED);
        CubicCurve2D.Double cubicCurve = new CubicCurve2D.Double(((Point2D)start).getX(), ((Point2D)start).getY(), ((Point2D)controlStart).getX(), ((Point2D)controlStart).getY(), ((Point2D)controlStop).getX(), ((Point2D)controlStop).getY(), ((Point2D)end).getX(), ((Point2D)end).getY());
        GeneralPath path = new GeneralPath();
        path.append(arc2d, false);
        path.append(cubicCurve, true);
        path.closePath();
        Point2D.Double pG1 = new Point2D.Double(path.getBounds().getX() + path.getBounds().getWidth(), path.getBounds().getY() + path.getBounds().getHeight() / 2.0);
        Point2D.Double pG2 = new Point2D.Double(path.getBounds().getX(), path.getBounds().getY() + path.getBounds().getHeight() / 2.0);
        Color cStart = new Color(255, 255, 255, 20);
        Color cEnd = new Color(255, 255, 255, 120);
        if (this.startColor != null) {
            cStart = this.startColor;
        }
        if (this.endColor != null) {
            cEnd = this.endColor;
        }
        if (!pG1.equals(pG2)) {
            GradientPaint gPaint = new GradientPaint(pG1, cStart, pG2, cEnd);
            g2d.setPaint(gPaint);
            Area a1 = new Area(path);
            Area a2 = new Area(pieSection.getSlicePath());
            a2.intersect(a1);
            g2d.fill(a2);
        }
    }
}

