/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieSliceEffect;

public class PieSliceRadialEffect
extends AbstractPieSliceEffect {
    private int offsetRadius = 0;
    private Color[] colors;
    private float[] fractions;
    private int focusRadius = 0;
    private int focusAngle = 270;

    public PieSliceRadialEffect() {
    }

    public PieSliceRadialEffect(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.fractions = fractions;
        this.colors = colors;
    }

    public int getFocusRadius() {
        return this.focusRadius;
    }

    public void setFocusRadius(int focusRadius) {
        this.focusRadius = focusRadius;
    }

    public int getFocusAngle() {
        return this.focusAngle;
    }

    public void setFocusAngle(int focusAngle) {
        this.focusAngle = focusAngle;
    }

    public int getOffsetRadius() {
        return this.offsetRadius;
    }

    public void setOffsetRadius(int offsetRadius) {
        if (offsetRadius < 0) {
            throw new IllegalArgumentException("offset radius should be greater than 0");
        }
        this.offsetRadius = offsetRadius;
    }

    @Override
    public void paintPieSliceEffect(Graphics2D g2d, Pie pie, PieSlice slice) {
        RadialGradientPaint p;
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        double deltaDegree = slice.getPercent() * 360.0;
        double medianDegree = slice.getStartAngleDegree() + deltaDegree / 2.0;
        if (medianDegree > 360.0) {
            medianDegree -= 360.0;
        }
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX() + (double)slice.getDivergence() * Math.cos(Math.toRadians(medianDegree));
        centerY = c.getY() - (double)slice.getDivergence() * Math.sin(Math.toRadians(medianDegree));
        Point2D.Double cent = new Point2D.Double(centerX, centerY);
        double radius = pie.getRadius() - (double)this.offsetRadius;
        double focusX = c.getX() + (double)this.focusRadius * Math.cos(Math.toRadians(this.focusAngle));
        double focusY = c.getY() - (double)this.focusRadius * Math.sin(Math.toRadians(this.focusAngle));
        Point2D.Double focus = new Point2D.Double(focusX, focusY);
        Ellipse2D.Double e1 = new Ellipse2D.Double(centerX - radius, centerY - radius, 2.0 * radius, 2.0 * radius);
        if (this.colors == null && this.fractions == null) {
            float[] dist = new float[]{0.0f, 0.8f, 1.0f};
            Color c1 = new Color(255, 255, 255, 0);
            Color c2 = new Color(255, 255, 255, 120);
            Color c3 = new Color(255, 255, 255, 200);
            Color[] cols = new Color[]{c1, c2, c3};
            p = new RadialGradientPaint(cent, (float)radius, focus, dist, cols, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        } else {
            p = new RadialGradientPaint(cent, (float)radius, focus, this.fractions, this.colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        }
        g2d.setPaint(p);
        Area a1 = new Area(e1);
        Area a2 = new Area(slice.getSlicePath());
        a2.intersect(a1);
        g2d.fill(a2);
    }
}

