/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.pie.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.glyphmetrics.GeometryPath;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;

public class PieBorderLabel
extends AbstractPieSliceLabel {
    private boolean link = true;
    private int margin = 50;
    private LinkStyle linkStyle = LinkStyle.Quad;
    private int linkExtends = 20;
    private Color linkColor;
    private Stroke linkStroke;
    private boolean linkMarker = true;
    private Color linkMarkerFillColor;
    private Color linkMarkerDrawColor;

    public PieBorderLabel() {
    }

    public PieBorderLabel(String label, Color labelColor, Font labelFont) {
        super.setLabel(label);
        super.setLabelColor(labelColor);
        super.setLabelFont(labelFont);
    }

    public PieBorderLabel(String label, Color labelColor) {
        this(label, labelColor, null);
    }

    public PieBorderLabel(String label) {
        this(label, null, null);
    }

    public LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(LinkStyle linkStyle) {
        this.linkStyle = linkStyle;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isLinkMarker() {
        return this.linkMarker;
    }

    public void setLinkMarker(boolean linkMarker) {
        this.linkMarker = linkMarker;
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    public Color getLinkMarkerFillColor() {
        return this.linkMarkerFillColor;
    }

    public void setLinkMarkerFillColor(Color linkMarkerFillColor) {
        this.linkMarkerFillColor = linkMarkerFillColor;
    }

    public Color getLinkMarkerDrawColor() {
        return this.linkMarkerDrawColor;
    }

    public void setLinkMarkerDrawColor(Color linkMarkerDrawColor) {
        this.linkMarkerDrawColor = linkMarkerDrawColor;
    }

    public Stroke getLinkStroke() {
        return this.linkStroke;
    }

    public void setLinkStroke(Stroke linkStroke) {
        this.linkStroke = linkStroke;
    }

    public int getLinkExtends() {
        return this.linkExtends;
    }

    public void setLinkExtends(int linkExtends) {
        this.linkExtends = linkExtends;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    @Override
    protected void paintPieLabel(Graphics2D g2d, Pie pie, PieSlice pieSection) {
        g2d.setColor(pieSection.getThemeColor());
        double percent = pieSection.getPercent() * 100.0;
        String s = this.getDecimalFormat().format(percent) + "%";
        if (this.getLabel() != null) {
            s = this.getLabel();
        }
        if (this.getLabelFont() != null) {
            g2d.setFont(this.getLabelFont());
        }
        FontMetrics fm = g2d.getFontMetrics();
        int widthText = fm.stringWidth(s);
        int ascentText = fm.getAscent();
        int descentText = fm.getDescent();
        double centerX = pie.getCenterX();
        double centerY = pie.getCenterY();
        Point2D c = null;
        if (pie.getPieNature() == Pie.PieNature.User) {
            c = pie.getHostPlugin().getProjection().userToPixel(new Point2D.Double(centerX, centerY));
        }
        if (pie.getPieNature() == Pie.PieNature.Device) {
            c = new Point2D.Double(centerX, centerY);
        }
        centerX = c.getX();
        centerY = c.getY();
        double radius = pie.getRadius();
        double medianDegree = pieSection.getMedianAngleDegree();
        if (medianDegree >= 360.0) {
            medianDegree -= 360.0;
        }
        double px1 = c.getX() + (radius + (double)pieSection.getDivergence()) * Math.cos(Math.toRadians(medianDegree));
        double py1 = c.getY() - (radius + (double)pieSection.getDivergence()) * Math.sin(Math.toRadians(medianDegree));
        double px2 = c.getX() + (radius + (double)this.linkExtends + (double)pieSection.getDivergence()) * Math.cos(Math.toRadians(medianDegree));
        double py2 = c.getY() - (radius + (double)this.linkExtends + (double)pieSection.getDivergence()) * Math.sin(Math.toRadians(medianDegree));
        double px3 = 0.0;
        double py3 = py2;
        px3 = medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0 ? c.getX() + pie.getRadius() + (double)this.margin - (double)this.getLabelPaddingX() - 5.0 : c.getX() - pie.getRadius() - (double)this.margin + (double)this.getLabelPaddingX() + 5.0;
        double px4 = 0.0;
        double py4 = py2;
        px4 = medianDegree >= 270.0 && medianDegree <= 360.0 || medianDegree >= 0.0 && medianDegree <= 90.0 ? c.getX() + pie.getRadius() + (double)this.margin : c.getX() - pie.getRadius() - (double)this.margin - (double)widthText;
        if (this.isLink()) {
            g2d.setColor(pieSection.getThemeColor());
            if (this.linkColor != null) {
                g2d.setColor(this.linkColor);
            }
            if (this.linkStroke != null) {
                g2d.setStroke(this.linkStroke);
            }
            if (this.linkStyle == LinkStyle.Line) {
                Line2D.Double l1 = new Line2D.Double(px1, py1, px2, py2);
                Line2D.Double l2 = new Line2D.Double(px2, py2, px3, py3);
                g2d.draw(l1);
                g2d.draw(l2);
            } else if (this.linkStyle == LinkStyle.Quad) {
                QuadCurve2D.Double quad = new QuadCurve2D.Double(px1, py1, px2, py2, px3, py3);
                g2d.draw(quad);
            }
            if (this.isLinkMarker()) {
                int markerExtends = 10;
                double pxMarker = c.getX() + (radius + (double)markerExtends + (double)pieSection.getDivergence()) * Math.cos(Math.toRadians(medianDegree));
                double pyMarker = c.getY() - (radius + (double)markerExtends + (double)pieSection.getDivergence()) * Math.sin(Math.toRadians(medianDegree));
                GeometryPath geometry = new GeometryPath(new Line2D.Double(pxMarker, pyMarker, px1, py1));
                float angle = geometry.angleAtLength(0.0f);
                int markerOrtho = 3;
                double pxRight = pxMarker - (double)markerOrtho * Math.sin(angle);
                double pyRight = pyMarker + (double)markerOrtho * Math.cos(angle);
                double pxLeft = pxMarker + (double)markerOrtho * Math.sin(angle);
                double pyLeft = pyMarker - (double)markerOrtho * Math.cos(angle);
                GeneralPath e = new GeneralPath();
                e.moveTo(pxRight, pyRight);
                e.lineTo(pxLeft, pyLeft);
                e.lineTo(px1, py1);
                e.closePath();
                if (this.linkMarkerFillColor != null) {
                    g2d.setColor(this.linkMarkerFillColor);
                } else if (this.linkColor != null) {
                    g2d.setColor(this.linkColor);
                } else {
                    g2d.setColor(pieSection.getThemeColor());
                }
                g2d.fill(e);
                if (this.linkMarkerDrawColor != null) {
                    g2d.setColor(this.linkMarkerDrawColor);
                    g2d.draw(e);
                }
            }
        }
        g2d.setColor(pieSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        float x = (float)px4;
        float y = (float)py4;
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x - (float)this.getLabelPaddingX(), y - (float)ascentText - (float)this.getLabelPaddingY(), widthText + 2 * this.getLabelPaddingX(), ascentText + descentText + 2 * this.getLabelPaddingY(), this.getOutlineRound(), this.getOutlineRound());
        if (this.getStyle() == AbstractPieSliceLabel.Style.Fill || this.getStyle() == AbstractPieSliceLabel.Style.Both) {
            if (this.getFillColor() != null && this.getShadeFractions() == null) {
                g2d.setColor(this.getFillColor());
                g2d.fill(rect);
            }
            if (this.getFillColor() == null && this.getShadeFractions() == null) {
                g2d.setColor(pieSection.getThemeColor());
                g2d.fill(rect);
            }
            Point2D.Double start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight());
            Point2D.Double end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY());
            float[] dist2 = new float[]{0.0f, 0.4f, 0.6f, 1.0f};
            Color cStart2 = new Color(40, 40, 40, 80);
            Color cStart2bis = new Color(40, 40, 40, 10);
            Color cEnd2bis = new Color(255, 255, 255, 10);
            Color cEnd2 = new Color(240, 240, 240, 80);
            Color[] colors2 = new Color[]{cStart2, cStart2bis, cEnd2bis, cEnd2};
            if (this.getShadeFractions() != null && this.getShadeColors() != null) {
                colors2 = this.getShadeColors();
                dist2 = this.getShadeFractions();
            }
            if (!start2.equals(end2)) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, dist2, colors2);
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if (this.getStyle() == AbstractPieSliceLabel.Style.Stroke || this.getStyle() == AbstractPieSliceLabel.Style.Both) {
            if (this.getOutlineColor() != null) {
                g2d.setColor(this.getOutlineColor());
            } else {
                g2d.setColor(pieSection.getThemeColor().brighter());
            }
            if (this.getOutlineStroke() != null) {
                g2d.setStroke(this.getOutlineStroke());
            }
            g2d.draw(rect);
        }
        g2d.setColor(pieSection.getThemeColor());
        g2d.setStroke(this.getDefaultStroke());
        g2d.setColor(pieSection.getThemeColor().brighter());
        if (this.getLabelColor() != null) {
            g2d.setColor(this.getLabelColor());
        }
        g2d.drawString(s, x, y);
    }

    public static enum LinkStyle {
        Quad("Quad"),
        Line("Line");

        private String style;

        private LinkStyle(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }

        public static LinkStyle parseStyle(String style) {
            if (Quad.getStyle().equals(style)) {
                return Quad;
            }
            if (Line.getStyle().equals(style)) {
                return Line;
            }
            return Quad;
        }
    }
}

