/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class RadarPlugin
extends AbstractPlugin {
    private List<Radar> radars;

    public RadarPlugin() {
        this.setName(this.getClass().getSimpleName());
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.radars = new ArrayList<Radar>();
    }

    public void addRadar(Radar radar) {
        radar.setHost(this);
        this.radars.add(radar);
    }

    public void removeRadar(Radar radar) {
        radar.setHost(null);
        this.radars.remove(radar);
    }

    @Override
    protected void paintPlugin(View view, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
        for (Radar radar : this.radars) {
            radar.solveGeometry();
            if (radar.getPainter() == null) continue;
            radar.getPainter().paintRadar(g2d, radar);
        }
    }
}

