/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.jensoft.core.glyphmetrics.StylePosition;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricFill;
import org.jensoft.core.glyphmetrics.painter.GlyphMetricMarkerPainter;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.radar.AnchorMetrics;
import org.jensoft.core.plugin.radar.DimensionMetrics;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarDimension;
import org.jensoft.core.plugin.radar.RadarSurface;
import org.jensoft.core.plugin.radar.RadarSurfaceAnchor;
import org.jensoft.core.plugin.radar.RadarView;
import org.jensoft.core.plugin.radar.painter.dimension.DimensionDefaultPainter;
import org.jensoft.core.plugin.radar.painter.label.RadarDimensionDefaultLabel;
import org.jensoft.core.plugin.radar.painter.radar.RadarDefaultPainter;
import org.jensoft.core.plugin.radar.painter.surface.RadarSurfaceDefaultPainter;

public class RadarToolkit
extends Toolkit {
    public static RadarView createCompatibleView() {
        RadarView radarView = new RadarView();
        return radarView;
    }

    public static Radar createRadar(int centerX, int centerY, int radius) {
        Radar radar = new Radar(centerX, centerY, radius);
        radar.setRadarPainter(new RadarDefaultPainter());
        return radar;
    }

    public static RadarDimension createDimension(String name, double angleDegree, double min, double max) {
        RadarDimension dimension = new RadarDimension(name, angleDegree, min, max);
        dimension.setDimensionPainter(new DimensionDefaultPainter());
        return dimension;
    }

    public static RadarDimension createDimension(String name, Color lineColor, double angleDegree, double min, double max) {
        RadarDimension dimension = new RadarDimension(name, lineColor, angleDegree, min, max);
        dimension.setDimensionPainter(new DimensionDefaultPainter());
        return dimension;
    }

    public static void pushDimensions(Radar radar, RadarDimension ... dimensions) {
        for (int i = 0; i < dimensions.length; ++i) {
            radar.addDimension(dimensions[i]);
        }
    }

    public static void pushDimensions(Radar radar, List<RadarDimension> dimensions) {
        for (RadarDimension radarDimension : dimensions) {
            radar.addDimension(radarDimension);
        }
    }

    public static RadarSurface createSurface(String name, Color outlineColor, Color fillColor) {
        RadarSurface surface = new RadarSurface(name);
        surface.setSurfacePainter(new RadarSurfaceDefaultPainter(outlineColor, fillColor));
        return surface;
    }

    public static void pushAnchors(RadarSurface surface, RadarSurfaceAnchor ... anchors) {
        for (int i = 0; i < anchors.length; ++i) {
            surface.addSurfaceAnchor(anchors[i]);
        }
    }

    public static void pushAnchors(RadarSurface surface, List<RadarSurfaceAnchor> anchors) {
        for (RadarSurfaceAnchor anchor : anchors) {
            surface.addSurfaceAnchor(anchor);
        }
    }

    public static RadarDimensionDefaultLabel createDimensionDefaultLabel(String label, Color labelColor, Color outlineColor, float[] fillShaderFraction, Color[] fillShaderColor, int outlineRound) {
        RadarDimensionDefaultLabel l = new RadarDimensionDefaultLabel(label, labelColor);
        l.setOutlineColor(outlineColor);
        l.setShader(fillShaderFraction, fillShaderColor);
        l.setOutlineRound(outlineRound);
        return l;
    }

    public static RadarDimensionDefaultLabel createDimensionDefaultLabel(String label, Font labelFont, Color labelColor, Color outlineColor, float[] fillShaderFraction, Color[] fillShaderColor, int outlineRound) {
        RadarDimensionDefaultLabel l = new RadarDimensionDefaultLabel(label, labelColor);
        l.setLabelFont(labelFont);
        l.setOutlineColor(outlineColor);
        l.setShader(fillShaderFraction, fillShaderColor);
        l.setOutlineRound(outlineRound);
        return l;
    }

    public static RadarSurfaceAnchor createSurfaceAnchor(RadarDimension dimension, String label, double value, StylePosition stylePosition, int divergence, GlyphMetricFill glyphFill, GlyphMetricMarkerPainter glyphMarker, Font metricsFont) {
        AnchorMetrics metric = new AnchorMetrics();
        metric.setValue(value);
        metric.setStylePosition(stylePosition);
        metric.setMetricsLabel(label);
        metric.setDivergence(divergence);
        metric.setGlyphMetricFill(glyphFill);
        metric.setGlyphMetricMarkerPainter(glyphMarker);
        metric.setFont(metricsFont);
        RadarSurfaceAnchor anchor = new RadarSurfaceAnchor(dimension, metric);
        return anchor;
    }

    public static RadarSurfaceAnchor createSurfaceAnchor(RadarDimension dimension, AnchorMetrics anchorMetrics) {
        RadarSurfaceAnchor anchor = new RadarSurfaceAnchor(dimension, anchorMetrics);
        return anchor;
    }

    public static AnchorMetrics createAnchorMetrics(String label, double value, StylePosition stylePosition, int divergence, GlyphMetricFill glyphFill, GlyphMetricMarkerPainter glyphMarker, Font metricsFont) {
        AnchorMetrics metric = new AnchorMetrics();
        metric.setValue(value);
        metric.setStylePosition(stylePosition);
        metric.setMetricsLabel(label);
        metric.setDivergence(divergence);
        metric.setGlyphMetricFill(glyphFill);
        metric.setGlyphMetricMarkerPainter(glyphMarker);
        metric.setFont(metricsFont);
        return metric;
    }

    public static DimensionMetrics createDimensionMetrics(String label, double value, StylePosition stylePosition, int divergence, GlyphMetricFill glyphFill, GlyphMetricMarkerPainter glyphMarker, Font metricsFont) {
        DimensionMetrics metric = new DimensionMetrics();
        metric.setValue(value);
        metric.setStylePosition(stylePosition);
        metric.setMetricsLabel(label);
        metric.setDivergence(divergence);
        metric.setGlyphMetricFill(glyphFill);
        metric.setGlyphMetricMarkerPainter(glyphMarker);
        metric.setFont(metricsFont);
        return metric;
    }

    public static void pushMetricsDimensions(RadarDimension dimension, DimensionMetrics ... dimensionMetrics) {
        for (int i = 0; i < dimensionMetrics.length; ++i) {
            dimension.addMetrics(dimensionMetrics[i]);
        }
    }

    public static void pushMetricsDimensions(RadarDimension dimension, List<DimensionMetrics> dimensionMetrics) {
        for (DimensionMetrics diemsionMetric : dimensionMetrics) {
            dimension.addMetrics(diemsionMetric);
        }
    }
}

